/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.gates;

import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.components.gates.Gate;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class GatePeer<T extends Gate>
extends ComponentPeer<T> {
    private boolean hasNegatedInput = false;

    public GatePeer(Properties props, int x, int y) {
        this(props, x, y, 4, 4);
    }

    public GatePeer(Properties props, int x, int y, int width, int height) {
        super(x, y, width, height);
        String propName;
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.DIRECTION);
        this.ensureProperties(properties);
        properties.mergeIfExists(props);
        int negationCounts = 0;
        while (props.containsProperty(propName = "Negate " + negationCounts++)) {
            Object value = props.getValue(propName);
            boolean negate = value instanceof Boolean ? ((Boolean)value).booleanValue() : value.equals("Yes");
            properties.setProperty(new Properties.Property<Boolean>(propName, Properties.YESNO_VALIDATOR, negate));
        }
        T gate = this.buildGate(properties);
        int gateNum = ((Gate)gate).getNumInputs();
        for (int i = 0; i < Math.max(gateNum, negationCounts); ++i) {
            String propName2 = "Negate " + i;
            if (i < gateNum) {
                boolean negate = false;
                if (!properties.containsProperty(propName2)) {
                    properties.setProperty(new Properties.Property<Boolean>(propName2, Properties.YESNO_VALIDATOR, false));
                } else {
                    negate = (Boolean)properties.getProperty((String)propName2).value;
                }
                if (i == 0) {
                    properties.getProperty((String)propName2).display = properties.getProperty((String)propName2).display + " Top/Left";
                } else if (i == gateNum - 1) {
                    properties.getProperty((String)propName2).display = properties.getProperty((String)propName2).display + " Bottom/Right";
                }
                if (!negate || this.hasNegatedInput) continue;
                this.hasNegatedInput = true;
                this.setWidth(width + 1);
                continue;
            }
            properties.clearProperty(propName2);
        }
        GuiUtils.rotateElementSize(this, Properties.Direction.EAST, properties.getValue(Properties.DIRECTION));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        int inputOffset = 0;
        switch (properties.getValue(Properties.DIRECTION)) {
            case WEST: {
                inputOffset = this.getWidth();
            }
            case EAST: {
                int i;
                for (i = 0; i < gateNum; ++i) {
                    int add = gateNum % 2 == 0 && i >= gateNum / 2 ? 3 : 2;
                    connections.add(new Connection.PortConnection(this, ((Component)gate).getPort(i), inputOffset, i + add - gateNum / 2 - (gateNum == 1 ? 1 : 0)));
                }
                connections.add(new Connection.PortConnection(this, ((Component)gate).getPort(gateNum), this.getWidth() - inputOffset, this.getHeight() / 2));
                break;
            }
            case NORTH: {
                inputOffset = this.getHeight();
            }
            case SOUTH: {
                int i;
                for (i = 0; i < gateNum; ++i) {
                    int add = gateNum % 2 == 0 && i >= gateNum / 2 ? 3 : 2;
                    connections.add(new Connection.PortConnection(this, ((Component)gate).getPort(i), i + add - gateNum / 2 - (gateNum == 1 ? 1 : 0), inputOffset));
                }
                connections.add(new Connection.PortConnection(this, ((Component)gate).getPort(gateNum), this.getWidth() / 2, this.getHeight() - inputOffset));
            }
        }
        this.init(gate, properties, connections);
    }

    protected static boolean[] parseNegatedInputs(int inputs, Properties properties) {
        boolean[] negated = new boolean[inputs];
        for (int i = 0; i < negated.length; ++i) {
            negated[i] = properties.getValueOrDefault("Negate " + i, Boolean.valueOf(false));
        }
        return negated;
    }

    protected abstract void ensureProperties(Properties var1);

    public abstract T buildGate(Properties var1);

    @Override
    public final void paint(GraphicsContext graphics, CircuitState circuitState) {
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        for (int i = 0; i < this.getConnections().size() - 1; ++i) {
            if (!((Gate)this.getComponent()).getNegateInputs()[i]) continue;
            Connection.PortConnection c = this.getConnections().get(i);
            int x = c.getX() * 10;
            int y = c.getY() * 10;
            switch (this.getProperties().getValue(Properties.DIRECTION)) {
                case WEST: {
                    x -= 10;
                }
                case EAST: {
                    y = (int)((double)y - 5.0);
                    break;
                }
                case NORTH: {
                    y -= 10;
                }
                case SOUTH: {
                    x = (int)((double)x - 5.0);
                }
            }
            graphics.fillOval((double)x, (double)y, 10.0, 10.0);
            graphics.strokeOval((double)x, (double)y, 10.0, 10.0);
        }
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        GuiUtils.rotateGraphics(this, graphics, this.getProperties().getValue(Properties.DIRECTION));
        if (this.hasNegatedInput) {
            graphics.translate(10.0, 0.0);
        }
        this.paintGate(graphics, circuitState);
    }

    public abstract void paintGate(GraphicsContext var1, CircuitState var2);
}

