/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.gates;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.gates.ControlledBuffer;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class ControlledBufferPeer
extends ComponentPeer<ControlledBuffer> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Gates", (Object)"Buffer"), new Image(ControlledBufferPeer.class.getResourceAsStream("/resources/Buffer.png")), new Properties());
    }

    public ControlledBufferPeer(Properties props, int x, int y) {
        super(x, y, 2, 2);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.DIRECTION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.mergeIfExists(props);
        ControlledBuffer buffer = new ControlledBuffer(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, buffer.getPort(0), "In", 0, this.getHeight() / 2));
        connections.add(new Connection.PortConnection(this, buffer.getPort(1), "Enable", this.getWidth() / 2, this.getHeight()));
        connections.add(new Connection.PortConnection(this, buffer.getPort(2), "Out", this.getWidth(), this.getHeight() / 2));
        GuiUtils.rotatePorts(connections, Properties.Direction.EAST, properties.getValue(Properties.DIRECTION));
        this.init(buffer, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        GuiUtils.rotateGraphics(this, graphics, this.getProperties().getValue(Properties.DIRECTION));
        graphics.beginPath();
        graphics.moveTo((double)this.getScreenX(), (double)this.getScreenY());
        graphics.lineTo((double)(this.getScreenX() + this.getScreenWidth()), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.5);
        graphics.lineTo((double)this.getScreenX(), (double)(this.getScreenY() + this.getScreenHeight()));
        graphics.closePath();
        graphics.setFill((Paint)Color.WHITE);
        graphics.fill();
        graphics.setStroke((Paint)Color.BLACK);
        graphics.stroke();
    }
}

