/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.gates;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.peers.gates.GatePeer;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.gates.AndGate;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class AndGatePeer
extends GatePeer<AndGate> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Gates", (Object)"AND"), new Image(AndGatePeer.class.getResourceAsStream("/resources/AndGate.png")), new Properties());
    }

    public AndGatePeer(Properties properties, int x, int y) {
        super(properties, x, y);
    }

    @Override
    protected void ensureProperties(Properties properties) {
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(Properties.NUM_INPUTS);
    }

    @Override
    public AndGate buildGate(Properties properties) {
        int numInputs = properties.getValue(Properties.NUM_INPUTS);
        return new AndGate(properties.getValue(Properties.LABEL), (int)properties.getValue(Properties.BITSIZE), numInputs, AndGatePeer.parseNegatedInputs(numInputs, properties));
    }

    @Override
    public void paintGate(GraphicsContext graphics, CircuitState circuitState) {
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = 40;
        int height = 40;
        graphics.beginPath();
        graphics.moveTo((double)x, (double)y);
        graphics.lineTo((double)x, (double)(y + height));
        graphics.arc((double)x + (double)width * 0.5, (double)y + (double)height * 0.5, (double)width * 0.5, (double)height * 0.5, 270.0, 180.0);
        graphics.closePath();
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        graphics.fill();
        graphics.stroke();
    }
}

