/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.arithmetic;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.arithmetic.Shifter;
import java.util.ArrayList;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class ShifterPeer
extends ComponentPeer<Shifter> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Arithmetic", (Object)"Shifter"), new Image(ShifterPeer.class.getResourceAsStream("/resources/Shifter.png")), new Properties());
    }

    public ShifterPeer(Properties props, int x, int y) {
        super(x, y, 4, 4);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(new Properties.Property<Shifter.ShiftType>("Shift Type", new Properties.PropertyListValidator<Shifter.ShiftType>(Shifter.ShiftType.values(), t -> t.toString().replace('_', ' ')), Shifter.ShiftType.LOGICAL_LEFT));
        properties.mergeIfExists(props);
        Shifter shifter = new Shifter(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE), (Shifter.ShiftType)((Object)properties.getValue("Shift Type")));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, shifter.getPort(0), "In", 0, 1));
        connections.add(new Connection.PortConnection(this, shifter.getPort(1), "Shift", 0, 3));
        connections.add(new Connection.PortConnection(this, shifter.getPort(2), "Out", 4, 2));
        this.init(shifter, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState state) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setFill((Paint)Color.BLACK);
        graphics.setLineWidth(1.5);
        int x = this.getScreenX();
        int y = this.getScreenY();
        int width = this.getScreenWidth();
        int height = this.getScreenHeight();
        Shifter.ShiftType shiftType = (Shifter.ShiftType)((Object)this.getProperties().getValue("Shift Type"));
        boolean rotateRight = false;
        switch (shiftType) {
            case ROTATE_LEFT: {
                graphics.strokeLine((double)(x + width - 5), (double)y + (double)height * 0.5, (double)(x + width - 5), (double)y + (double)height * 0.5 - 10.0);
                graphics.strokeLine((double)(x + width - 15), (double)y + (double)height * 0.5 - 10.0, (double)(x + width - 5), (double)y + (double)height * 0.5 - 10.0);
            }
            case LOGICAL_LEFT: {
                graphics.strokeLine((double)(x + width - 15), (double)y + (double)height * 0.5, (double)(x + width - 5), (double)y + (double)height * 0.5);
                graphics.strokeLine((double)(x + width - 10), (double)y + (double)height * 0.5 - 5.0, (double)(x + width - 15), (double)y + (double)height * 0.5);
                graphics.strokeLine((double)(x + width - 10), (double)y + (double)height * 0.5 + 5.0, (double)(x + width - 15), (double)y + (double)height * 0.5);
                break;
            }
            case ROTATE_RIGHT: {
                rotateRight = true;
                graphics.strokeLine((double)(x + width - 15), (double)y + (double)height * 0.5, (double)(x + width - 15), (double)y + (double)height * 0.5 - 10.0);
                graphics.strokeLine((double)(x + width - 15), (double)y + (double)height * 0.5 - 10.0, (double)(x + width - 5), (double)y + (double)height * 0.5 - 10.0);
            }
            case ARITHMETIC_RIGHT: {
                if (!rotateRight) {
                    graphics.strokeLine((double)(x + width - 20), (double)y + (double)height * 0.5, (double)(x + width - 18), (double)y + (double)height * 0.5);
                }
            }
            case LOGICAL_RIGHT: {
                graphics.strokeLine((double)(x + width - 15), (double)y + (double)height * 0.5, (double)(x + width - 5), (double)y + (double)height * 0.5);
                graphics.strokeLine((double)(x + width - 10), (double)y + (double)height * 0.5 - 5.0, (double)(x + width - 5), (double)y + (double)height * 0.5);
                graphics.strokeLine((double)(x + width - 10), (double)y + (double)height * 0.5 + 5.0, (double)(x + width - 5), (double)y + (double)height * 0.5);
            }
        }
    }
}

