/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.arithmetic;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.arithmetic.RandomGenerator;
import java.util.ArrayList;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class RandomGeneratorPeer
extends ComponentPeer<RandomGenerator> {
    private final Connection.PortConnection clockConnection;

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Arithmetic", (Object)"Random Generator"), new Image(RandomGeneratorPeer.class.getResourceAsStream("/resources/RandomGenerator.png")), new Properties());
    }

    public RandomGeneratorPeer(Properties props, int x, int y) {
        super(x, y, 4, 4);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.mergeIfExists(props);
        RandomGenerator randomGenerator = new RandomGenerator(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        this.clockConnection = new Connection.PortConnection(this, randomGenerator.getPort(0), "Clock", 2, 4);
        connections.add(this.clockConnection);
        connections.add(new Connection.PortConnection(this, randomGenerator.getPort(1), "Out", 4, 2));
        this.init(randomGenerator, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setFont(GuiUtils.getFont(16, true));
        Bounds bounds = GuiUtils.getBounds(graphics.getFont(), "RNG");
        graphics.setFill((Paint)Color.BLACK);
        graphics.fillText("RNG", (double)this.getScreenX() + ((double)this.getScreenWidth() - bounds.getWidth()) * 0.5, (double)this.getScreenY() + ((double)this.getScreenHeight() + bounds.getHeight()) * 0.45);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawClockInput(graphics, this.clockConnection, Properties.Direction.SOUTH);
    }
}

