/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.arithmetic;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.arithmetic.Comparator;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class ComparatorPeer
extends ComponentPeer<Comparator> {
    private static final Properties.Property<Boolean> USE_SIGNED_COMPARE = new Properties.Property<Boolean>("Comparison Type", new Properties.PropertyListValidator<Boolean>(Arrays.asList(true, false), s -> s != false ? "2's complement" : "Unsigned"), true);

    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Arithmetic", (Object)"Comparator"), new Image(ComparatorPeer.class.getResourceAsStream("/resources/Comparator.png")), new Properties());
    }

    public ComparatorPeer(Properties props, int x, int y) {
        super(x, y, 4, 4);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.ensureProperty(USE_SIGNED_COMPARE);
        properties.mergeIfExists(props);
        Comparator comparator = new Comparator(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE), properties.getValue(USE_SIGNED_COMPARE));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, comparator.getPort(0), "A", 0, 1));
        connections.add(new Connection.PortConnection(this, comparator.getPort(1), "B", 0, 3));
        connections.add(new Connection.PortConnection(this, comparator.getPort(2), "A < B", this.getWidth(), 1));
        connections.add(new Connection.PortConnection(this, comparator.getPort(3), "A = B", this.getWidth(), 2));
        connections.add(new Connection.PortConnection(this, comparator.getPort(4), "A > B", this.getWidth(), 3));
        this.init(comparator, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setStroke((Paint)Color.BLACK);
        graphics.setFill((Paint)Color.WHITE);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setFont(GuiUtils.getFont(12, true));
        graphics.setFill((Paint)Color.BLACK);
        graphics.fillText("<", (double)(this.getScreenX() + this.getScreenWidth() - 12), (double)(this.getScreenY() + 12));
        graphics.fillText("=", (double)(this.getScreenX() + this.getScreenWidth() - 12), (double)(this.getScreenY() + 24));
        graphics.fillText(">", (double)(this.getScreenX() + this.getScreenWidth() - 12), (double)(this.getScreenY() + 35));
    }
}

