/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.arithmetic;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.arithmetic.BitExtender;
import java.util.ArrayList;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class BitExtenderPeer
extends ComponentPeer<BitExtender> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Arithmetic", (Object)"Bit Extender"), new Image(BitExtenderPeer.class.getResourceAsStream("/resources/BitExtender.png")), new Properties());
    }

    public BitExtenderPeer(Properties props, int x, int y) {
        super(x, y, 4, 4);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(new Properties.Property<Integer>("Input Bitsize", Properties.BITSIZE.validator, 1));
        properties.ensureProperty(new Properties.Property<Integer>("Output Bitsize", Properties.BITSIZE.validator, 1));
        properties.ensureProperty(new Properties.Property<BitExtender.ExtensionType>("Extension Type", new Properties.PropertyListValidator<BitExtender.ExtensionType>(BitExtender.ExtensionType.values()), BitExtender.ExtensionType.ZERO));
        properties.mergeIfExists(props);
        BitExtender extender = new BitExtender(properties.getValue(Properties.LABEL), (Integer)properties.getValue("Input Bitsize"), (Integer)properties.getValue("Output Bitsize"), (BitExtender.ExtensionType)((Object)properties.getValue("Extension Type")));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, extender.getPort(0), "Input", 0, 2));
        connections.add(new Connection.PortConnection(this, extender.getPort(1), "Output", this.getWidth(), 2));
        this.init(extender, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setStroke((Paint)Color.BLACK);
        graphics.setFill((Paint)Color.WHITE);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setFont(GuiUtils.getFont(12, true));
        graphics.setFill((Paint)Color.BLACK);
        graphics.fillText(String.valueOf(((BitExtender)this.getComponent()).getInputBitSize()), (double)(this.getScreenX() + 3), (double)this.getScreenY() + (double)this.getScreenHeight() * 0.5 + 5.0);
        String outputString = String.valueOf(((BitExtender)this.getComponent()).getOutputBitSize());
        Bounds outputBounds = GuiUtils.getBounds(graphics.getFont(), outputString);
        graphics.fillText(outputString, (double)(this.getScreenX() + this.getScreenWidth()) - outputBounds.getWidth() - 3.0, (double)this.getScreenY() + (double)this.getScreenHeight() * 0.5 + 5.0);
        String typeString = "";
        switch (((BitExtender)this.getComponent()).getExtensionType()) {
            case ZERO: {
                typeString = "0";
                break;
            }
            case ONE: {
                typeString = "1";
                break;
            }
            case SIGN: {
                typeString = "sign";
            }
        }
        Bounds typeBounds = GuiUtils.getBounds(graphics.getFont(), typeString);
        graphics.fillText(typeString, (double)this.getScreenX() + ((double)this.getScreenWidth() - typeBounds.getWidth()) * 0.5, (double)this.getScreenY() + typeBounds.getHeight());
        graphics.setFont(GuiUtils.getFont(10, true));
        String extendString = "extend";
        Bounds extendBounds = GuiUtils.getBounds(graphics.getFont(), extendString);
        graphics.fillText(extendString, (double)this.getScreenX() + ((double)this.getScreenWidth() - extendBounds.getWidth()) * 0.5, (double)(this.getScreenY() + this.getScreenHeight() - 5));
    }
}

