/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers.arithmetic;

import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.components.arithmetic.Adder;
import java.util.ArrayList;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class AdderPeer
extends ComponentPeer<Adder> {
    public static void installComponent(ComponentManager.ComponentManagerInterface manager) {
        manager.addComponent((Pair<String, String>)new Pair((Object)"Arithmetic", (Object)"Adder"), new Image(AdderPeer.class.getResourceAsStream("/resources/Adder.png")), new Properties());
    }

    public AdderPeer(Properties props, int x, int y) {
        super(x, y, 4, 4);
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.ensureProperty(Properties.BITSIZE);
        properties.mergeIfExists(props);
        Adder adder = new Adder(properties.getValue(Properties.LABEL), properties.getValue(Properties.BITSIZE));
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        connections.add(new Connection.PortConnection(this, adder.getPort(0), "A", 0, 1));
        connections.add(new Connection.PortConnection(this, adder.getPort(1), "B", 0, 3));
        connections.add(new Connection.PortConnection(this, adder.getPort(2), "Carry in", 2, 0));
        connections.add(new Connection.PortConnection(this, adder.getPort(3), "Out", this.getWidth(), 2));
        connections.add(new Connection.PortConnection(this, adder.getPort(4), "Carry out", 2, this.getHeight()));
        this.init(adder, properties, connections);
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setFont(GuiUtils.getFont(16, true));
        Bounds bounds = GuiUtils.getBounds(graphics.getFont(), "+");
        graphics.setFill((Paint)Color.BLACK);
        graphics.fillText("+", (double)this.getScreenX() + ((double)this.getScreenWidth() - bounds.getWidth()) * 0.5, (double)this.getScreenY() + ((double)this.getScreenHeight() + bounds.getHeight()) * 0.45);
    }
}

