/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui.peers;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.peers.wiring.PinPeer;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.SimulationException;
import com.ra4king.circuitsim.simulator.components.Subcircuit;
import com.ra4king.circuitsim.simulator.components.wiring.Pin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.MenuItem;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class SubcircuitPeer
extends ComponentPeer<Subcircuit> {
    public static final String SUBCIRCUIT = "Subcircuit";
    private boolean mouseEntered = false;

    public SubcircuitPeer(Properties props, int x, int y) {
        super(x, y, 0, 0);
        int connY;
        int connX;
        int i;
        Properties properties = new Properties();
        properties.ensureProperty(Properties.LABEL);
        properties.ensureProperty(Properties.LABEL_LOCATION);
        properties.mergeIfExists(props);
        Properties.Property subcircuitProperty = props.getProperty(SUBCIRCUIT);
        properties.setProperty(subcircuitProperty);
        CircuitManager subcircuitManager = (CircuitManager)subcircuitProperty.value;
        if (subcircuitManager == null) {
            throw new SimulationException("Circuit does not exist");
        }
        Subcircuit subcircuit = new Subcircuit(properties.getValue(Properties.LABEL), subcircuitManager.getCircuit());
        ArrayList<Connection.PortConnection> connections = new ArrayList<Connection.PortConnection>();
        List pins = subcircuitManager.getCircuitBoard().getComponents().stream().filter(componentPeer -> componentPeer instanceof PinPeer).map(componentPeer -> (PinPeer)componentPeer).collect(Collectors.toList());
        List eastPins = pins.stream().filter(pin -> pin.getProperties().getValue(Properties.DIRECTION) == Properties.Direction.EAST).sorted((o1, o2) -> {
            int diff = o1.getY() - o2.getY();
            if (diff == 0) {
                return o1.getX() - o2.getX();
            }
            return diff;
        }).collect(Collectors.toList());
        List westPins = pins.stream().filter(pin -> pin.getProperties().getValue(Properties.DIRECTION) == Properties.Direction.WEST).sorted((o1, o2) -> {
            int diff = o1.getY() - o2.getY();
            if (diff == 0) {
                return o1.getX() - o2.getX();
            }
            return diff;
        }).collect(Collectors.toList());
        List northPins = pins.stream().filter(pin -> pin.getProperties().getValue(Properties.DIRECTION) == Properties.Direction.NORTH).sorted((o1, o2) -> {
            int diff = o1.getX() - o2.getX();
            if (diff == 0) {
                return o1.getY() - o2.getY();
            }
            return diff;
        }).collect(Collectors.toList());
        List southPins = pins.stream().filter(pin -> pin.getProperties().getValue(Properties.DIRECTION) == Properties.Direction.SOUTH).sorted((o1, o2) -> {
            int diff = o1.getX() - o2.getX();
            if (diff == 0) {
                return o1.getY() - o2.getY();
            }
            return diff;
        }).collect(Collectors.toList());
        if (pins.size() != subcircuit.getNumPorts()) {
            throw new IllegalStateException("Pin count and ports count don't match? " + pins.size() + " vs " + subcircuit.getNumPorts());
        }
        this.setWidth(Math.max(3, Math.max(northPins.size(), southPins.size()) + 1));
        this.setHeight(Math.max(3, Math.max(eastPins.size(), westPins.size()) + 1));
        for (i = 0; i < eastPins.size(); ++i) {
            connX = 0;
            connY = i + 1;
            connections.add(new Connection.PortConnection(this, subcircuit.getPort((Pin)((PinPeer)eastPins.get(i)).getComponent()), ((Pin)((PinPeer)eastPins.get(i)).getComponent()).getName(), connX, connY));
        }
        for (i = 0; i < westPins.size(); ++i) {
            connX = this.getWidth();
            connY = i + 1;
            connections.add(new Connection.PortConnection(this, subcircuit.getPort((Pin)((PinPeer)westPins.get(i)).getComponent()), ((Pin)((PinPeer)westPins.get(i)).getComponent()).getName(), connX, connY));
        }
        for (i = 0; i < northPins.size(); ++i) {
            connX = i + 1;
            connY = this.getHeight();
            connections.add(new Connection.PortConnection(this, subcircuit.getPort((Pin)((PinPeer)northPins.get(i)).getComponent()), ((Pin)((PinPeer)northPins.get(i)).getComponent()).getName(), connX, connY));
        }
        for (i = 0; i < southPins.size(); ++i) {
            connX = i + 1;
            connY = 0;
            connections.add(new Connection.PortConnection(this, subcircuit.getPort((Pin)((PinPeer)southPins.get(i)).getComponent()), ((Pin)((PinPeer)southPins.get(i)).getComponent()).getName(), connX, connY));
        }
        this.init(subcircuit, properties, connections);
    }

    public void switchToSubcircuit(CircuitManager circuit) {
        circuit.getSimulatorWindow().switchToCircuit(((Subcircuit)this.getComponent()).getSubcircuit(), ((Subcircuit)this.getComponent()).getSubcircuitState(circuit.getCircuitBoard().getCurrentState()));
    }

    @Override
    public List<MenuItem> getContextMenuItems(CircuitManager circuit) {
        MenuItem view = new MenuItem("View internal state");
        view.setOnAction(event -> this.switchToSubcircuit(circuit));
        return Collections.singletonList(view);
    }

    @Override
    public void mouseEntered(CircuitManager manager, CircuitState state) {
        this.mouseEntered = true;
    }

    @Override
    public void mouseExited(CircuitManager manager, CircuitState state) {
        this.mouseEntered = false;
    }

    @Override
    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.drawName(graphics, this, this.getProperties().getValue(Properties.LABEL_LOCATION));
        graphics.setFill((Paint)Color.WHITE);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).fillRect(arg_0, arg_1, arg_2, arg_3), this);
        graphics.setStroke((Paint)Color.BLACK);
        GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), this);
        if (this.mouseEntered) {
            double width = this.getScreenWidth();
            double height = this.getScreenHeight();
            graphics.setLineWidth(1.5);
            graphics.strokeOval((double)this.getScreenX() + (width - 13.0) / 2.0, (double)this.getScreenY() + (height - 13.0) / 2.0, 13.0, 13.0);
            graphics.setLineWidth(2.5);
            graphics.strokeLine((double)this.getScreenX() + width / 2.0 + 4.6, (double)this.getScreenY() + height / 2.0 + 4.6, (double)this.getScreenX() + width / 2.0 + 10.0, (double)this.getScreenY() + height / 2.0 + 10.0);
        }
    }
}

