/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.CircuitSim;
import com.ra4king.circuitsim.gui.JavaFXCompatibilityWrapper;
import com.ra4king.circuitsim.simulator.SimulationException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableObjectValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class Properties {
    private Map<String, Property<?>> properties = new LinkedHashMap();
    public static final PropertyValidator<String> ANY_STRING_VALIDATOR = value -> value;
    public static final PropertyValidator<Boolean> YESNO_VALIDATOR = new PropertyListValidator<Boolean>(new Boolean[]{true, false}, bool -> bool != false ? "Yes" : "No");
    public static final PropertyValidator<Integer> INTEGER_VALIDATOR = value -> {
        try {
            return (int)Long.parseLong(value);
        }
        catch (NumberFormatException exc) {
            String modified = value.startsWith("0x") ? value.substring(2) : (value.startsWith("x") ? value.substring(1) : value);
            try {
                return (int)Long.parseLong(modified, 16);
            }
            catch (NumberFormatException exc2) {
                throw new SimulationException(value + " is not a valid integer.");
            }
        }
    };
    public static final PropertyListValidator<Boolean> LOCATION_VALIDATOR = new PropertyListValidator<Boolean>(Arrays.asList(true, false), bool -> bool != false ? "Left/Top" : "Right/Down");
    public static final PropertyValidator<Color> COLOR_VALIDATOR = new PropertyValidator<Color>(){

        @Override
        public Color parse(String value) {
            return Color.valueOf((String)value);
        }

        @Override
        public Node createGui(Stage stage, Color value, Consumer<Color> onAction) {
            ColorPicker picker = new ColorPicker(value);
            picker.setOnAction(event -> onAction.accept((Color)picker.getValue()));
            return picker;
        }
    };
    public static final Property<String> LABEL = new Property<String>("Label", ANY_STRING_VALIDATOR, "");
    public static final Property<Direction> LABEL_LOCATION = new Property<Direction>("Label location", new PropertyListValidator<Direction>(Direction.values()), Direction.NORTH);
    public static final Property<Integer> BITSIZE;
    public static final Property<Integer> NUM_INPUTS;
    public static final Property<Integer> ADDRESS_BITS;
    public static final Property<Integer> SELECTOR_BITS;
    public static final Property<Direction> DIRECTION;
    public static final Property<Boolean> SELECTOR_LOCATION;

    public Properties() {
    }

    public Properties(Property<?> ... props) {
        this();
        for (Property<?> prop : props) {
            this.setProperty(prop);
        }
    }

    public Properties(Properties prop) {
        this();
        this.union(prop);
    }

    public List<String> getProperties() {
        return new ArrayList<String>(this.properties.keySet());
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public boolean containsProperty(Property<?> property) {
        return this.containsProperty(property.name);
    }

    public void forEach(Consumer<Property<?>> consumer) {
        this.properties.values().forEach(consumer);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public void ensureProperty(Property<?> property) {
        this.setProperty(property, false);
    }

    public void setProperty(Property<?> property) {
        this.setProperty(property, true);
    }

    public void clearProperty(String name) {
        this.properties.remove(name);
    }

    private <T> void setProperty(Property<T> property, boolean overwriteValue) {
        if (!this.properties.containsKey(property.name)) {
            this.properties.put(property.name, property);
        } else if (this.getProperty((String)property.name).validator == null) {
            this.parseAndSetValue(property, this.getProperty((String)property.name).value.toString());
        } else if (property.validator == null) {
            this.parseAndSetValue(this.getProperty(property.name), property.value.toString());
        } else {
            Property<T> ourProperty = this.getProperty(property.name);
            PropertyValidator validator = this.chooseValidator(property.validator, ourProperty.validator);
            Object value = overwriteValue ? (property.value == null ? ourProperty.value : property.value) : (ourProperty.value == null ? property.value : ourProperty.value);
            this.properties.put(property.name, new Property(property.name, validator, value));
        }
    }

    public <T> void parseAndSetValue(Property<T> property, String value) {
        this.setValue(property, property.validator.parse(value));
    }

    public void parseAndSetValue(String property, String value) {
        this.parseAndSetValue(this.getProperty(property), value);
    }

    public <T> void parseAndSetValue(String property, PropertyValidator<T> validator, String value) {
        this.parseAndSetValue(new Property<Object>(property, validator, null), value);
    }

    public <T> void setValue(Property<T> property, T value) {
        this.properties.put(property.name, new Property<T>(property, value));
    }

    public void updateIfExists(Property<?> property) {
        if (this.properties.containsKey(property.name)) {
            this.setProperty(property, true);
        }
    }

    public <T> Property<T> getProperty(String name) {
        return this.properties.get(name);
    }

    public <T> T getValue(Property<T> property) {
        return this.getValue(property.name);
    }

    public <T> T getValue(String name) {
        return this.getValueOrDefault(name, null);
    }

    public <T> T getValueOrDefault(Property<T> property, T defaultValue) {
        return this.getValueOrDefault(property.name, defaultValue);
    }

    public <T> T getValueOrDefault(String name, T defaultValue) {
        if (this.properties.containsKey(name)) {
            return this.getProperty((String)name).value;
        }
        return defaultValue;
    }

    private <T> PropertyValidator<T> chooseValidator(PropertyValidator<T> v1, PropertyValidator<T> v2) {
        if (v1 != null && v2 != null && !v1.equals(v2)) {
            throw new IllegalArgumentException("Property with the same name but different validator!");
        }
        return v1 == null ? v2 : v1;
    }

    public Properties mergeIfExists(Properties other) {
        other.forEach(this::updateIfExists);
        return this;
    }

    public Properties union(Properties other) {
        other.forEach(this::setProperty);
        return this;
    }

    public Properties intersect(Properties properties) {
        Properties newProp = new Properties();
        this.forEach(prop -> {
            if (properties.properties.containsKey(prop.name)) {
                if (!Objects.equals(this.getValue((Property)prop), properties.getValue((Property)prop))) {
                    newProp.setValue((Property)prop, null);
                } else {
                    newProp.setProperty((Property<?>)prop);
                }
            }
        });
        return newProp;
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Properties) {
            Properties props = (Properties)other;
            return this.properties.equals(props.properties);
        }
        return false;
    }

    static {
        ArrayList<Integer> numInputsValues = new ArrayList<Integer>();
        for (int i = 2; i <= 32; ++i) {
            numInputsValues.add(i);
        }
        NUM_INPUTS = new Property<Integer>("Number of Inputs", new PropertyListValidator(numInputsValues), 2);
        ArrayList<Integer> bitSizeValues = new ArrayList<Integer>();
        for (int i = 1; i <= 32; ++i) {
            bitSizeValues.add(i);
        }
        BITSIZE = new Property<Integer>("Bitsize", new PropertyListValidator(bitSizeValues), 1);
        DIRECTION = new Property<Direction>("Direction", new PropertyListValidator<Direction>(Direction.values()), Direction.EAST);
        ArrayList<Integer> addressBits = new ArrayList<Integer>();
        for (int i = 1; i <= 16; ++i) {
            addressBits.add(i);
        }
        ADDRESS_BITS = new Property<Integer>("Address bits", new PropertyListValidator(addressBits), 8);
        ArrayList<Integer> selBits = new ArrayList<Integer>();
        for (int i = 1; i <= 8; ++i) {
            selBits.add(i);
        }
        SELECTOR_BITS = new Property<Integer>("Selector bits", new PropertyListValidator(selBits), 1);
        SELECTOR_LOCATION = new Property<Boolean>("Selector location", LOCATION_VALIDATOR, false);
    }

    public static class MemoryLine {
        public final int address;
        public final List<StringProperty> values;

        public MemoryLine(int address) {
            this.address = address;
            this.values = new ArrayList<StringProperty>(16);
        }

        public StringProperty get(int index) {
            if (index < this.values.size()) {
                return this.values.get(index);
            }
            return new SimpleStringProperty("");
        }

        public String toString() {
            return String.join((CharSequence)" ", this.values.stream().map(WritableObjectValue::get).collect(Collectors.toList()));
        }
    }

    public static class PropertyMemoryValidator
    implements PropertyValidator<List<MemoryLine>> {
        private final int addressBits;
        private final int dataBits;

        public PropertyMemoryValidator(int addressBits, int dataBits) {
            this.addressBits = addressBits;
            this.dataBits = dataBits;
        }

        public String parseValue(int value) {
            if (this.dataBits < 32) {
                value &= (1 << this.dataBits) - 1;
            }
            return String.format("%0" + (1 + (this.dataBits - 1) / 4) + "x", value);
        }

        public int parseValue(String value) {
            try {
                return Integer.parseUnsignedInt(value, 16);
            }
            catch (NumberFormatException exc) {
                throw new SimulationException("Cannot parse invalid hex value: " + value);
            }
        }

        public boolean equals(Object other) {
            if (other instanceof PropertyMemoryValidator) {
                PropertyMemoryValidator validator = (PropertyMemoryValidator)other;
                return validator.addressBits == this.addressBits && validator.dataBits == this.dataBits;
            }
            return false;
        }

        public List<MemoryLine> parse(int[] values, BiConsumer<Integer, Integer> memoryListener) {
            ArrayList<MemoryLine> lines = new ArrayList<MemoryLine>();
            int address = 0;
            MemoryLine currLine = null;
            for (int value : values) {
                if (currLine == null) {
                    currLine = new MemoryLine(address);
                }
                SimpleStringProperty prop = new SimpleStringProperty(this.parseValue(value));
                if (memoryListener != null) {
                    MemoryLine currMemoryLine = currLine;
                    int currSize = currMemoryLine.values.size();
                    prop.addListener((observable, oldValue, newValue) -> memoryListener.accept(currMemoryLine.address + currSize, this.parseValue((String)newValue)));
                }
                currLine.values.add((StringProperty)prop);
                if (currLine.values.size() != 16) continue;
                lines.add(currLine);
                currLine = null;
                address += 16;
            }
            while (address < 1 << this.addressBits) {
                if (currLine == null) {
                    currLine = new MemoryLine(address);
                }
                currLine.values.add((StringProperty)new SimpleStringProperty("0"));
                if (currLine.values.size() != 16) continue;
                lines.add(currLine);
                currLine = null;
                address += 16;
            }
            if (currLine != null) {
                lines.add(currLine);
            }
            return lines;
        }

        @Override
        public List<MemoryLine> parse(String contents) {
            return this.parse(this.parsePartial(contents), null);
        }

        private int[] parsePartial(String contents) {
            int length;
            int[] values = new int[1 << this.addressBits];
            Scanner scanner = new Scanner(contents);
            for (length = 0; length < values.length && scanner.hasNext(); ++length) {
                String piece = scanner.next();
                if (piece.matches("^\\d+-[\\da-fA-F]+$")) {
                    String[] split = piece.split("-");
                    int count = Integer.parseInt(split[0]);
                    int val = this.parseValue(split[1]);
                    for (int j = 0; j < count && length < values.length; ++j, ++length) {
                        values[length] = val;
                    }
                    --length;
                    continue;
                }
                values[length] = this.parseValue(piece);
            }
            return Arrays.copyOf(values, length);
        }

        @Override
        public String toString(List<MemoryLine> lines) {
            String values = String.join((CharSequence)" ", lines.stream().map(MemoryLine::toString).collect(Collectors.toList()));
            String[] split = values.split(" ");
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < split.length) {
                int count = 1;
                while (i + count < split.length && split[i].equals(split[i + count])) {
                    ++count;
                }
                if (count == 1) {
                    builder.append(split[i]);
                } else {
                    builder.append(count).append('-').append(split[i]);
                }
                if ((i += count) >= split.length) continue;
                builder.append(' ');
            }
            return builder.length() < values.length() ? builder.toString() : values;
        }

        @Override
        public Node createGui(Stage stage, List<MemoryLine> value, Consumer<List<MemoryLine>> onAction) {
            Button button = new Button("Click to edit");
            button.setOnAction(event -> {
                List<MemoryLine> lines = value == null ? this.parse(new int[0], null) : value;
                this.createAndShowMemoryWindow(stage, lines);
                onAction.accept(lines);
            });
            return button;
        }

        private void copyMemoryValues(List<MemoryLine> dest, List<MemoryLine> src) {
            for (int i = 0; i < src.size(); ++i) {
                MemoryLine srcLine = src.get(i);
                MemoryLine tableLine = dest.get(i);
                for (int j = 0; j < srcLine.values.size() && j < tableLine.values.size(); ++j) {
                    tableLine.values.get(j).set(srcLine.values.get(j).get());
                }
            }
        }

        public void createAndShowMemoryWindow(Stage stage, final List<MemoryLine> lines) {
            Stage memoryStage = new Stage();
            memoryStage.initOwner((Window)stage);
            memoryStage.setTitle("Modify memory");
            TableView tableView = new TableView();
            tableView.getSelectionModel().setCellSelectionEnabled(true);
            tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
            tableView.setEditable(true);
            JavaFXCompatibilityWrapper.tableDisableColumnReordering(tableView);
            TableColumn address = new TableColumn("Address");
            address.setStyle("-fx-alignment: CENTER-RIGHT; -fx-background-color: lightgray;");
            address.setSortable(false);
            address.setEditable(false);
            address.setCellValueFactory(param -> new SimpleStringProperty(String.format("%0" + (1 + (this.addressBits - 1) / 4) + "x", ((MemoryLine)param.getValue()).address)));
            tableView.getColumns().add((Object)address);
            int columns = Math.min(1 << this.addressBits, 16);
            for (int i = 0; i < columns; ++i) {
                final int j = i;
                TableColumn column = new TableColumn(String.format("%x", i));
                column.setStyle("-fx-alignment: CENTER;");
                column.setSortable(false);
                column.setEditable(true);
                column.setCellValueFactory(param -> ((MemoryLine)param.getValue()).get(j));
                column.setCellFactory(c -> new TableCell<MemoryLine, String>(){
                    private TextField textField;
                    private String oldText;

                    public void startEdit() {
                        this.oldText = this.getText();
                        super.startEdit();
                        this.setText(null);
                        this.textField = new TextField(this.oldText);
                        this.textField.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                            if (event.getCode() == KeyCode.ESCAPE) {
                                this.textField.setText(this.oldText);
                            }
                            if (event.getCode() == KeyCode.ENTER) {
                                this.cancelEdit();
                            }
                        });
                        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                            if (!newValue.booleanValue()) {
                                this.cancelEdit();
                            }
                        });
                        this.setGraphic((Node)this.textField);
                        this.textField.selectAll();
                        this.textField.requestFocus();
                    }

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null) {
                            if (this.textField != null) {
                                this.updateText(this.textField.getText());
                            } else {
                                this.setText(null);
                            }
                        } else {
                            this.updateText(item);
                        }
                        this.setGraphic(null);
                    }

                    public void cancelEdit() {
                        super.cancelEdit();
                        this.updateText(this.textField.getText());
                        this.setGraphic(null);
                    }

                    private void updateText(String newText) {
                        String newValue;
                        try {
                            newValue = this.parseValue(this.parseValue(newText));
                        }
                        catch (SimulationException exc) {
                            newValue = this.oldText;
                        }
                        this.setText(newValue);
                        if (this.getTableRow() != null) {
                            ((MemoryLine)lines.get((int)this.getTableRow().getIndex())).values.get(j).set((Object)newValue);
                        }
                    }
                });
                tableView.getColumns().add((Object)column);
            }
            tableView.setItems(FXCollections.observableList(lines));
            Button loadButton = new Button("Load from file");
            loadButton.setOnAction(event -> {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Choose save file");
                fileChooser.setInitialDirectory(new File(System.getProperty("user.dir")));
                File selectedFile = fileChooser.showOpenDialog((Window)memoryStage);
                if (selectedFile != null) {
                    try {
                        String contents = new String(Files.readAllBytes(selectedFile.toPath()));
                        this.copyMemoryValues(lines, (List<MemoryLine>)this.parse(contents));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        new Alert(Alert.AlertType.ERROR, "Could not open file: " + exc.getMessage(), new ButtonType[0]).showAndWait();
                    }
                }
            });
            Button saveButton = new Button("Save to file");
            saveButton.setOnAction(event -> {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Choose save file");
                fileChooser.setInitialFileName("Memory.dat");
                File selectedFile = fileChooser.showSaveDialog((Window)memoryStage);
                if (selectedFile != null) {
                    List strings = lines.stream().map(MemoryLine::toString).collect(Collectors.toList());
                    try {
                        Files.write(selectedFile.toPath(), strings, new OpenOption[0]);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        new Alert(Alert.AlertType.ERROR, "Could not open file: " + exc.getMessage(), new ButtonType[0]).showAndWait();
                    }
                }
            });
            Button clearButton = new Button("Clear contents");
            clearButton.setOnAction(event -> lines.forEach(line -> line.values.forEach(value -> value.set((Object)"0"))));
            memoryStage.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
                if (keyEvent.isShortcutDown()) {
                    if (keyEvent.getCode() == KeyCode.C) {
                        ClipboardContent content = new ClipboardContent();
                        StringBuilder ramContent = new StringBuilder();
                        for (TablePosition selectedCell : tableView.getSelectionModel().getSelectedCells()) {
                            if (selectedCell.getColumn() <= 0) continue;
                            ramContent.append((String)((MemoryLine)lines.get((int)selectedCell.getRow())).values.get(selectedCell.getColumn() - 1).get()).append(" ");
                        }
                        content.putString(ramContent.toString());
                        Clipboard.getSystemClipboard().setContent((Map)content);
                        return;
                    } else {
                        String clipboard;
                        if (keyEvent.getCode() != KeyCode.V || (clipboard = Clipboard.getSystemClipboard().getString()) == null) return;
                        try {
                            ObservableList selectedCells = tableView.getSelectionModel().getSelectedCells();
                            int[] values = this.parsePartial(clipboard);
                            if (selectedCells.size() <= 1) {
                                int col;
                                TablePosition selectedCell = selectedCells.isEmpty() ? null : (TablePosition)selectedCells.get(0);
                                int row = selectedCell == null ? 0 : selectedCell.getRow();
                                int n = col = selectedCell == null ? 0 : selectedCell.getColumn() - 1;
                                if (col < 0) return;
                                for (int value : values) {
                                    ((MemoryLine)lines.get(row)).get(col).set((Object)this.parseValue(value));
                                    if (++col != ((MemoryLine)lines.get((int)0)).values.size() - 1) continue;
                                    col = 0;
                                    if (++row == lines.size()) return;
                                }
                                return;
                            }
                            for (int i = 0; i < selectedCells.size() && i < values.length; ++i) {
                                TablePosition selectedCell = (TablePosition)selectedCells.get(i);
                                if (selectedCell.getColumn() <= 0) continue;
                                ((MemoryLine)lines.get((int)selectedCell.getRow())).values.get(selectedCell.getColumn() - 1).set((Object)this.parseValue(values[i]));
                            }
                            return;
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                            new Alert(Alert.AlertType.ERROR, "Invalid clipboard data: " + exc.getMessage(), new ButtonType[0]).showAndWait();
                            return;
                        }
                    }
                } else if (keyEvent.getCode() == KeyCode.DELETE || keyEvent.getCode() == KeyCode.BACK_SPACE) {
                    for (TablePosition selectedCell : tableView.getSelectionModel().getSelectedCells()) {
                        if (selectedCell.getColumn() <= 0) continue;
                        ((MemoryLine)lines.get((int)selectedCell.getRow())).values.get(selectedCell.getColumn() - 1).set((Object)this.parseValue(0));
                    }
                    return;
                } else {
                    if (tableView.getEditingCell() != null || !keyEvent.getCode().isLetterKey() && !keyEvent.getCode().isDigitKey()) return;
                    TablePosition focusedCellPosition = tableView.getFocusModel().getFocusedCell();
                    tableView.edit(focusedCellPosition.getRow(), focusedCellPosition.getTableColumn());
                }
            });
            VBox.setVgrow((Node)tableView, (Priority)Priority.ALWAYS);
            Platform.runLater(() -> ((TableView)tableView).refresh());
            memoryStage.setScene(new Scene((Parent)new VBox(new Node[]{new HBox(new Node[]{loadButton, saveButton, clearButton}), tableView})));
            memoryStage.sizeToScene();
            memoryStage.showAndWait();
        }
    }

    public static class PropertyCircuitValidator
    implements PropertyValidator<CircuitManager> {
        private final CircuitSim circuitSim;
        private CircuitManager circuitManager;

        public PropertyCircuitValidator(CircuitSim circuitSim) {
            this(circuitSim, null);
        }

        public PropertyCircuitValidator(CircuitSim circuitSim, CircuitManager circuitManager) {
            this.circuitSim = circuitSim;
            this.circuitManager = circuitManager;
        }

        public int hashCode() {
            return ((Object)((Object)this.circuitSim)).hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof PropertyCircuitValidator) {
                PropertyCircuitValidator validator = (PropertyCircuitValidator)other;
                return this.circuitSim == validator.circuitSim;
            }
            return false;
        }

        @Override
        public CircuitManager parse(String value) {
            if (this.circuitManager == null && this.circuitSim != null) {
                this.circuitManager = this.circuitSim.getCircuitManager(value);
                return this.circuitManager;
            }
            return this.circuitManager;
        }

        @Override
        public String toString(CircuitManager circuit) {
            return this.circuitSim.getCircuitName(circuit);
        }

        @Override
        public Node createGui(Stage stage, CircuitManager value, Consumer<CircuitManager> onAction) {
            return null;
        }
    }

    public static class PropertyListValidator<T>
    implements PropertyValidator<T> {
        private final List<T> validValues;
        private final Function<T, String> toString;

        public PropertyListValidator(T[] validValues) {
            this(Arrays.asList(validValues));
        }

        public PropertyListValidator(List<T> validValues) {
            this(validValues, Object::toString);
        }

        public PropertyListValidator(T[] validValues, Function<T, String> toString) {
            this(Arrays.asList(validValues), toString);
        }

        public PropertyListValidator(List<T> validValues, Function<T, String> toString) {
            this.validValues = Collections.unmodifiableList(validValues);
            this.toString = toString;
        }

        public List<T> getValidValues() {
            return this.validValues;
        }

        public int hashCode() {
            List values = this.validValues.stream().map(this.toString).collect(Collectors.toList());
            return this.validValues.hashCode() ^ values.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof PropertyListValidator) {
                PropertyListValidator validator = (PropertyListValidator)other;
                return this.validValues.equals(validator.validValues);
            }
            return true;
        }

        @Override
        public T parse(String value) {
            for (T t : this.validValues) {
                if (!this.toString.apply(t).equals(value)) continue;
                return t;
            }
            throw new IllegalArgumentException("Value not found: " + value);
        }

        @Override
        public String toString(T value) {
            return value == null ? "" : this.toString.apply(value);
        }

        @Override
        public Node createGui(Stage stage, T value, Consumer<T> onAction) {
            ComboBox valueList = new ComboBox();
            for (T t : this.validValues) {
                valueList.getItems().add((Object)this.toString.apply(t));
            }
            valueList.setValue((Object)this.toString(value));
            valueList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.equals(oldValue)) {
                    try {
                        onAction.accept(this.parse((String)newValue));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
            return valueList;
        }
    }

    public static interface PropertyValidator<T> {
        public T parse(String var1);

        default public String toString(T value) {
            return value == null ? "" : value.toString();
        }

        default public Node createGui(Stage stage, T value, Consumer<T> onAction) {
            TextField valueField = new TextField(this.toString(value));
            Runnable updateValue = () -> {
                String newValue = valueField.getText();
                if (!newValue.equals(value)) {
                    try {
                        onAction.accept(this.parse(newValue));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        valueField.setText(this.toString(value));
                    }
                }
            };
            valueField.setOnAction(event -> updateValue.run());
            valueField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    updateValue.run();
                }
            });
            return valueField;
        }
    }

    public static class Property<T> {
        public final String name;
        public String display;
        public final PropertyValidator<T> validator;
        public final T value;

        public Property(Property<T> property) {
            this(property.name, property.display, property.validator, property.value);
        }

        public Property(Property<T> property, T value) {
            this(property.name, property.validator, value);
        }

        public Property(String name, PropertyValidator<T> validator, T value) {
            this(name, name, validator, value);
        }

        public Property(String name, String displayName, PropertyValidator<T> validator, T value) {
            this.name = name;
            this.display = displayName;
            this.validator = validator;
            this.value = value;
        }

        public String getStringValue() {
            return this.validator == null ? (String)this.value : this.validator.toString(this.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.validator, this.value);
        }

        public boolean equals(Object other) {
            if (other instanceof Property) {
                Property prop = (Property)other;
                return this.name.equals(prop.name) && this.validator.equals(prop.validator) && Objects.equals(this.value, prop.value);
            }
            return false;
        }
    }

    public static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

