/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.LinkWires;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.util.Pair;

public class PathFinding {
    private static final Cost INFINITY = new Cost(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public static Pair<Set<LinkWires.Wire>, Set<Point>> bestPath(int sx, int sy, int dx, int dy, ValidWireLocation valid) {
        if (dx < 0 || dy < 0) {
            return new Pair(Collections.emptySet(), Collections.emptySet());
        }
        Point source = new Point(sx, sy, null);
        Point destination = new Point(dx, dy, null);
        HashSet<Point> closedSet = new HashSet<Point>();
        HashMap<Point, Point> cameFrom = new HashMap<Point, Point>();
        HashMap<Point, Cost> gScore = new HashMap<Point, Cost>();
        HashMap<Point, Integer> fScore = new HashMap<Point, Integer>();
        HashSet<Point> openSet = new HashSet<Point>();
        openSet.add(source);
        gScore.put(source, new Cost(0, 0));
        fScore.put(source, destination.estimateCost(source));
        int iterations = 0;
        while (!openSet.isEmpty()) {
            if (Thread.currentThread().isInterrupted()) {
                return new Pair(Collections.emptySet(), closedSet);
            }
            if (++iterations == 5000) {
                System.err.println("Path finding taking too long, bail...");
                return new Pair(Collections.emptySet(), closedSet);
            }
            Point current = null;
            for (Point point : openSet) {
                if (current != null && fScore.getOrDefault(point, Integer.MAX_VALUE) >= fScore.getOrDefault(current, Integer.MAX_VALUE)) continue;
                current = point;
            }
            if (current == null) {
                throw new IllegalStateException("Impossible");
            }
            openSet.remove(current);
            if (current.equalsIgnoreDirection(destination)) {
                return new Pair(PathFinding.constructPath(cameFrom, current), closedSet);
            }
            closedSet.add(current);
            for (Direction direction : Direction.values) {
                Cost currentCost;
                Cost totalCost;
                if (direction.isOpposite(current.direction)) continue;
                Point neighbor = direction.move(current);
                if (neighbor.x < 0 || neighbor.y < 0 || closedSet.contains(neighbor)) continue;
                LocationPreference preference = valid.isValidWireLocation(neighbor.x, neighbor.y, direction == Direction.RIGHT || direction == Direction.LEFT);
                if (preference == LocationPreference.INVALID) continue;
                int additionalLength = preference == LocationPreference.PREFER ? 0 : 1;
                int additionalTurns = 0;
                if (current.direction != null && direction != current.direction) {
                    additionalTurns = neighbor.x == destination.x || neighbor.y == destination.y ? 1 : 2;
                }
                if ((totalCost = new Cost((currentCost = (Cost)gScore.get(current)).length + additionalLength, currentCost.turns + additionalTurns)).compareTo(gScore.getOrDefault(neighbor, INFINITY)) >= 0) continue;
                cameFrom.put(neighbor, current);
                gScore.put(neighbor, totalCost);
                int estimateCost = destination.estimateCost(neighbor) + totalCost.length + 50 * totalCost.turns;
                fScore.put(neighbor, estimateCost);
                openSet.add(neighbor);
            }
        }
        System.err.println("No possible paths found...");
        return null;
    }

    private static Set<LinkWires.Wire> constructPath(Map<Point, Point> cameFrom, Point current) {
        HashSet<LinkWires.Wire> totalPath = new HashSet<LinkWires.Wire>();
        Point lastEndpoint = current;
        while (cameFrom.containsKey(current)) {
            Point next = cameFrom.get(current);
            if (!(lastEndpoint.x == current.x && current.x == next.x || lastEndpoint.y == current.y && current.y == next.y)) {
                int len = current.x - lastEndpoint.x + (current.y - lastEndpoint.y);
                totalPath.add(new LinkWires.Wire(null, lastEndpoint.x, lastEndpoint.y, len, lastEndpoint.y == current.y));
                lastEndpoint = current;
            }
            current = next;
        }
        int len = current.x - lastEndpoint.x + (current.y - lastEndpoint.y);
        if (len != 0) {
            totalPath.add(new LinkWires.Wire(null, lastEndpoint.x, lastEndpoint.y, len, lastEndpoint.y == current.y));
        }
        return totalPath;
    }

    private static class Cost
    implements Comparable<Cost> {
        private final int length;
        private final int turns;

        Cost(int length, int turns) {
            this.length = length;
            this.turns = turns;
        }

        @Override
        public int compareTo(Cost other) {
            int turns = this.turns - other.turns;
            if (turns != 0) {
                return turns;
            }
            return this.length - other.length;
        }

        public int hashCode() {
            return this.length + (this.turns << 13);
        }

        public boolean equals(Object other) {
            if (other instanceof Cost) {
                Cost element = (Cost)other;
                return element.length == this.length && element.turns == this.turns;
            }
            return false;
        }

        public String toString() {
            return "Cost(length = " + this.length + ", turns = " + this.turns + ")";
        }
    }

    public static class Point {
        public final int x;
        public final int y;
        private final Direction direction;

        Point(int x, int y, Direction direction) {
            this.x = x;
            this.y = y;
            this.direction = direction;
        }

        public int estimateCost(Point other) {
            int dx = this.x - other.x;
            int dy = this.y - other.y;
            return dx * dx + dy * dy;
        }

        public int hashCode() {
            return this.x + (this.y << 13) + (this.direction == null ? 0 : this.direction.hashCode() << 19);
        }

        public boolean equals(Object other) {
            if (other instanceof Point) {
                Point element = (Point)other;
                return element.x == this.x && element.y == this.y && element.direction == this.direction;
            }
            return false;
        }

        public boolean equalsIgnoreDirection(Point point) {
            return point.x == this.x && point.y == this.y;
        }

        public String toString() {
            return "Point(x = " + this.x + ", y = " + this.y + ", direction = " + (Object)((Object)this.direction) + ")";
        }
    }

    private static enum Direction {
        RIGHT{

            @Override
            public Point move(Point point) {
                return new Point(point.x + 1, point.y, RIGHT);
            }

            @Override
            public boolean isOpposite(Direction other) {
                return other == LEFT;
            }
        }
        ,
        LEFT{

            @Override
            public Point move(Point point) {
                return new Point(point.x - 1, point.y, LEFT);
            }

            @Override
            public boolean isOpposite(Direction other) {
                return other == RIGHT;
            }
        }
        ,
        DOWN{

            @Override
            public Point move(Point point) {
                return new Point(point.x, point.y + 1, DOWN);
            }

            @Override
            public boolean isOpposite(Direction other) {
                return other == UP;
            }
        }
        ,
        UP{

            @Override
            public Point move(Point point) {
                return new Point(point.x, point.y - 1, UP);
            }

            @Override
            public boolean isOpposite(Direction other) {
                return other == DOWN;
            }
        };

        public static final Direction[] values;

        public abstract Point move(Point var1);

        public abstract boolean isOpposite(Direction var1);

        static {
            values = Direction.values();
        }
    }

    public static interface ValidWireLocation {
        public LocationPreference isValidWireLocation(int var1, int var2, boolean var3);
    }

    public static enum LocationPreference {
        INVALID,
        VALID,
        PREFER;

    }
}

