/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiElement;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.SimulationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javafx.scene.canvas.GraphicsContext;

public class LinkWires {
    private Set<Connection.PortConnection> ports = new HashSet<Connection.PortConnection>();
    private Set<Connection.PortConnection> invalidPorts = new HashSet<Connection.PortConnection>();
    private Set<Wire> wires = new HashSet<Wire>();
    private Exception lastException;

    public boolean isLinkValid() {
        return this.invalidPorts.isEmpty();
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public boolean isEmpty() {
        return this.ports.size() + this.invalidPorts.size() <= 1 && this.wires.size() == 0;
    }

    public Port.Link getLink() {
        return this.ports.size() > 0 ? this.ports.iterator().next().getPort().getLink() : null;
    }

    public synchronized void addWire(Wire wire) {
        wire.setLinkWires(this);
        this.wires.add(wire);
    }

    public synchronized void removeWire(Wire wire) {
        if (this.wires.contains(wire)) {
            wire.setLinkWires(null);
            this.wires.remove(wire);
        }
    }

    public Set<Wire> getWires() {
        return this.wires;
    }

    public Set<LinkWires> splitWires(Set<Wire> toRemove) {
        LinkWires linkWires;
        toRemove.forEach(wire -> wire.setLinkWires(null));
        this.wires.removeAll(toRemove);
        Port.Link link = this.getLink();
        if (link != null) {
            for (Connection.PortConnection port : this.ports) {
                link.unlinkPort(port.getPort());
            }
        }
        HashSet<LinkWires> newLinkWires = new HashSet<LinkWires>();
        while (!this.wires.isEmpty()) {
            Wire nextWire = this.wires.iterator().next();
            this.wires.remove(nextWire);
            linkWires = this.findAttachedConnections(nextWire);
            linkWires.addWire(nextWire);
            newLinkWires.add(linkWires);
        }
        HashSet<Connection.PortConnection> portsLeft = new HashSet<Connection.PortConnection>(this.ports);
        portsLeft.addAll(this.invalidPorts);
        while (portsLeft.size() != 0) {
            linkWires = new LinkWires();
            Connection.PortConnection nextPort = (Connection.PortConnection)portsLeft.iterator().next();
            portsLeft.remove(nextPort);
            this.removePort(nextPort);
            linkWires.addPort(nextPort);
            Iterator iter = portsLeft.iterator();
            while (iter.hasNext()) {
                Connection.PortConnection otherPort = (Connection.PortConnection)iter.next();
                if (nextPort.getX() != otherPort.getX() || nextPort.getY() != otherPort.getY()) continue;
                iter.remove();
                this.removePort(otherPort);
                linkWires.addPort(otherPort);
            }
            if (linkWires.isEmpty()) {
                linkWires.clear();
                continue;
            }
            newLinkWires.add(linkWires);
        }
        return newLinkWires;
    }

    private static boolean connsEqual(Connection conn1, Connection conn2) {
        return conn1.getX() == conn2.getX() && conn1.getY() == conn2.getY();
    }

    private LinkWires findAttachedConnections(Wire wire) {
        LinkWires linkWires = new LinkWires();
        Connection start = wire.getStartConnection();
        Connection end = wire.getEndConnection();
        Iterator<Wire> iter = this.wires.iterator();
        while (iter.hasNext()) {
            Wire w = iter.next();
            Connection wStart = w.getStartConnection();
            Connection wEnd = w.getEndConnection();
            if (!LinkWires.connsEqual(start, wStart) && !LinkWires.connsEqual(start, wEnd) && !LinkWires.connsEqual(end, wStart) && !LinkWires.connsEqual(end, wEnd)) continue;
            linkWires.addWire(w);
            iter.remove();
        }
        for (Wire attachedWire : new ArrayList<Wire>(linkWires.getWires())) {
            linkWires.merge(this.findAttachedConnections(attachedWire));
        }
        HashSet<Connection.PortConnection> allPorts = new HashSet<Connection.PortConnection>();
        allPorts.addAll(this.ports);
        allPorts.addAll(this.invalidPorts);
        allPorts.forEach(port -> {
            for (Connection c : wire.getConnections()) {
                if (port.getX() != c.getX() || port.getY() != c.getY()) continue;
                this.removePort((Connection.PortConnection)port);
                linkWires.addPort((Connection.PortConnection)port);
                break;
            }
        });
        return linkWires;
    }

    public void addPort(Connection.PortConnection port) {
        port.setLinkWires(this);
        if (this.ports.size() > 0) {
            Port.Link link = this.getLink();
            try {
                link.linkPort(port.getPort());
            }
            catch (Exception exc) {
                this.invalidPorts.add(port);
                this.lastException = exc;
                return;
            }
        }
        this.ports.add(port);
    }

    public Set<Connection.PortConnection> getPorts() {
        return this.ports;
    }

    public Set<Connection.PortConnection> getInvalidPorts() {
        return this.invalidPorts;
    }

    public void removePort(Connection.PortConnection port) {
        if (!this.ports.contains(port)) {
            if (this.invalidPorts.remove(port)) {
                port.setLinkWires(null);
                port.getPort().getLink().unlinkPort(port.getPort());
            }
            return;
        }
        this.getLink().unlinkPort(port.getPort());
        this.ports.remove(port);
        port.setLinkWires(null);
        if (this.ports.isEmpty()) {
            HashSet<Connection.PortConnection> invalidPorts = new HashSet<Connection.PortConnection>(this.invalidPorts);
            this.invalidPorts.clear();
            for (Connection.PortConnection invalid : invalidPorts) {
                this.addPort(invalid);
            }
        }
    }

    public void clear() {
        Stream.concat(new HashSet<Connection.PortConnection>(this.ports).stream(), new HashSet<Connection.PortConnection>(this.invalidPorts).stream()).forEach(this::removePort);
        new HashSet<Wire>(this.wires).forEach(this::removeWire);
    }

    public LinkWires merge(LinkWires other) {
        if (other == this) {
            return this;
        }
        other.ports.forEach(this::addPort);
        other.invalidPorts.forEach(this::addPort);
        other.wires.forEach(this::addWire);
        return this;
    }

    public static class Wire
    extends GuiElement {
        private LinkWires linkWires;
        private int length;
        private boolean horizontal;
        private List<Connection> connections = new ArrayList<Connection>();

        public Wire(Wire wire) {
            this(wire.linkWires, wire);
        }

        public Wire(LinkWires linkWires, Wire wire) {
            this(linkWires, wire.getX(), wire.getY(), wire.getLength(), wire.isHorizontal());
        }

        public Wire(LinkWires linkWires, int startX, int startY, int length, boolean horizontal) {
            super(startX, startY, horizontal ? Math.abs(length) : 0, horizontal ? 0 : Math.abs(length));
            this.setLinkWires(linkWires);
            if (length == 0) {
                throw new SimulationException("Length cannot be 0");
            }
            if (length < 0) {
                if (horizontal) {
                    this.setX(startX + length);
                } else {
                    this.setY(startY + length);
                }
                this.length = length = -length;
            } else {
                this.length = length;
            }
            this.horizontal = horizontal;
            int xOffset = horizontal ? 1 : 0;
            int yOffset = horizontal ? 0 : 1;
            for (int i = 0; i < length; ++i) {
                this.connections.add(new Connection.WireConnection(this, i * xOffset, i * yOffset));
            }
            this.connections.add(new Connection.WireConnection(this, length * xOffset, length * yOffset));
        }

        @Override
        public int getScreenX() {
            return super.getScreenX() - 1;
        }

        @Override
        public int getScreenY() {
            return super.getScreenY() - 1;
        }

        @Override
        public int getScreenWidth() {
            return this.horizontal ? super.getScreenWidth() + 2 : 2;
        }

        @Override
        public int getScreenHeight() {
            return this.horizontal ? 2 : super.getScreenHeight() + 2;
        }

        public LinkWires getLinkWires() {
            return this.linkWires;
        }

        public void setLinkWires(LinkWires linkWires) {
            if (linkWires == null) {
                linkWires = new LinkWires();
                linkWires.addWire(this);
            }
            this.linkWires = linkWires;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isHorizontal() {
            return this.horizontal;
        }

        public boolean isWithin(Wire wire) {
            return wire.horizontal == this.horizontal && this.getX() >= wire.getX() && this.getX() + this.getWidth() <= wire.getX() + wire.getWidth() && this.getY() >= wire.getY() && this.getY() + this.getHeight() <= wire.getY() + wire.getHeight();
        }

        public boolean overlaps(Wire wire) {
            return wire.horizontal == this.horizontal && (wire.horizontal ? wire.getY() == this.getY() && wire.getX() < this.getX() + this.getLength() && this.getX() < wire.getX() + wire.getLength() : wire.getX() == this.getX() && wire.getY() < this.getY() + this.getLength() && this.getY() < wire.getY() + wire.getLength());
        }

        public Connection getStartConnection() {
            return this.connections.get(0);
        }

        public Connection getEndConnection() {
            return this.connections.get(this.connections.size() - 1);
        }

        public List<Connection> getConnections() {
            return this.connections;
        }

        public int hashCode() {
            return this.getX() ^ this.getY() << 7 ^ (this.horizontal ? 16384 : 0) ^ this.length << 15;
        }

        public boolean equals(Object other) {
            if (other instanceof Wire) {
                Wire wire = (Wire)other;
                return this.getX() == wire.getX() && this.getY() == wire.getY() && this.horizontal == wire.horizontal && this.length == wire.length;
            }
            return false;
        }

        public String toString() {
            return "Wire(x = " + this.getX() + ", y = " + this.getY() + ", length = " + this.getLength() + ", horizontal = " + this.isHorizontal() + ")";
        }

        @Override
        public void paint(GraphicsContext graphics, CircuitState circuitState) {
            this.paint(graphics, circuitState, 2.0);
        }

        public void paint(GraphicsContext graphics) {
            this.paint(graphics, 2.0);
        }

        public void paint(GraphicsContext graphics, CircuitState circuitState, double width) {
            GuiUtils.setBitColor(graphics, circuitState, this.linkWires);
            this.paint(graphics, width);
        }

        public void paint(GraphicsContext graphics, double width) {
            graphics.setLineWidth(width);
            graphics.strokeLine((double)super.getScreenX(), (double)super.getScreenY(), (double)(super.getScreenX() + super.getScreenWidth()), (double)(super.getScreenY() + super.getScreenHeight()));
        }
    }
}

