/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiElement;
import com.ra4king.circuitsim.gui.LinkWires;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.WireValue;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.geometry.Bounds;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class GuiUtils {
    public static final int BLOCK_SIZE = 10;
    private static Map<FontInfo, Font> fonts = new HashMap<FontInfo, Font>();
    private static Map<Font, Map<String, Bounds>> boundsSeen = new HashMap<Font, Map<String, Bounds>>();
    private static final Color ONE_COLOR = Color.GREEN.brighter();
    private static final Color ZERO_COLOR = Color.GREEN.darker();
    private static final Color X_1BIT_COLOR = Color.BLUE;
    private static final Color X_MULTIBIT_COLOR = Color.BLUE.darker();

    private GuiUtils() {
    }

    public static Font getFont(int size) {
        return GuiUtils.getFont(size, false, false);
    }

    public static Font getFont(int size, boolean bold) {
        return GuiUtils.getFont(size, bold, false);
    }

    public static Font getFont(int size, boolean bold, boolean oblique) {
        FontInfo info = new FontInfo(size, bold, oblique);
        if (fonts.containsKey(info)) {
            return fonts.get(info);
        }
        String fontFile = bold && oblique ? "/resources/DejaVuSansMono-BoldOblique.ttf" : (bold ? "/resources/DejaVuSansMono-Bold.ttf" : (oblique ? "/resources/DejaVuSansMono-Oblique.ttf" : "/resources/DejaVuSansMono.ttf"));
        Font font = Font.loadFont((InputStream)GuiUtils.class.getResourceAsStream(fontFile), (double)size);
        fonts.put(info, font);
        return font;
    }

    public static int getCircuitCoord(double a) {
        return ((int)Math.round(a) + 5) / 10;
    }

    public static int getScreenCircuitCoord(double a) {
        return GuiUtils.getCircuitCoord(a) * 10;
    }

    public static Bounds getBounds(Font font, String string) {
        return GuiUtils.getBounds(font, string, true);
    }

    public static Bounds getBounds(Font font, String string, boolean save) {
        if (save) {
            Map strings = boundsSeen.computeIfAbsent(font, f -> new HashMap());
            return strings.computeIfAbsent(string, s -> {
                Text text = new Text(string);
                text.setFont(font);
                return text.getLayoutBounds();
            });
        }
        Text text = new Text(string);
        text.setFont(font);
        return text.getLayoutBounds();
    }

    public static void drawShape(Drawable drawable, GuiElement element) {
        drawable.draw(element.getScreenX(), element.getScreenY(), element.getScreenWidth(), element.getScreenHeight());
    }

    public static void drawName(GraphicsContext graphics, ComponentPeer<?> component, Properties.Direction direction) {
        if (!((Component)component.getComponent()).getName().isEmpty()) {
            double y;
            double x;
            Bounds bounds = GuiUtils.getBounds(graphics.getFont(), ((Component)component.getComponent()).getName());
            switch (direction) {
                case EAST: {
                    x = component.getScreenX() + component.getScreenWidth() + 5;
                    y = (double)component.getScreenY() + ((double)component.getScreenHeight() + bounds.getHeight()) * 0.4;
                    break;
                }
                case WEST: {
                    x = (double)component.getScreenX() - bounds.getWidth() - 3.0;
                    y = (double)component.getScreenY() + ((double)component.getScreenHeight() + bounds.getHeight()) * 0.4;
                    break;
                }
                case SOUTH: {
                    x = (double)component.getScreenX() + ((double)component.getScreenWidth() - bounds.getWidth()) * 0.5;
                    y = (double)(component.getScreenY() + component.getScreenHeight()) + bounds.getHeight();
                    break;
                }
                case NORTH: {
                    x = (double)component.getScreenX() + ((double)component.getScreenWidth() - bounds.getWidth()) * 0.5;
                    y = component.getScreenY() - 5;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("How can Direction be anything else??");
                }
            }
            graphics.setFill((Paint)Color.BLACK);
            graphics.fillText(((Component)component.getComponent()).getName(), x, y);
        }
    }

    public static void drawValue(GraphicsContext graphics, String string, int x, int y, int width) {
        Bounds bounds = GuiUtils.getBounds(graphics.getFont(), string, false);
        if (string.length() == 1) {
            graphics.fillText(string, (double)x + ((double)width - bounds.getWidth()) * 0.5, (double)y + bounds.getHeight() * 0.75 + 1.0);
        } else {
            int i = 0;
            int row = 1;
            while (i < string.length()) {
                String sub = string.substring(i, i + Math.min(8, string.length() - i));
                i += sub.length();
                graphics.fillText(sub, (double)(x + 1), (double)y + bounds.getHeight() * 0.75 * (double)row + 1.0);
                ++row;
            }
        }
    }

    public static void drawClockInput(GraphicsContext graphics, Connection connection, Properties.Direction direction) {
        double x = (double)connection.getScreenX() + (double)connection.getScreenWidth() * 0.5;
        double y = (double)connection.getScreenY() + (double)connection.getScreenWidth() * 0.5;
        switch (direction) {
            case NORTH: {
                graphics.strokeLine(x - 5.0, y, x, y + 6.0);
                graphics.strokeLine(x, y + 6.0, x + 5.0, y);
                break;
            }
            case SOUTH: {
                graphics.strokeLine(x - 5.0, y, x, y - 6.0);
                graphics.strokeLine(x, y - 6.0, x + 5.0, y);
                break;
            }
            case EAST: {
                graphics.strokeLine(x, y - 5.0, x - 6.0, y);
                graphics.strokeLine(x - 6.0, y, x, y + 5.0);
                break;
            }
            case WEST: {
                graphics.strokeLine(x, y - 5.0, x + 6.0, y);
                graphics.strokeLine(x + 6.0, y, x, y + 5.0);
            }
        }
    }

    public static void setBitColor(GraphicsContext graphics, CircuitState circuitState, LinkWires linkWires) {
        if (linkWires.isLinkValid()) {
            Port.Link link = linkWires.getLink();
            if (link != null && circuitState != null) {
                if (circuitState.isShortCircuited(link)) {
                    graphics.setStroke((Paint)Color.RED);
                    graphics.setFill((Paint)Color.RED);
                } else {
                    GuiUtils.setBitColor(graphics, circuitState.getMergedValue(link));
                }
            } else {
                GuiUtils.setBitColor(graphics, WireValue.State.X);
            }
        } else {
            graphics.setStroke((Paint)Color.ORANGE);
            graphics.setFill((Paint)Color.ORANGE);
        }
    }

    public static void setBitColor(GraphicsContext graphics, WireValue value) {
        if (value.getBitSize() == 1) {
            GuiUtils.setBitColor(graphics, value.getBit(0));
        } else if (value.isValidValue()) {
            graphics.setStroke((Paint)Color.BLACK);
            graphics.setFill((Paint)Color.BLACK);
        } else {
            graphics.setStroke((Paint)X_MULTIBIT_COLOR);
            graphics.setFill((Paint)X_MULTIBIT_COLOR);
        }
    }

    public static void setBitColor(GraphicsContext graphics, WireValue.State bitState) {
        switch (bitState) {
            case ONE: {
                graphics.setStroke((Paint)ONE_COLOR);
                graphics.setFill((Paint)ONE_COLOR);
                break;
            }
            case ZERO: {
                graphics.setStroke((Paint)ZERO_COLOR);
                graphics.setFill((Paint)ZERO_COLOR);
                break;
            }
            case X: {
                graphics.setStroke((Paint)X_1BIT_COLOR);
                graphics.setFill((Paint)X_1BIT_COLOR);
            }
        }
    }

    public static Connection.PortConnection rotatePortCCW(Connection.PortConnection connection, boolean useWidth) {
        int x = connection.getXOffset();
        int y = connection.getYOffset();
        int width = useWidth ? connection.getParent().getWidth() : connection.getParent().getHeight();
        return new Connection.PortConnection((ComponentPeer<?>)connection.getParent(), connection.getPort(), connection.getName(), y, width - x);
    }

    public static void rotatePorts(List<Connection.PortConnection> connections, Properties.Direction source, Properties.Direction destination) {
        List<Properties.Direction> order = Arrays.asList(Properties.Direction.EAST, Properties.Direction.NORTH, Properties.Direction.WEST, Properties.Direction.SOUTH);
        Stream<Object> stream = connections.stream();
        int index = order.indexOf((Object)source);
        boolean useWidth = true;
        while (order.get(index++ % order.size()) != destination) {
            boolean temp = useWidth;
            stream = stream.map(port -> GuiUtils.rotatePortCCW(port, temp));
            useWidth = !useWidth;
        }
        List newConns = stream.collect(Collectors.toList());
        connections.clear();
        connections.addAll(newConns);
    }

    public static void rotateElementSize(GuiElement element, Properties.Direction source, Properties.Direction destination) {
        List<Properties.Direction> order = Arrays.asList(Properties.Direction.EAST, Properties.Direction.NORTH, Properties.Direction.WEST, Properties.Direction.SOUTH);
        int index = order.indexOf((Object)source);
        while (order.get(index++ % order.size()) != destination) {
            int width = element.getWidth();
            int height = element.getHeight();
            element.setWidth(height);
            element.setHeight(width);
        }
    }

    public static void rotateGraphics(GuiElement element, GraphicsContext graphics, Properties.Direction direction) {
        int x = element.getScreenX();
        int y = element.getScreenY();
        int width = element.getScreenWidth();
        int height = element.getScreenHeight();
        graphics.translate((double)x + (double)width * 0.5, (double)y + (double)height * 0.5);
        switch (direction) {
            case NORTH: {
                graphics.rotate(270.0);
                graphics.translate((double)(-x) - (double)height * 0.5, (double)(-y) - (double)width * 0.5);
                break;
            }
            case SOUTH: {
                graphics.rotate(90.0);
                graphics.translate((double)(-x) - (double)height * 0.5, (double)(-y) - (double)width * 0.5);
                break;
            }
            case WEST: {
                graphics.rotate(180.0);
            }
            default: {
                graphics.translate((double)(-x) - (double)width * 0.5, (double)(-y) - (double)height * 0.5);
            }
        }
    }

    public static interface Drawable {
        public void draw(int var1, int var2, int var3, int var4);
    }

    private static class FontInfo {
        int size;
        boolean bold;
        boolean oblique;

        FontInfo(int size, boolean bold, boolean oblique) {
            this.size = size;
            this.bold = bold;
            this.oblique = oblique;
        }

        public int hashCode() {
            return this.size ^ (this.bold ? 4096 : 0) ^ (this.oblique ? 8192 : 0);
        }

        public boolean equals(Object other) {
            if (!(other instanceof FontInfo)) {
                return false;
            }
            FontInfo info = (FontInfo)other;
            return info.size == this.size && info.bold == this.bold && info.oblique == this.oblique;
        }
    }
}

