/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.simulator.CircuitState;
import java.util.Collections;
import java.util.List;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;

public abstract class GuiElement {
    private int x;
    private int y;
    private int width;
    private int height;

    public GuiElement(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getScreenX() {
        return this.getX() * 10;
    }

    public int getScreenY() {
        return this.getY() * 10;
    }

    public int getScreenWidth() {
        return this.getWidth() * 10;
    }

    public int getScreenHeight() {
        return this.getHeight() * 10;
    }

    public boolean containsScreenCoord(int x, int y) {
        return x >= this.getScreenX() && x < this.getScreenX() + this.getScreenWidth() && y >= this.getScreenY() && y < this.getScreenY() + this.getScreenHeight();
    }

    public boolean contains(int x, int y) {
        return x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getY() && y < this.getY() + this.getHeight();
    }

    public boolean contains(GuiElement element) {
        return this.contains(element.getX(), element.getY(), element.getWidth(), element.getHeight());
    }

    public boolean contains(int x, int y, int width, int height) {
        return x >= this.getX() && x + width <= this.getX() + this.getWidth() && y >= this.getY() && y + height <= this.getY() + this.getHeight();
    }

    public boolean isWithin(GuiElement element) {
        return this.isWithin(element.getX(), element.getY(), element.getWidth(), element.getHeight());
    }

    public boolean isWithinScreenCoord(int x, int y, int width, int height) {
        int screenX = this.getScreenX();
        int screenY = this.getScreenY();
        int screenWidth = this.getScreenWidth();
        int screenHeight = this.getScreenHeight();
        return screenX >= x && screenX + screenWidth <= x + width && screenY >= y && screenY + screenHeight <= y + height;
    }

    public boolean isWithin(int x, int y, int width, int height) {
        return this.getX() >= x && this.getX() + this.getWidth() <= x + width && this.getY() >= y && this.getY() + this.getHeight() <= y + height;
    }

    public boolean intersects(GuiElement element) {
        return this.intersects(element.getX(), element.getY(), element.getWidth(), element.getHeight());
    }

    public boolean intersectsScreenCoord(int x, int y, int width, int height) {
        return x < this.getScreenX() + this.getScreenWidth() && this.getScreenX() < x + width && y < this.getScreenY() + this.getScreenHeight() && this.getScreenY() < y + height;
    }

    public boolean intersects(int x, int y, int width, int height) {
        return x < this.getX() + this.getWidth() && this.getX() < x + width && y < this.getY() + this.getHeight() && this.getY() < y + height;
    }

    public void mousePressed(CircuitManager manager, CircuitState state, double x, double y) {
    }

    public void mouseReleased(CircuitManager manager, CircuitState state, double x, double y) {
    }

    public void mouseEntered(CircuitManager manager, CircuitState state) {
    }

    public void mouseExited(CircuitManager manager, CircuitState state) {
    }

    public boolean keyPressed(CircuitManager manager, CircuitState state, KeyCode keyCode, String text) {
        return false;
    }

    public void keyTyped(CircuitManager manager, CircuitState state, String character) {
    }

    public void keyReleased(CircuitManager manager, CircuitState state, KeyCode keyCode, String text) {
    }

    public List<MenuItem> getContextMenuItems(CircuitManager circuit) {
        return Collections.emptyList();
    }

    public abstract List<? extends Connection> getConnections();

    public abstract void paint(GraphicsContext var1, CircuitState var2);
}

