/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.CircuitSim;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.GuiElement;
import com.ra4king.circuitsim.gui.LinkWires;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import javafx.scene.control.Tab;

public class EditHistory {
    private CircuitSim circuitSim;
    private Deque<List<Edit>> editStack;
    private Deque<List<Edit>> redoStack;
    private static final int MAX_HISTORY = 300;
    private List<EditListener> editListeners;
    private int disableDepth = 0;
    private int groupDepth = 0;
    private List<List<Edit>> groups;

    public EditHistory(CircuitSim circuitSim) {
        this.circuitSim = circuitSim;
        this.editStack = new ArrayDeque<List<Edit>>();
        this.redoStack = new ArrayDeque<List<Edit>>();
        this.editListeners = new ArrayList<EditListener>();
    }

    public void clear() {
        this.editStack.clear();
        this.redoStack.clear();
    }

    public void enable() {
        --this.disableDepth;
        if (this.disableDepth < 0) {
            throw new IllegalStateException("This should never happen!");
        }
    }

    public void disable() {
        ++this.disableDepth;
    }

    public void addListener(EditListener listener) {
        this.editListeners.add(listener);
    }

    public void removeListener(EditListener listener) {
        this.editListeners.remove(listener);
    }

    public void beginGroup() {
        ++this.groupDepth;
        if (this.groups == null) {
            if (this.groupDepth != 1) {
                throw new IllegalStateException("How the hell did this happen??");
            }
            this.groups = new ArrayList<List<Edit>>();
        }
        this.groups.add(new ArrayList());
    }

    public void endGroup() {
        if (this.groupDepth == 0) {
            throw new IllegalStateException("Mismatched call to endGroup.");
        }
        --this.groupDepth;
        if (this.groupDepth == 0) {
            if (this.groups == null) {
                throw new IllegalStateException("This can't be null?!");
            }
            if (this.groups.size() != 1) {
                throw new IllegalStateException("There should only be a single group left");
            }
            List<Edit> edits = this.groups.get(0);
            if (!edits.isEmpty()) {
                this.editStack.push(edits);
                if (this.editStack.size() > 300) {
                    this.editStack.removeLast();
                }
            }
            this.groups = null;
        } else {
            this.groups.get(this.groupDepth - 1).addAll((Collection<Edit>)this.groups.get(this.groupDepth));
            this.groups.remove(this.groupDepth);
        }
    }

    public void clearGroup() {
        if (this.groups == null) {
            throw new IllegalStateException("No group started");
        }
        this.groups.get(this.groupDepth - 1).clear();
        this.groups.subList(this.groupDepth, this.groups.size()).clear();
    }

    public void addAction(EditAction action, CircuitManager manager, Object ... params) {
        if (this.disableDepth == 0) {
            this.beginGroup();
            this.groups.get(this.groupDepth - 1).add(new Edit(action, manager, params));
            this.endGroup();
            this.redoStack.clear();
            this.editListeners.forEach(listener -> listener.edit(action, manager, params));
        }
    }

    public int editStackSize() {
        return this.editStack.size() + (this.groups == null || this.groups.isEmpty() ? 0 : 1);
    }

    public int redoStackSize() {
        return this.redoStack.size();
    }

    public CircuitManager undo() {
        if (this.editStack.isEmpty()) {
            return null;
        }
        List<Edit> popped = this.editStack.pop();
        this.redoStack.push(popped);
        this.circuitSim.getSimulator().runSync(() -> {
            HashSet<CircuitManager> circuitManagers = new HashSet<CircuitManager>();
            try {
                this.disable();
                for (int i = popped.size() - 1; i >= 0; --i) {
                    Edit edit = (Edit)popped.get(i);
                    circuitManagers.add(edit.circuitManager);
                    edit.circuitManager.getCircuitBoard().disableRejoinWires();
                    edit.action.undo(edit.circuitManager, edit.params);
                    this.editListeners.forEach(listener -> listener.edit(edit.action, edit.circuitManager, edit.params));
                }
            }
            finally {
                this.enable();
                circuitManagers.forEach(circuitManager -> circuitManager.getCircuitBoard().enableRejoinWires());
            }
        });
        return popped.get((int)0).circuitManager;
    }

    public CircuitManager redo() {
        if (this.redoStack.isEmpty()) {
            return null;
        }
        List<Edit> popped = this.redoStack.pop();
        this.editStack.push(popped);
        if (this.editStack.size() > 300) {
            this.editStack.removeLast();
        }
        this.circuitSim.getSimulator().runSync(() -> {
            HashSet<CircuitManager> circuitManagers = new HashSet<CircuitManager>();
            try {
                this.disable();
                for (Edit edit : popped) {
                    circuitManagers.add(edit.circuitManager);
                    edit.circuitManager.getCircuitBoard().disableRejoinWires();
                    edit.action.redo(edit.circuitManager, edit.params);
                    this.editListeners.forEach(listener -> listener.edit(edit.action, edit.circuitManager, edit.params));
                }
            }
            finally {
                this.enable();
                circuitManagers.forEach(circuitManager -> circuitManager.getCircuitBoard().enableRejoinWires());
            }
        });
        return popped.get((int)0).circuitManager;
    }

    public static interface EditListener {
        public void edit(EditAction var1, CircuitManager var2, Object[] var3);
    }

    private class Edit {
        EditAction action;
        CircuitManager circuitManager;
        Object[] params;

        Edit(EditAction action, CircuitManager circuitManager, Object[] params) {
            this.action = action;
            this.circuitManager = circuitManager;
            this.params = params;
        }
    }

    public static enum EditAction {
        CREATE_CIRCUIT{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                manager.getSimulatorWindow().readdCircuit(manager, (Tab)params[0], (Integer)params[1]);
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                manager.getSimulatorWindow().deleteCircuit(manager, true, false);
            }
        }
        ,
        RENAME_CIRCUIT{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                ((CircuitSim)((Object)params[0])).renameCircuit((Tab)params[1], (String)params[3]);
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                ((CircuitSim)((Object)params[0])).renameCircuit((Tab)params[1], (String)params[2]);
            }
        }
        ,
        MOVE_CIRCUIT{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                List tabs = (List)params[0];
                Tab tab = (Tab)params[1];
                int fromIdx = (Integer)params[2];
                int toIdx = (Integer)params[3];
                if (tabs.indexOf(tab) != fromIdx) {
                    throw new IllegalStateException("Something bad happened!");
                }
                tabs.remove(fromIdx);
                tabs.add(toIdx, tab);
                manager.getSimulatorWindow().refreshCircuitsTab();
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                List tabs = (List)params[0];
                Tab tab = (Tab)params[1];
                int fromIdx = (Integer)params[2];
                int toIdx = (Integer)params[3];
                this.redo(manager, new Object[]{tabs, tab, toIdx, fromIdx});
            }
        }
        ,
        DELETE_CIRCUIT{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                CREATE_CIRCUIT.undo(manager, params);
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                CREATE_CIRCUIT.redo(manager, params);
            }
        }
        ,
        ADD_COMPONENT{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                manager.mayThrow(() -> manager.getCircuitBoard().addComponent((ComponentPeer)params[0]));
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                ComponentPeer toRemove = (ComponentPeer)params[0];
                for (ComponentPeer<?> component : manager.getCircuitBoard().getComponents()) {
                    if (component != toRemove && (component.getClass() != toRemove.getClass() || component.getX() != toRemove.getX() || component.getY() != toRemove.getY() || !component.getProperties().equals(toRemove.getProperties()))) continue;
                    manager.mayThrow(() -> manager.getCircuitBoard().removeElements(Collections.singleton(component)));
                    break;
                }
            }
        }
        ,
        UPDATE_COMPONENT{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                manager.mayThrow(() -> manager.getCircuitBoard().updateComponent((ComponentPeer)params[0], (ComponentPeer)params[1]));
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                manager.mayThrow(() -> manager.getCircuitBoard().updateComponent((ComponentPeer)params[1], (ComponentPeer)params[0]));
            }
        }
        ,
        MOVE_ELEMENT{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                GuiElement element = (GuiElement)params[0];
                int dx = (Integer)params[1];
                int dy = (Integer)params[2];
                element.setX(element.getX() + dx);
                element.setY(element.getY() + dy);
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                GuiElement element = (GuiElement)params[0];
                int dx = (Integer)params[1];
                int dy = (Integer)params[2];
                element.setX(element.getX() - dx);
                element.setY(element.getY() - dy);
            }
        }
        ,
        REMOVE_COMPONENT{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                ADD_COMPONENT.undo(manager, params);
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                ADD_COMPONENT.redo(manager, params);
            }
        }
        ,
        ADD_WIRE{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                LinkWires.Wire wire = (LinkWires.Wire)params[0];
                manager.mayThrow(() -> manager.getCircuitBoard().addWire(wire.getX(), wire.getY(), wire.getLength(), wire.isHorizontal()));
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                manager.mayThrow(() -> manager.getCircuitBoard().removeElements(Collections.singleton((LinkWires.Wire)params[0])));
            }
        }
        ,
        REMOVE_WIRE{

            @Override
            protected void redo(CircuitManager manager, Object[] params) {
                ADD_WIRE.undo(manager, params);
            }

            @Override
            protected void undo(CircuitManager manager, Object[] params) {
                ADD_WIRE.redo(manager, params);
            }
        };


        protected abstract void redo(CircuitManager var1, Object[] var2);

        protected abstract void undo(CircuitManager var1, Object[] var2);
    }
}

