/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.CircuitSim;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.stage.Modality;
import javafx.stage.Window;

public class DebugUtil {
    private CircuitSim simulatorWindow;
    private volatile boolean showingError;
    private static final String[] SYSTEM_PROPERTIES = new String[]{"java.version", "java.vendor", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "os.name", "os.arch", "os.version"};

    DebugUtil(CircuitSim simulatorWindow) {
        this.simulatorWindow = simulatorWindow;
    }

    public void logException(Throwable throwable) {
        this.logException("", throwable);
    }

    public void logException(String message, Throwable throwable) {
        System.err.println(message);
        throwable.printStackTrace();
        if (this.simulatorWindow.isWindowOpen()) {
            Platform.runLater(() -> {
                DebugUtil debugUtil = this;
                synchronized (debugUtil) {
                    if (this.showingError) {
                        return;
                    }
                    this.showingError = true;
                }
                try {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    throwable.printStackTrace(new PrintStream(stream));
                    String errorMessage = stream.toString();
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.initOwner((Window)this.simulatorWindow.getStage());
                    alert.initModality(Modality.WINDOW_MODAL);
                    alert.setTitle("Internal error");
                    alert.setHeaderText("Internal error: " + message);
                    TextArea textArea = new TextArea(errorMessage);
                    textArea.setMinWidth(600.0);
                    textArea.setMinHeight(400.0);
                    alert.getDialogPane().setContent((Node)textArea);
                    alert.getButtonTypes().clear();
                    alert.getButtonTypes().add((Object)new ButtonType("Send Error Report", ButtonBar.ButtonData.YES));
                    alert.getButtonTypes().add((Object)new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE));
                    Optional buttonType = alert.showAndWait();
                    if (buttonType.isPresent() && ((ButtonType)buttonType.get()).getButtonData() == ButtonBar.ButtonData.YES) {
                        this.sendErrorReport(message + "\n" + errorMessage);
                    }
                }
                finally {
                    this.showingError = false;
                }
            });
        }
    }

    private void sendErrorReport(String message) {
        StringBuilder messageBuilder = new StringBuilder();
        for (String property : SYSTEM_PROPERTIES) {
            messageBuilder.append(property).append("=").append(System.getProperty(property)).append("\n");
        }
        messageBuilder.append("CircuitSim version=1.8.1").append("\n\n");
        String msg = messageBuilder.append(message.replace("\t", "    ").replace("\r", "")).toString();
        new Thread(() -> {
            try {
                HttpURLConnection httpConnection = (HttpURLConnection)new URL("https://www.roiatalla.com/circuitsimerror").openConnection();
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoInput(true);
                httpConnection.setDoOutput(true);
                PrintWriter printWriter = new PrintWriter(httpConnection.getOutputStream());
                printWriter.write(msg);
                printWriter.flush();
                httpConnection.getInputStream().read();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }).start();
    }
}

