/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.GuiElement;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.LinkWires;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Port;
import javafx.scene.canvas.GraphicsContext;

public abstract class Connection {
    private final GuiElement parent;
    private final int x;
    private final int y;

    public Connection(GuiElement parent, int x, int y) {
        this.parent = parent;
        this.x = x;
        this.y = y;
    }

    public GuiElement getParent() {
        return this.parent;
    }

    public abstract LinkWires getLinkWires();

    public int getXOffset() {
        return this.x;
    }

    public int getYOffset() {
        return this.y;
    }

    public int getX() {
        return this.parent.getX() + this.x;
    }

    public int getScreenX() {
        return this.getX() * 10 - 3;
    }

    public int getY() {
        return this.parent.getY() + this.y;
    }

    public int getScreenY() {
        return this.getY() * 10 - 3;
    }

    public int getScreenWidth() {
        return 6;
    }

    public int getScreenHeight() {
        return 6;
    }

    public void paint(GraphicsContext graphics, CircuitState circuitState) {
        GuiUtils.setBitColor(graphics, circuitState, this.getLinkWires());
        graphics.fillOval((double)this.getScreenX(), (double)this.getScreenY(), (double)this.getScreenWidth(), (double)this.getScreenHeight());
    }

    public static class WireConnection
    extends Connection {
        public WireConnection(LinkWires.Wire wire, int x, int y) {
            super(wire, x, y);
        }

        @Override
        public LinkWires.Wire getParent() {
            return (LinkWires.Wire)super.getParent();
        }

        @Override
        public LinkWires getLinkWires() {
            return this.getParent().getLinkWires();
        }
    }

    public static class PortConnection
    extends Connection {
        private Port port;
        private String name;
        private LinkWires linkWires;

        public PortConnection(ComponentPeer<?> parent, Port port, int x, int y) {
            this(parent, port, "", x, y);
        }

        public PortConnection(ComponentPeer<?> parent, Port port, String name, int x, int y) {
            super(parent, x, y);
            this.port = port;
            this.name = name;
            this.setLinkWires(null);
        }

        @Override
        public ComponentPeer<?> getParent() {
            return (ComponentPeer)super.getParent();
        }

        public Port getPort() {
            return this.port;
        }

        public String getName() {
            return this.name;
        }

        public void setLinkWires(LinkWires linkWires) {
            if (linkWires == null) {
                linkWires = new LinkWires();
                linkWires.addPort(this);
            }
            this.linkWires = linkWires;
        }

        @Override
        public LinkWires getLinkWires() {
            return this.linkWires;
        }
    }
}

