/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.peers.arithmetic.AdderPeer;
import com.ra4king.circuitsim.gui.peers.arithmetic.BitExtenderPeer;
import com.ra4king.circuitsim.gui.peers.arithmetic.ComparatorPeer;
import com.ra4king.circuitsim.gui.peers.arithmetic.DividerPeer;
import com.ra4king.circuitsim.gui.peers.arithmetic.MultiplierPeer;
import com.ra4king.circuitsim.gui.peers.arithmetic.NegatorPeer;
import com.ra4king.circuitsim.gui.peers.arithmetic.RandomGeneratorPeer;
import com.ra4king.circuitsim.gui.peers.arithmetic.ShifterPeer;
import com.ra4king.circuitsim.gui.peers.arithmetic.SubtractorPeer;
import com.ra4king.circuitsim.gui.peers.gates.AndGatePeer;
import com.ra4king.circuitsim.gui.peers.gates.ControlledBufferPeer;
import com.ra4king.circuitsim.gui.peers.gates.NandGatePeer;
import com.ra4king.circuitsim.gui.peers.gates.NorGatePeer;
import com.ra4king.circuitsim.gui.peers.gates.NotGatePeer;
import com.ra4king.circuitsim.gui.peers.gates.OrGatePeer;
import com.ra4king.circuitsim.gui.peers.gates.XnorGatePeer;
import com.ra4king.circuitsim.gui.peers.gates.XorGatePeer;
import com.ra4king.circuitsim.gui.peers.io.Button;
import com.ra4king.circuitsim.gui.peers.io.HexDisplay;
import com.ra4king.circuitsim.gui.peers.io.LED;
import com.ra4king.circuitsim.gui.peers.io.LEDMatrix;
import com.ra4king.circuitsim.gui.peers.memory.DFlipFlopPeer;
import com.ra4king.circuitsim.gui.peers.memory.RAMPeer;
import com.ra4king.circuitsim.gui.peers.memory.ROMPeer;
import com.ra4king.circuitsim.gui.peers.memory.RegisterPeer;
import com.ra4king.circuitsim.gui.peers.memory.SRFlipFlopPeer;
import com.ra4king.circuitsim.gui.peers.misc.Text;
import com.ra4king.circuitsim.gui.peers.plexers.DecoderPeer;
import com.ra4king.circuitsim.gui.peers.plexers.DemultiplexerPeer;
import com.ra4king.circuitsim.gui.peers.plexers.MultiplexerPeer;
import com.ra4king.circuitsim.gui.peers.plexers.PriorityEncoderPeer;
import com.ra4king.circuitsim.gui.peers.wiring.ClockPeer;
import com.ra4king.circuitsim.gui.peers.wiring.ConstantPeer;
import com.ra4king.circuitsim.gui.peers.wiring.PinPeer;
import com.ra4king.circuitsim.gui.peers.wiring.Probe;
import com.ra4king.circuitsim.gui.peers.wiring.SplitterPeer;
import com.ra4king.circuitsim.gui.peers.wiring.TransistorPeer;
import com.ra4king.circuitsim.gui.peers.wiring.Tunnel;
import com.ra4king.circuitsim.simulator.SimulationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.image.Image;
import javafx.util.Pair;

public class ComponentManager {
    private List<ComponentLauncherInfo> components = new ArrayList<ComponentLauncherInfo>();

    static <T extends ComponentPeer<?>> ComponentCreator<T> forClass(Class<T> clazz) {
        return (properties, x, y) -> {
            try {
                return (ComponentPeer)clazz.getConstructor(Properties.class, Integer.TYPE, Integer.TYPE).newInstance(properties, x, y);
            }
            catch (NoSuchMethodException exc) {
                throw new RuntimeException("Must have constructor taking (Properties props, int x, int y)");
            }
            catch (InvocationTargetException exc) {
                if (exc.getTargetException() instanceof SimulationException) {
                    throw (SimulationException)exc.getTargetException();
                }
                throw new RuntimeException(exc.getTargetException());
            }
            catch (RuntimeException exc) {
                throw exc;
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        };
    }

    ComponentManager() {
        this.registerDefaultComponents();
    }

    public ComponentLauncherInfo get(Pair<String, String> name) {
        for (ComponentLauncherInfo component : this.components) {
            if (!component.name.equals(name)) continue;
            return component;
        }
        throw new IllegalArgumentException("Component not registered: " + name);
    }

    public ComponentLauncherInfo get(Class<? extends ComponentPeer> clazz, Properties properties) {
        ComponentLauncherInfo firstComponent = null;
        for (ComponentLauncherInfo component : this.components) {
            if (component.clazz != clazz) continue;
            firstComponent = component;
            if (!properties.intersect(component.properties).equals(component.properties)) continue;
            return component;
        }
        if (firstComponent != null) {
            return firstComponent;
        }
        throw new IllegalArgumentException("Component not registered: " + clazz);
    }

    public void forEach(Consumer<ComponentLauncherInfo> consumer) {
        this.components.forEach(consumer);
    }

    public <T extends ComponentPeer<?>> void register(Class<T> clazz) {
        try {
            ComponentCreator creator = ComponentManager.forClass(clazz);
            Method method = clazz.getMethod("installComponent", ComponentManagerInterface.class);
            method.invoke(null, (name, image, defaultProperties) -> {
                if (name == null || defaultProperties == null) {
                    throw new NullPointerException("Name and Properties cannot be null.");
                }
                ComponentLauncherInfo info = new ComponentLauncherInfo(clazz, (Pair<String, String>)name, image, defaultProperties, creator);
                if (!this.components.contains(info)) {
                    this.components.add(info);
                }
            });
        }
        catch (NoSuchMethodException exc) {
            throw new RuntimeException("Must implement: public static void installComponent(ComponentManagerInterface): " + clazz);
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private void registerDefaultComponents() {
        this.register(PinPeer.class);
        this.register(ConstantPeer.class);
        this.register(Probe.class);
        this.register(ClockPeer.class);
        this.register(SplitterPeer.class);
        this.register(Tunnel.class);
        this.register(TransistorPeer.class);
        this.register(AndGatePeer.class);
        this.register(NandGatePeer.class);
        this.register(OrGatePeer.class);
        this.register(NorGatePeer.class);
        this.register(XorGatePeer.class);
        this.register(XnorGatePeer.class);
        this.register(NotGatePeer.class);
        this.register(ControlledBufferPeer.class);
        this.register(MultiplexerPeer.class);
        this.register(DemultiplexerPeer.class);
        this.register(DecoderPeer.class);
        this.register(PriorityEncoderPeer.class);
        this.register(RegisterPeer.class);
        this.register(SRFlipFlopPeer.class);
        this.register(DFlipFlopPeer.class);
        this.register(RAMPeer.class);
        this.register(ROMPeer.class);
        this.register(AdderPeer.class);
        this.register(SubtractorPeer.class);
        this.register(MultiplierPeer.class);
        this.register(DividerPeer.class);
        this.register(NegatorPeer.class);
        this.register(ComparatorPeer.class);
        this.register(BitExtenderPeer.class);
        this.register(ShifterPeer.class);
        this.register(RandomGeneratorPeer.class);
        this.register(Button.class);
        this.register(LED.class);
        this.register(LEDMatrix.class);
        this.register(HexDisplay.class);
        this.register(Text.class);
    }

    public static interface ComponentCreator<T extends ComponentPeer<?>> {
        public T createComponent(Properties var1, int var2, int var3);
    }

    public static interface ComponentManagerInterface {
        public void addComponent(Pair<String, String> var1, Image var2, Properties var3);
    }

    public static class ComponentLauncherInfo {
        public final Class<? extends ComponentPeer<?>> clazz;
        public final Pair<String, String> name;
        public final Image image;
        public final Properties properties;
        public final ComponentCreator<?> creator;

        ComponentLauncherInfo(Class<? extends ComponentPeer<?>> clazz, Pair<String, String> name, Image image, Properties properties, ComponentCreator<?> creator) {
            this.clazz = clazz;
            this.name = name;
            this.image = image;
            this.properties = properties;
            this.creator = creator;
        }

        public int hashCode() {
            return this.clazz.hashCode() ^ this.name.hashCode() ^ (this.image == null ? 0 : this.image.hashCode()) ^ this.properties.hashCode() ^ this.creator.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ComponentLauncherInfo)) {
                return false;
            }
            ComponentLauncherInfo info = (ComponentLauncherInfo)other;
            return info.clazz == this.clazz && info.name.equals(this.name);
        }
    }
}

