/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.google.gson.JsonSyntaxException;
import com.ra4king.circuitsim.gui.CircuitBoard;
import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.DebugUtil;
import com.ra4king.circuitsim.gui.EditHistory;
import com.ra4king.circuitsim.gui.GuiElement;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.JavaFXCompatibilityWrapper;
import com.ra4king.circuitsim.gui.LinkWires;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.file.FileFormat;
import com.ra4king.circuitsim.gui.peers.SubcircuitPeer;
import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.ShortCircuitException;
import com.ra4king.circuitsim.simulator.SimulationException;
import com.ra4king.circuitsim.simulator.Simulator;
import com.ra4king.circuitsim.simulator.components.Subcircuit;
import com.ra4king.circuitsim.simulator.components.wiring.Clock;
import com.ra4king.circuitsim.simulator.components.wiring.Pin;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Pair;

public class CircuitSim
extends Application {
    public static final String VERSION = "1.8.1";
    private static boolean mainCalled = false;
    private static AtomicBoolean versionChecked = new AtomicBoolean(false);
    private DebugUtil debugUtil = new DebugUtil(this);
    private Stage stage;
    private Scene scene;
    private boolean openWindow = true;
    private Simulator simulator;
    private CheckMenuItem simulationEnabled;
    private MenuItem undo;
    private MenuItem redo;
    private CheckMenuItem clockEnabled;
    private Menu frequenciesMenu;
    private MenuItem help;
    private ToggleButton clickMode;
    private boolean clickedDirectly;
    private ComponentManager componentManager;
    private List<String> libraryPaths;
    private TabPane buttonTabPane;
    private ToggleGroup buttonsToggleGroup;
    private Runnable refreshComponentsTabs;
    private ComboBox<Integer> bitSizeSelect;
    private ComboBox<Double> scaleFactorSelect;
    private Label fpsLabel;
    private Label clockLabel;
    private Label messageLabel;
    private GridPane propertiesTable;
    private Label componentLabel;
    private Tab circuitButtonsTab;
    private TabPane canvasTabPane;
    private Map<String, Pair<ComponentManager.ComponentLauncherInfo, CircuitManager>> circuitManagers;
    private ComponentManager.ComponentLauncherInfo selectedComponent;
    private File saveFile;
    private File lastSaveFile;
    private boolean loadingFile;
    private static DataFormat copyDataFormat = new DataFormat(new String[]{"x-circuit-simulator"});
    private EditHistory editHistory;
    private int savedEditStackSize;
    private Exception lastException;
    private long lastExceptionTime;
    private static final long SHOW_ERROR_DURATION = 3000L;
    private volatile boolean needsRepaint = true;
    private static AtomicBoolean checkingForUpdate = new AtomicBoolean(false);
    private Exception excThrown;
    private AnimationTimer currentTimer;

    public static void main(String[] args) {
        mainCalled = true;
        CircuitSim.launch((String[])args);
    }

    public CircuitSim() {
        if (!mainCalled) {
            throw new IllegalStateException("Wrong constructor");
        }
    }

    public CircuitSim(boolean openWindow) {
        this.openWindow = openWindow;
        this.runFxSync(() -> {
            this.init();
            this.start(new Stage());
        });
    }

    public boolean isWindowOpen() {
        return this.openWindow;
    }

    private void runFxSync(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            try {
                Platform.runLater(() -> {
                    try {
                        runnable.run();
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            catch (IllegalStateException exc) {
                if (latch.getCount() > 0L) {
                    Runnable startup = () -> {
                        try {
                            runnable.run();
                        }
                        finally {
                            latch.countDown();
                        }
                    };
                    JavaFXCompatibilityWrapper.platformStartup(startup);
                }
                throw exc;
            }
            try {
                latch.await();
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public void init() {
        if (this.simulator != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.simulator = new Simulator();
        this.circuitManagers = new HashMap<String, Pair<ComponentManager.ComponentLauncherInfo, CircuitManager>>();
        Clock.addChangeListener(this.simulator, value -> this.runSim());
        this.editHistory = new EditHistory(this);
        this.editHistory.addListener((action, manager, params) -> {
            this.updateTitle();
            this.circuitManagers.values().stream().map(Pair::getValue).forEach(this::updateCanvasSize);
        });
        this.componentManager = new ComponentManager();
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public EditHistory getEditHistory() {
        return this.editHistory;
    }

    public Stage getStage() {
        return this.stage;
    }

    public Scene getScene() {
        return this.scene;
    }

    public DebugUtil getDebugUtil() {
        return this.debugUtil;
    }

    public void setClickMode(boolean selected) {
        if (!this.clickedDirectly) {
            this.clickMode.setSelected(selected);
        }
    }

    public boolean isClickMode() {
        return this.clickMode.isSelected();
    }

    public double getScaleFactor() {
        return (Double)this.scaleFactorSelect.getSelectionModel().getSelectedItem();
    }

    public double getScaleFactorInverted() {
        return 1.0 / this.getScaleFactor();
    }

    void zoomIn(double x, double y) {
        int selectedIndex = this.scaleFactorSelect.getSelectionModel().getSelectedIndex();
        if (selectedIndex < this.scaleFactorSelect.getItems().size()) {
            this.scaleFactorSelect.getSelectionModel().select(selectedIndex + 1);
            this.setScrollPosition(x, y);
        }
    }

    void zoomOut(double x, double y) {
        int selectedIndex = this.scaleFactorSelect.getSelectionModel().getSelectedIndex();
        if (selectedIndex > 0) {
            this.scaleFactorSelect.getSelectionModel().select(selectedIndex - 1);
            this.setScrollPosition(x, y);
        }
    }

    private void setScrollPosition(double x, double y) {
        CircuitManager manager = this.getCurrentCircuit();
        if (manager != null) {
            ScrollPane scrollPane = manager.getCanvasScrollPane();
            Canvas canvas = manager.getCanvas();
            scrollPane.setHvalue(scrollPane.getHmax() * x / canvas.getWidth());
            scrollPane.setVvalue(scrollPane.getVmax() * y / canvas.getHeight());
        }
    }

    public LinkedHashMap<String, CircuitBoard> getCircuitBoards() {
        return this.circuitManagers.keySet().stream().collect(Collectors.toMap(name -> name, name -> ((CircuitManager)this.circuitManagers.get(name).getValue()).getCircuitBoard(), (v1, v2) -> v1, LinkedHashMap::new));
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public boolean isSimulationEnabled() {
        return this.simulationEnabled.isSelected();
    }

    private void runSim() {
        try {
            if (this.isSimulationEnabled() && this.simulator.hasLinksToUpdate()) {
                this.needsRepaint = true;
                this.simulator.stepAll();
            }
        }
        catch (SimulationException exc) {
            this.setLastException(exc);
        }
        catch (Exception exc) {
            this.setLastException(exc);
            this.getDebugUtil().logException(exc);
        }
    }

    private String getCurrentError() {
        Exception exc;
        CircuitManager manager = this.getCurrentCircuit();
        if (this.lastException != null && 3000L < System.currentTimeMillis() - this.lastExceptionTime) {
            this.lastException = null;
        }
        Exception exception = this.lastException != null ? this.lastException : (exc = manager != null ? manager.getCurrentError() : null);
        return exc == null || exc.getMessage() == null ? "" : (exc instanceof ShortCircuitException ? "Short circuit detected" : exc.getMessage());
    }

    private void setLastException(Exception lastException) {
        this.lastException = lastException;
        this.lastExceptionTime = System.currentTimeMillis();
    }

    private int getCurrentClockSpeed() {
        for (MenuItem menuItem : this.frequenciesMenu.getItems()) {
            RadioMenuItem clockItem = (RadioMenuItem)menuItem;
            if (!clockItem.isSelected()) continue;
            String text = clockItem.getText();
            int space = text.indexOf(32);
            if (space == -1) {
                throw new IllegalStateException("What did you do...");
            }
            return Integer.parseInt(text.substring(0, space));
        }
        throw new IllegalStateException("This can't happen lol");
    }

    private CircuitManager getCurrentCircuit() {
        Tab tab = (Tab)this.canvasTabPane.getSelectionModel().getSelectedItem();
        if (!this.canvasTabPane.getTabs().contains((Object)tab)) {
            return null;
        }
        return tab == null || this.circuitManagers.get(tab.getText()) == null ? null : (CircuitManager)this.circuitManagers.get(tab.getText()).getValue();
    }

    public String getCircuitName(CircuitManager manager) {
        for (Map.Entry<String, Pair<ComponentManager.ComponentLauncherInfo, CircuitManager>> entry : this.circuitManagers.entrySet()) {
            if (entry.getValue().getValue() != manager) continue;
            return entry.getKey();
        }
        return null;
    }

    public Map<String, CircuitManager> getCircuitManagers() {
        return this.circuitManagers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (CircuitManager)((Pair)entry.getValue()).getValue()));
    }

    public CircuitManager getCircuitManager(String name) {
        return this.circuitManagers.containsKey(name) ? (CircuitManager)this.circuitManagers.get(name).getValue() : null;
    }

    public CircuitManager getCircuitManager(Circuit circuit) {
        for (Map.Entry<String, Pair<ComponentManager.ComponentLauncherInfo, CircuitManager>> entry : this.circuitManagers.entrySet()) {
            if (((CircuitManager)entry.getValue().getValue()).getCircuit() != circuit) continue;
            return (CircuitManager)entry.getValue().getValue();
        }
        return null;
    }

    private Tab getTabForCircuit(String name) {
        for (Tab tab : this.canvasTabPane.getTabs()) {
            if (!tab.getText().equals(name)) continue;
            return tab;
        }
        return null;
    }

    private Tab getTabForCircuit(Circuit circuit) {
        for (Map.Entry<String, Pair<ComponentManager.ComponentLauncherInfo, CircuitManager>> entry : this.circuitManagers.entrySet()) {
            if (((CircuitManager)entry.getValue().getValue()).getCircuit() != circuit) continue;
            for (Tab tab : this.canvasTabPane.getTabs()) {
                if (!tab.getText().equals(entry.getKey())) continue;
                return tab;
            }
        }
        return null;
    }

    public void switchToCircuit(Circuit circuit, CircuitState state) {
        this.runFxSync(() -> {
            Tab tab;
            CircuitManager manager;
            if (state != null && (manager = this.getCircuitManager(circuit)) != null) {
                manager.getCircuitBoard().setCurrentState(state);
            }
            if ((tab = this.getTabForCircuit(circuit)) != null) {
                this.canvasTabPane.getSelectionModel().select((Object)tab);
                this.needsRepaint = true;
            }
        });
    }

    void readdCircuit(CircuitManager manager, Tab tab, int index) {
        this.canvasTabPane.getTabs().add(Math.min(index, this.canvasTabPane.getTabs().size()), (Object)tab);
        this.circuitManagers.put(tab.getText(), (Pair<ComponentManager.ComponentLauncherInfo, CircuitManager>)new Pair((Object)this.createSubcircuitLauncherInfo(tab.getText()), (Object)manager));
        manager.getCircuitBoard().setCurrentState(manager.getCircuit().getTopLevelState());
        this.canvasTabPane.getSelectionModel().select((Object)tab);
        this.refreshCircuitsTab();
    }

    boolean confirmAndDeleteCircuit(CircuitManager circuitManager, boolean removeTab) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.initOwner((Window)this.stage);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.setTitle("Delete \"" + circuitManager.getName() + "\"?");
        alert.setHeaderText("Delete \"" + circuitManager.getName() + "\"?");
        alert.setContentText("Are you sure you want to delete this circuit?");
        Optional result = alert.showAndWait();
        if (!result.isPresent() || result.get() != ButtonType.OK) {
            return false;
        }
        this.deleteCircuit(circuitManager, removeTab, true);
        return true;
    }

    public void deleteCircuit(String name) {
        this.deleteCircuit(name, true);
    }

    public void deleteCircuit(String name, boolean addNewOnEmpty) {
        this.deleteCircuit(this.getCircuitManager(name), true, addNewOnEmpty);
    }

    void deleteCircuit(CircuitManager manager, boolean removeTab, boolean addNewOnEmpty) {
        this.runFxSync(() -> {
            boolean isEmpty;
            this.clearSelection();
            Tab tab = this.getTabForCircuit(manager.getCircuit());
            if (tab == null) {
                throw new IllegalStateException("Tab shouldn't be null.");
            }
            int idx = this.canvasTabPane.getTabs().indexOf((Object)tab);
            if (idx == -1) {
                throw new IllegalStateException("Tab should be in the tab pane.");
            }
            if (removeTab) {
                this.canvasTabPane.getTabs().remove((Object)tab);
                isEmpty = this.canvasTabPane.getTabs().isEmpty();
            } else {
                isEmpty = this.canvasTabPane.getTabs().size() == 1;
            }
            this.editHistory.beginGroup();
            Pair<ComponentManager.ComponentLauncherInfo, CircuitManager> removed = this.circuitManagers.remove(tab.getText());
            this.circuitModified(((CircuitManager)removed.getValue()).getCircuit(), null, false);
            this.editHistory.addAction(EditHistory.EditAction.DELETE_CIRCUIT, manager, tab, idx);
            if (addNewOnEmpty && isEmpty) {
                this.createCircuit("New circuit");
                this.canvasTabPane.getSelectionModel().select(0);
            }
            this.editHistory.endGroup();
            this.refreshCircuitsTab();
        });
    }

    void clearProperties() {
        this.setProperties("", null);
    }

    void setProperties(ComponentPeer<?> componentPeer) {
        String name;
        if (componentPeer.getClass() == SubcircuitPeer.class) {
            name = componentPeer.getProperties().getProperty("Subcircuit").getStringValue();
        } else {
            ComponentManager.ComponentLauncherInfo info = this.componentManager.get(componentPeer.getClass(), componentPeer.getProperties());
            name = (String)info.name.getValue();
        }
        this.setProperties(name, componentPeer.getProperties());
    }

    void setProperties(String componentName, final Properties properties) {
        this.propertiesTable.getChildren().clear();
        if (properties != null) {
            this.componentLabel.setText(componentName);
            properties.forEach(new Consumer<Properties.Property<?>>(){

                @Override
                public void accept(Properties.Property<?> property) {
                    this.acceptProperty(property);
                }

                private <T> void acceptProperty(Properties.Property<T> property) {
                    int size = CircuitSim.this.propertiesTable.getChildren().size();
                    Label name = new Label(property.display);
                    GridPane.setHgrow((Node)name, (Priority)Priority.ALWAYS);
                    name.setMaxWidth(Double.MAX_VALUE);
                    name.setMinHeight(30.0);
                    name.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(size / 2 % 2 == 0 ? Color.LIGHTGRAY : Color.WHITE), null, null)}));
                    Node node = property.validator.createGui(CircuitSim.this.stage, property.value, newValue -> Platform.runLater(() -> {
                        Properties newProperties = new Properties(properties);
                        newProperties.setValue(property, newValue);
                        CircuitSim.this.updateProperties(newProperties);
                    }));
                    if (node != null) {
                        Pane valuePane = new Pane(new Node[]{node});
                        valuePane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(size / 2 % 2 == 0 ? Color.LIGHTGRAY : Color.WHITE), null, null)}));
                        GridPane.setHgrow((Node)valuePane, (Priority)Priority.ALWAYS);
                        CircuitSim.this.propertiesTable.addRow(size, new Node[]{name, valuePane});
                    }
                }
            });
        } else {
            this.componentLabel.setText("");
        }
    }

    private Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setValue(Properties.BITSIZE, this.bitSizeSelect.getSelectionModel().getSelectedItem());
        return properties;
    }

    void clearSelection() {
        if (this.buttonsToggleGroup.getSelectedToggle() != null) {
            this.buttonsToggleGroup.getSelectedToggle().setSelected(false);
        }
        this.modifiedSelection(null);
    }

    private void updateProperties(Properties properties) {
        if (this.selectedComponent == null) {
            this.modifiedSelection(null, properties);
        } else {
            properties = this.getDefaultProperties().union(this.selectedComponent.properties).union(properties);
            this.modifiedSelection(this.selectedComponent.creator, properties);
        }
    }

    private void modifiedSelection(ComponentManager.ComponentLauncherInfo component) {
        this.selectedComponent = component;
        if (component != null) {
            Properties properties = this.getDefaultProperties().union(component.properties);
            this.modifiedSelection(component.creator, properties);
        } else {
            this.modifiedSelection(null, null);
        }
    }

    private void modifiedSelection(ComponentManager.ComponentCreator<?> creator, Properties properties) {
        CircuitManager current = this.getCurrentCircuit();
        if (current != null) {
            current.modifiedSelection(creator, properties);
        }
    }

    private ImageView setupImageView(Image image) {
        ImageView imageView = new ImageView(image);
        imageView.setSmooth(true);
        return imageView;
    }

    private ToggleButton setupButton(ToggleGroup group, ComponentManager.ComponentLauncherInfo componentInfo) {
        ToggleButton button = new ToggleButton((String)componentInfo.name.getValue(), (Node)this.setupImageView(componentInfo.image));
        button.setAlignment(Pos.CENTER_LEFT);
        button.setToggleGroup(group);
        button.setMinHeight(30.0);
        button.setMaxWidth(Double.MAX_VALUE);
        button.setOnAction(e -> {
            if (button.isSelected()) {
                this.modifiedSelection(componentInfo);
            } else {
                this.modifiedSelection(null);
            }
        });
        GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
        return button;
    }

    void refreshCircuitsTab() {
        if (this.loadingFile) {
            return;
        }
        Platform.runLater(() -> {
            ScrollPane pane = new ScrollPane((Node)new GridPane());
            pane.setFitToWidth(true);
            if (this.circuitButtonsTab == null) {
                this.circuitButtonsTab = new Tab("Circuits");
                this.circuitButtonsTab.setClosable(false);
                this.circuitButtonsTab.setContent((Node)pane);
                this.buttonTabPane.getTabs().add((Object)this.circuitButtonsTab);
            } else {
                GridPane buttons = (GridPane)((ScrollPane)this.circuitButtonsTab.getContent()).getContent();
                buttons.getChildren().forEach(node -> {
                    ToggleButton button = (ToggleButton)node;
                    button.setToggleGroup(null);
                });
                buttons.getChildren().clear();
                this.circuitButtonsTab.setContent((Node)pane);
            }
            HashSet seen = new HashSet();
            this.canvasTabPane.getTabs().forEach(tab -> {
                String name = tab.getText();
                Pair<ComponentManager.ComponentLauncherInfo, CircuitManager> circuitPair = this.circuitManagers.get(name);
                if (circuitPair == null || seen.contains(name)) {
                    return;
                }
                seen.add(name);
                Object component = ((ComponentManager.ComponentLauncherInfo)circuitPair.getKey()).creator.createComponent(new Properties(), 0, 0);
                Canvas icon = new Canvas((double)(((GuiElement)component).getScreenWidth() + 10), (double)(((GuiElement)component).getScreenHeight() + 10));
                GraphicsContext graphics = icon.getGraphicsContext2D();
                graphics.translate(5.0, 5.0);
                ((GuiElement)component).paint(icon.getGraphicsContext2D(), null);
                ((ComponentPeer)component).getConnections().forEach(connection -> connection.paint(icon.getGraphicsContext2D(), null));
                ToggleButton toggleButton = new ToggleButton((String)((ComponentManager.ComponentLauncherInfo)circuitPair.getKey()).name.getValue(), (Node)icon);
                toggleButton.setAlignment(Pos.CENTER_LEFT);
                toggleButton.setToggleGroup(this.buttonsToggleGroup);
                toggleButton.setMinHeight(30.0);
                toggleButton.setMaxWidth(Double.MAX_VALUE);
                toggleButton.setOnAction(e -> {
                    if (toggleButton.isSelected()) {
                        this.modifiedSelection((ComponentManager.ComponentLauncherInfo)circuitPair.getKey());
                    } else {
                        this.modifiedSelection(null);
                    }
                });
                GridPane.setHgrow((Node)toggleButton, (Priority)Priority.ALWAYS);
                GridPane buttons = (GridPane)pane.getContent();
                buttons.addRow(buttons.getChildren().size(), new Node[]{toggleButton});
            });
        });
    }

    private void updateTitle() {
        String name = "";
        if (this.saveFile != null) {
            name = " - " + this.saveFile.getName();
        }
        if (this.editHistory.editStackSize() != this.savedEditStackSize) {
            name = name + " *";
        }
        this.stage.setTitle("CircuitSim v1.8.1" + name);
    }

    private ComponentManager.ComponentCreator<?> getSubcircuitPeerCreator(String name) {
        return (props, x, y) -> {
            Properties properties = new Properties(props);
            properties.parseAndSetValue("Subcircuit", new Properties.PropertyCircuitValidator(this), name);
            try {
                return new SubcircuitPeer(properties, x, y);
            }
            catch (SimulationException exc) {
                throw new SimulationException("Error creating subcircuit for circuit '" + name + "'", exc);
            }
            catch (Exception exc) {
                throw new RuntimeException("Error creating subcircuit for circuit '" + name + "':", exc);
            }
        };
    }

    private ComponentManager.ComponentLauncherInfo createSubcircuitLauncherInfo(String name) {
        return new ComponentManager.ComponentLauncherInfo(SubcircuitPeer.class, (Pair<String, String>)new Pair((Object)"Circuits", (Object)name), null, new Properties(), this.getSubcircuitPeerCreator(name));
    }

    public void renameCircuit(String name, String newName) {
        this.renameCircuit(this.getTabForCircuit(name), newName);
    }

    void renameCircuit(Tab tab, String newName) {
        this.runFxSync(() -> {
            if (this.circuitManagers.containsKey(newName)) {
                throw new IllegalArgumentException("Name already exists");
            }
            String oldName = tab.getText();
            Pair<ComponentManager.ComponentLauncherInfo, CircuitManager> removed = this.circuitManagers.remove(oldName);
            Pair newPair = new Pair((Object)this.createSubcircuitLauncherInfo(newName), removed.getValue());
            this.circuitManagers.put(newName, (Pair<ComponentManager.ComponentLauncherInfo, CircuitManager>)newPair);
            this.circuitManagers.values().forEach(componentPair -> {
                for (ComponentPeer<?> componentPeer : ((CircuitManager)componentPair.getValue()).getCircuitBoard().getComponents()) {
                    if (componentPeer.getClass() != SubcircuitPeer.class || ((Subcircuit)componentPeer.getComponent()).getSubcircuit() != ((CircuitManager)removed.getValue()).getCircuit()) continue;
                    componentPeer.getProperties().parseAndSetValue("Subcircuit", newName);
                }
            });
            tab.setText(newName);
            ((CircuitManager)newPair.getValue()).setName(newName);
            this.editHistory.addAction(EditHistory.EditAction.RENAME_CIRCUIT, null, new Object[]{this, tab, oldName, newName});
            this.refreshCircuitsTab();
        });
    }

    void updateCanvasSize(CircuitManager circuitManager) {
        OptionalInt maxX = Stream.concat(circuitManager.getSelectedElements().stream(), Stream.concat(circuitManager.getCircuitBoard().getComponents().stream(), circuitManager.getCircuitBoard().getLinks().stream().flatMap(links -> links.getWires().stream()))).mapToInt(componentPeer -> componentPeer.getX() + componentPeer.getWidth()).max();
        double maxWidth = Math.min(5000.0, this.getScaleFactor() * (double)(maxX.orElse(0) + 5) * 10.0);
        circuitManager.getCanvas().setWidth(maxWidth < circuitManager.getCanvasScrollPane().getWidth() ? circuitManager.getCanvasScrollPane().getWidth() : maxWidth);
        OptionalInt maxY = Stream.concat(circuitManager.getSelectedElements().stream(), Stream.concat(circuitManager.getCircuitBoard().getComponents().stream(), circuitManager.getCircuitBoard().getLinks().stream().flatMap(links -> links.getWires().stream()))).mapToInt(componentPeer -> componentPeer.getY() + componentPeer.getHeight()).max();
        double maxHeight = Math.min(5000.0, this.getScaleFactor() * (double)(maxY.orElse(0) + 5) * 10.0);
        circuitManager.getCanvas().setHeight(maxHeight < circuitManager.getCanvasScrollPane().getHeight() ? circuitManager.getCanvasScrollPane().getHeight() : maxHeight);
        this.needsRepaint = true;
    }

    void circuitModified(Circuit circuit, Component component, boolean added) {
        if (component == null || component instanceof Pin) {
            this.refreshCircuitsTab();
            this.circuitManagers.values().forEach(componentPair -> {
                for (ComponentPeer<?> componentPeer : new HashSet(((CircuitManager)componentPair.getValue()).getCircuitBoard().getComponents())) {
                    SubcircuitPeer peer;
                    if (componentPeer.getClass() != SubcircuitPeer.class || ((Subcircuit)(peer = (SubcircuitPeer)componentPeer).getComponent()).getSubcircuit() != circuit) continue;
                    CircuitNode node = this.getSubcircuitStates((Subcircuit)peer.getComponent(), ((CircuitManager)componentPair.getValue()).getCircuitBoard().getCurrentState());
                    ((CircuitManager)componentPair.getValue()).getSelectedElements().remove(peer);
                    if (component == null) {
                        ((CircuitManager)componentPair.getValue()).mayThrow(() -> ((CircuitManager)componentPair.getValue()).getCircuitBoard().removeElements(Collections.singleton(peer)));
                        this.resetSubcircuitStates(node);
                        continue;
                    }
                    SubcircuitPeer newSubcircuit = new SubcircuitPeer(componentPeer.getProperties(), componentPeer.getX(), componentPeer.getY());
                    this.editHistory.disable();
                    ((CircuitManager)componentPair.getValue()).mayThrow(() -> ((CircuitManager)componentPair.getValue()).getCircuitBoard().updateComponent(peer, newSubcircuit));
                    this.editHistory.enable();
                    node.subcircuit = (Subcircuit)newSubcircuit.getComponent();
                    this.updateSubcircuitStates(node, ((CircuitManager)componentPair.getValue()).getCircuitBoard().getCurrentState());
                }
            });
        } else if (component instanceof Subcircuit && !added) {
            Subcircuit subcircuit = (Subcircuit)component;
            CircuitNode node = this.getSubcircuitStates(subcircuit, this.getCircuitManager(circuit).getCircuitBoard().getCurrentState());
            this.resetSubcircuitStates(node);
        }
    }

    private CircuitNode getSubcircuitStates(Subcircuit subcircuit, CircuitState parentState) {
        CircuitState subcircuitState = subcircuit.getSubcircuitState(parentState);
        CircuitNode circuitNode = new CircuitNode(subcircuit, subcircuitState);
        for (Component component : subcircuit.getSubcircuit().getComponents()) {
            if (!(component instanceof Subcircuit)) continue;
            circuitNode.children.add(this.getSubcircuitStates((Subcircuit)component, subcircuitState));
        }
        return circuitNode;
    }

    private void updateSubcircuitStates(CircuitNode node, CircuitState parentState) {
        CircuitManager manager = this.getCircuitManager(node.subcircuit.getSubcircuit());
        CircuitState subState = node.subcircuit.getSubcircuitState(parentState);
        if (manager != null && manager.getCircuitBoard().getCurrentState() == node.subcircuitState) {
            manager.getCircuitBoard().setCurrentState(subState);
        }
        for (CircuitNode child : node.children) {
            this.updateSubcircuitStates(child, subState);
        }
    }

    private void resetSubcircuitStates(CircuitNode node) {
        CircuitManager manager = this.getCircuitManager(node.subcircuit.getSubcircuit());
        if (manager != null && manager.getCircuitBoard().getCurrentState() == node.subcircuitState) {
            manager.getCircuitBoard().setCurrentState(manager.getCircuit().getTopLevelState());
        }
        for (CircuitNode child : node.children) {
            this.resetSubcircuitStates(child);
        }
    }

    private boolean checkUnsavedChanges() {
        this.clearSelection();
        if (this.editHistory.editStackSize() != this.savedEditStackSize) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.initOwner((Window)this.stage);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setTitle("Unsaved changes");
            alert.setHeaderText("Unsaved changes");
            alert.setContentText("There are unsaved changes, do you want to save them?");
            ButtonType discard = new ButtonType("Discard", ButtonBar.ButtonData.NO);
            alert.getButtonTypes().add((Object)discard);
            Optional result = alert.showAndWait();
            if (result.isPresent()) {
                if (result.get() == ButtonType.OK) {
                    this.saveCircuitsInternal();
                    return this.saveFile == null;
                }
                return result.get() == ButtonType.CANCEL;
            }
        }
        return false;
    }

    public void clearCircuits() {
        this.runFxSync(() -> {
            Clock.reset(this.simulator);
            this.clockEnabled.setSelected(false);
            this.editHistory.disable();
            this.circuitManagers.forEach((name, pair) -> ((CircuitManager)pair.getValue()).destroy());
            this.editHistory.enable();
            this.circuitManagers.clear();
            this.canvasTabPane.getTabs().clear();
            this.simulator.clear();
            this.editHistory.clear();
            this.savedEditStackSize = 0;
            this.saveFile = null;
            this.undo.setDisable(true);
            this.redo.setDisable(true);
            this.updateTitle();
            this.refreshCircuitsTab();
        });
    }

    void copySelectedComponents() {
        CircuitManager manager = this.getCurrentCircuit();
        if (manager != null) {
            Set<GuiElement> selectedElements = manager.getSelectedElements();
            if (selectedElements.isEmpty()) {
                return;
            }
            List<FileFormat.ComponentInfo> components = selectedElements.stream().filter(element -> element instanceof ComponentPeer).map(element -> (ComponentPeer)element).map(component -> new FileFormat.ComponentInfo(component.getClass().getName(), component.getX(), component.getY(), component.getProperties())).collect(Collectors.toList());
            List<FileFormat.WireInfo> wires = selectedElements.stream().filter(element -> element instanceof LinkWires.Wire).map(element -> (LinkWires.Wire)element).map(wire -> new FileFormat.WireInfo(wire.getX(), wire.getY(), wire.getLength(), wire.isHorizontal())).collect(Collectors.toList());
            try {
                String data = FileFormat.stringify(new FileFormat.CircuitFile(0, 0, null, Collections.singletonList(new FileFormat.CircuitInfo("Copy", components, wires))));
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.put((Object)copyDataFormat, (Object)data);
                clipboard.setContent((Map)content);
            }
            catch (Exception exc) {
                this.setLastException(exc);
                this.getDebugUtil().logException("Error while copying", exc);
            }
        }
    }

    void cutSelectedComponents() {
        CircuitManager manager = this.getCurrentCircuit();
        if (manager != null) {
            this.copySelectedComponents();
            manager.mayThrow(() -> manager.getCircuitBoard().finalizeMove());
            Set<GuiElement> selectedElements = manager.getSelectedElements();
            manager.mayThrow(() -> manager.getCircuitBoard().removeElements(selectedElements));
            this.clearSelection();
            this.needsRepaint = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pasteFromClipboard() {
        block15: {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            String data = (String)clipboard.getContent(copyDataFormat);
            if (data != null) {
                try {
                    this.editHistory.beginGroup();
                    FileFormat.CircuitFile parsed = FileFormat.parse(data);
                    CircuitManager manager = this.getCurrentCircuit();
                    if (manager == null) break block15;
                    int i = 0;
                    while (true) {
                        block16: {
                            HashSet elementsCreated = new HashSet();
                            for (FileFormat.CircuitInfo circuit : parsed.circuits) {
                                for (FileFormat.ComponentInfo component : circuit.components) {
                                    try {
                                        Class<?> clazz = Class.forName(component.name);
                                        Properties properties = new Properties();
                                        component.properties.forEach((key, value) -> properties.setProperty(new Properties.Property<String>((String)key, null, (String)value)));
                                        ComponentManager.ComponentCreator<?> creator = clazz == SubcircuitPeer.class ? this.getSubcircuitPeerCreator(properties.getValueOrDefault("Subcircuit", "")) : this.componentManager.get(clazz, (Properties)properties).creator;
                                        Object created = creator.createComponent(properties, component.x + i, component.y + i);
                                        if (!manager.getCircuitBoard().isValidLocation((ComponentPeer<?>)created)) {
                                            elementsCreated.clear();
                                            break block16;
                                        }
                                        elementsCreated.add(created);
                                    }
                                    catch (SimulationException exc) {
                                        exc.printStackTrace();
                                        this.setLastException(exc);
                                    }
                                    catch (Exception exc) {
                                        this.setLastException(exc);
                                        this.getDebugUtil().logException("Error loading component " + component.name, exc);
                                    }
                                }
                            }
                            int offset = i;
                            this.simulator.runSync(() -> {
                                manager.getCircuitBoard().finalizeMove();
                                this.editHistory.disable();
                                elementsCreated.forEach(element -> manager.mayThrow(() -> manager.getCircuitBoard().addComponent((ComponentPeer)element, false)));
                                manager.getCircuitBoard().removeElements(elementsCreated, false);
                                this.editHistory.enable();
                                for (FileFormat.CircuitInfo circuit : parsed.circuits) {
                                    for (FileFormat.WireInfo wire : circuit.wires) {
                                        elementsCreated.add(new LinkWires.Wire(null, wire.x + offset, wire.y + offset, wire.length, wire.isHorizontal));
                                    }
                                }
                                manager.setSelectedElements(elementsCreated);
                                manager.mayThrow(() -> manager.getCircuitBoard().initMove(elementsCreated, false));
                            });
                            break;
                        }
                        i += 3;
                    }
                }
                catch (SimulationException exc) {
                    exc.printStackTrace();
                    this.setLastException(exc);
                }
                catch (Exception exc) {
                    this.setLastException(exc);
                    this.getDebugUtil().logException("Error while pasting", exc);
                }
                finally {
                    this.editHistory.endGroup();
                    this.needsRepaint = true;
                }
            }
        }
    }

    private void checkForUpdate(boolean showOk) {
        if (checkingForUpdate.compareAndSet(false, true)) {
            Thread versionCheckThread = new Thread(() -> {
                try {
                    String remoteVersion;
                    URL url = new URL("https://www.roiatalla.com/public/CircuitSim/version.txt");
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                        remoteVersion = reader.readLine();
                    }
                    catch (IOException exc) {
                        System.err.println("Error checking server for version.");
                        exc.printStackTrace();
                        if (showOk) {
                            this.runFxSync(() -> {
                                Alert alert = new Alert(Alert.AlertType.ERROR);
                                alert.initOwner((Window)this.stage);
                                alert.initModality(Modality.APPLICATION_MODAL);
                                alert.setTitle("Error");
                                alert.setHeaderText("Error checking server");
                                alert.setContentText("Error occurred when checking server for new update.\n" + exc);
                                alert.show();
                            });
                        }
                        checkingForUpdate.set(false);
                        return;
                    }
                    boolean updateAvailable = false;
                    String local = VERSION;
                    int beta = local.indexOf(98);
                    if (beta != -1) {
                        local = local.substring(0, beta);
                    }
                    String[] parts = local.split("\\.");
                    int localMajor = Integer.parseInt(parts[0]);
                    int localMinor = Integer.parseInt(parts[1]);
                    int localBugfix = Integer.parseInt(parts[2]);
                    parts = remoteVersion.split("\\.");
                    int remoteMajor = Integer.parseInt(parts[0]);
                    int remoteMinor = Integer.parseInt(parts[1]);
                    int remoteBugfix = Integer.parseInt(parts[2]);
                    if (remoteMajor > localMajor) {
                        updateAvailable = true;
                    } else if (remoteMajor == localMajor) {
                        if (remoteMinor > localMinor) {
                            updateAvailable = true;
                        } else if (remoteMinor == localMinor) {
                            if (remoteBugfix > localBugfix) {
                                updateAvailable = true;
                            }
                            if (beta != -1 && remoteBugfix == localBugfix) {
                                updateAvailable = true;
                            }
                        }
                    }
                    if (updateAvailable) {
                        this.runFxSync(() -> {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION);
                            alert.initOwner((Window)this.stage);
                            alert.initModality(Modality.APPLICATION_MODAL);
                            alert.setTitle("New Version Available");
                            alert.setHeaderText("New version available: CircuitSim v" + remoteVersion);
                            alert.setContentText("Click Update to open a browser to the download location.");
                            alert.getButtonTypes().set(0, (Object)new ButtonType("Update", ButtonBar.ButtonData.OK_DONE));
                            alert.getButtonTypes().add((Object)ButtonType.CANCEL);
                            Optional result = alert.showAndWait();
                            if (result.isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                                this.getHostServices().showDocument("https://www.roiatalla.com/public/CircuitSim/");
                            }
                        });
                    } else if (showOk) {
                        this.runFxSync(() -> {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION);
                            alert.initOwner((Window)this.stage);
                            alert.initModality(Modality.APPLICATION_MODAL);
                            alert.setTitle("No new updates");
                            alert.setHeaderText("No new updates");
                            alert.setContentText("You have the latest version and are good to go! :)");
                            alert.show();
                        });
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                finally {
                    checkingForUpdate.set(false);
                }
            });
            versionCheckThread.setDaemon(true);
            versionCheckThread.setName("Version Check Thread");
            versionCheckThread.start();
        }
    }

    private void loadConfFile() {
        boolean showHelp = true;
        String home = System.getProperty("user.home");
        File file = new File(home, ".circuitsim");
        if (file.exists()) {
            boolean newWindow = this.getParameters() == null;
            try {
                List<String> lines = Files.readAllLines(file.toPath());
                for (String line : lines) {
                    int idx;
                    if ((line = line.trim()).charAt(0) == '#') continue;
                    int comment = line.indexOf(35);
                    if (comment != -1) {
                        line = line.substring(0, comment).trim();
                    }
                    if ((idx = line.indexOf(61)) == -1) continue;
                    String key = line.substring(0, idx).trim();
                    String value = line.substring(idx + 1).trim();
                    switch (key) {
                        case "WindowX": {
                            this.stage.setX((double)(Integer.parseInt(value) + (newWindow ? 20 : 0)));
                            break;
                        }
                        case "WindowY": {
                            this.stage.setY((double)(Integer.parseInt(value) + (newWindow ? 20 : 0)));
                            break;
                        }
                        case "WindowWidth": {
                            this.stage.setWidth((double)Integer.parseInt(value));
                            break;
                        }
                        case "WindowHeight": {
                            this.stage.setHeight((double)Integer.parseInt(value));
                            break;
                        }
                        case "IsMaximized": {
                            if (newWindow) break;
                            this.stage.setMaximized(Boolean.parseBoolean(value));
                            break;
                        }
                        case "Scale": {
                            this.scaleFactorSelect.setValue((Object)Double.parseDouble(value));
                            break;
                        }
                        case "LastSavePath": {
                            this.lastSaveFile = new File(value);
                            break;
                        }
                        case "HelpShown": {
                            if (!value.equals(VERSION)) break;
                            showHelp = false;
                        }
                    }
                }
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
            catch (Exception exc) {
                this.getDebugUtil().logException("Error loading configuration file: " + file, exc);
            }
        }
        if (this.openWindow && showHelp) {
            this.help.fire();
        }
    }

    private void saveConfFile() {
        if (!this.openWindow) {
            return;
        }
        String home = System.getProperty("user.home");
        File file = new File(home, ".circuitsim");
        ArrayList<String> conf = new ArrayList<String>();
        if (this.stage.isMaximized()) {
            conf.add("IsMaximized=true");
        } else {
            conf.add("WindowX=" + (int)this.stage.getX());
            conf.add("WindowY=" + (int)this.stage.getY());
            conf.add("WindowWidth=" + (int)this.stage.getWidth());
            conf.add("WindowHeight=" + (int)this.stage.getHeight());
        }
        conf.add("Scale=" + this.scaleFactorSelect.getValue());
        conf.add("HelpShown=1.8.1");
        if (this.lastSaveFile != null) {
            conf.add("LastSavePath=" + this.lastSaveFile.getAbsolutePath());
        }
        try {
            Files.write(file.toPath(), conf, new OpenOption[0]);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    private void loadCircuitsInternal(File file) {
        String errorMessage = null;
        try {
            this.loadCircuits(file);
        }
        catch (ClassNotFoundException exc) {
            errorMessage = "Could not find class:\n" + exc.getMessage();
        }
        catch (JsonSyntaxException exc) {
            errorMessage = "Could not parse file:\n" + exc.getCause().getMessage();
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | NullPointerException exc) {
            exc.printStackTrace();
            errorMessage = "Error: " + exc.getMessage();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            exc.printStackTrace(new PrintStream(stream));
            errorMessage = stream.toString();
        }
        if (errorMessage != null) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner((Window)this.stage);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setTitle("Error loading circuits");
            alert.setHeaderText("Error loading circuits");
            alert.getDialogPane().setContent((Node)new TextArea(errorMessage));
            alert.showAndWait();
        }
    }

    public void loadCircuits(File file) throws Exception {
        CountDownLatch loadFileLatch = new CountDownLatch(1);
        this.runFxSync(() -> {
            File f = file;
            if (f == null) {
                File initialDirectory = this.lastSaveFile == null || this.lastSaveFile.getParentFile() == null || !this.lastSaveFile.getParentFile().isDirectory() ? new File(System.getProperty("user.dir")) : this.lastSaveFile.getParentFile();
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Choose sim file");
                fileChooser.setInitialDirectory(initialDirectory);
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Circuit Sim file", new String[]{"*.sim"}), new FileChooser.ExtensionFilter("All files", new String[]{"*"})});
                f = fileChooser.showOpenDialog((Window)this.stage);
            }
            if (f != null) {
                ProgressBar bar = new ProgressBar();
                Dialog dialog = new Dialog();
                dialog.initOwner((Window)this.stage);
                dialog.initModality(Modality.WINDOW_MODAL);
                dialog.setTitle("Loading " + f.getName() + "...");
                dialog.setHeaderText("Loading " + f.getName() + "...");
                dialog.setContentText("Parsing file...");
                dialog.setGraphic((Node)bar);
                this.lastSaveFile = f;
                Thread loadThread = new Thread(() -> {
                    try {
                        this.loadingFile = true;
                        this.editHistory.disable();
                        FileFormat.CircuitFile circuitFile = FileFormat.load(this.lastSaveFile);
                        if (circuitFile.circuits == null) {
                            throw new NullPointerException("File missing circuits");
                        }
                        this.clearCircuits();
                        if (circuitFile.libraryPaths != null) {
                            for (String string : circuitFile.libraryPaths) {
                                File libraryFile = new File(string);
                                if (!libraryFile.isFile()) continue;
                                Platform.runLater(() -> dialog.setContentText("Loading library " + libraryFile.getName()));
                                this.runFxSync(() -> this.loadLibrary(libraryFile));
                            }
                        }
                        Platform.runLater(() -> {
                            bar.setProgress(0.1);
                            dialog.setContentText("Creating circuits...");
                        });
                        int totalComponents = 0;
                        for (FileFormat.CircuitInfo circuit : circuitFile.circuits) {
                            if (this.circuitManagers.containsKey(circuit.name)) {
                                throw new IllegalStateException("Duplicate circuit names not allowed.");
                            }
                            this.createCircuit(circuit.name);
                            if (circuit.components == null) {
                                throw new NullPointerException("Circuit " + circuit.name + " missing components");
                            }
                            if (circuit.wires == null) {
                                throw new NullPointerException("Circuit " + circuit.name + " missing wires");
                            }
                            totalComponents += circuit.components.size() + circuit.wires.size();
                        }
                        Platform.runLater(() -> dialog.setContentText("Creating components..."));
                        ArrayDeque<Runnable> arrayDeque = new ArrayDeque<Runnable>();
                        CountDownLatch latch = new CountDownLatch(totalComponents + 1);
                        double increment = (1.0 - bar.getProgress()) / (double)totalComponents;
                        for (FileFormat.CircuitInfo circuit : circuitFile.circuits) {
                            CircuitManager manager = this.getCircuitManager(circuit.name);
                            for (FileFormat.ComponentInfo component : circuit.components) {
                                Class<?> clazz = Class.forName(component.name);
                                Properties properties = new Properties();
                                if (component.properties != null) {
                                    component.properties.forEach((key, value) -> properties.setProperty(new Properties.Property<String>((String)key, null, (String)value)));
                                }
                                ComponentManager.ComponentCreator<?> creator = clazz == SubcircuitPeer.class ? this.getSubcircuitPeerCreator(properties.getValueOrDefault("Subcircuit", "")) : this.componentManager.get(clazz, (Properties)properties).creator;
                                arrayDeque.add(() -> {
                                    manager.mayThrow(() -> manager.getCircuitBoard().addComponent((ComponentPeer<?>)creator.createComponent(properties, component.x, component.y)));
                                    bar.setProgress(bar.getProgress() + increment);
                                    latch.countDown();
                                });
                            }
                            for (FileFormat.WireInfo wire : circuit.wires) {
                                arrayDeque.add(() -> {
                                    manager.mayThrow(() -> manager.getCircuitBoard().addWire(wire.x, wire.y, wire.length, wire.isHorizontal));
                                    bar.setProgress(bar.getProgress() + increment);
                                    latch.countDown();
                                });
                            }
                        }
                        int comps = totalComponents;
                        Thread tasksThread = new Thread(() -> {
                            int maxRunLater = Math.max(comps / 20, 50);
                            while (!runnables.isEmpty()) {
                                int left = Math.min(runnables.size(), maxRunLater);
                                CountDownLatch l = new CountDownLatch(left);
                                for (int i = 0; i < left; ++i) {
                                    Runnable r = (Runnable)runnables.poll();
                                    Platform.runLater(() -> {
                                        r.run();
                                        l.countDown();
                                    });
                                }
                                try {
                                    l.await();
                                }
                                catch (Exception exception) {}
                            }
                            Platform.runLater(() -> {
                                this.circuitManagers.values().stream().map(Pair::getValue).forEach(this::updateCanvasSize);
                                for (MenuItem freq : this.frequenciesMenu.getItems()) {
                                    if (!freq.getText().startsWith(String.valueOf(circuitFile.clockSpeed))) continue;
                                    ((RadioMenuItem)freq).setSelected(true);
                                    break;
                                }
                                if (circuitFile.globalBitSize >= 1 && circuitFile.globalBitSize <= 32) {
                                    this.bitSizeSelect.getSelectionModel().select((Object)circuitFile.globalBitSize);
                                }
                                latch.countDown();
                            });
                        });
                        tasksThread.setName("LoadCircuits Tasks Thread");
                        tasksThread.start();
                        latch.await();
                        this.saveFile = this.lastSaveFile;
                    }
                    catch (Exception exc) {
                        this.clearCircuits();
                        this.excThrown = exc;
                    }
                    finally {
                        if (this.circuitManagers.size() == 0) {
                            this.createCircuit("New circuit");
                        }
                        this.editHistory.enable();
                        this.loadingFile = false;
                        this.runFxSync(() -> {
                            this.updateTitle();
                            this.refreshCircuitsTab();
                            dialog.setResult((Object)ButtonType.OK);
                            dialog.close();
                            loadFileLatch.countDown();
                        });
                    }
                });
                loadThread.setName("LoadCircuits");
                loadThread.start();
                if (this.openWindow) {
                    dialog.showAndWait();
                }
            } else {
                loadFileLatch.countDown();
            }
        });
        try {
            loadFileLatch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveConfFile();
        if (this.excThrown != null) {
            Exception toThrow = this.excThrown;
            this.excThrown = null;
            throw toThrow;
        }
    }

    private void loadLibrary(File file) {
        try (JarFile jarFile = new JarFile(file);){
            Path libraryDir;
            Path currDir;
            Path relativePath;
            String relative;
            Enumeration<JarEntry> e = jarFile.entries();
            URLClassLoader cl = URLClassLoader.newInstance(new URL[]{file.toURI().toURL()});
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                try {
                    String className = je.getName().substring(0, je.getName().length() - 6);
                    Class<?> c = cl.loadClass(className = className.replace('/', '.'));
                    if (!ComponentPeer.class.isAssignableFrom(c)) continue;
                    Class<?> cc = c;
                    this.componentManager.register(cc);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.initOwner((Window)this.stage);
                    alert.initModality(Modality.WINDOW_MODAL);
                    alert.setTitle("Error loading class");
                    alert.setHeaderText("Error loading class");
                    alert.setContentText("Error when loading class: " + t.getMessage());
                    alert.getButtonTypes().add((Object)ButtonType.CANCEL);
                    Optional buttonType = alert.showAndWait();
                    if (!buttonType.isPresent() || buttonType.get() != ButtonType.CANCEL) continue;
                    break;
                }
            }
            if (this.libraryPaths == null) {
                this.libraryPaths = new ArrayList<String>();
            }
            if (!this.libraryPaths.contains(relative = (relativePath = (currDir = Paths.get(System.getProperty("user.dir"), new String[0])).relativize(libraryDir = file.toPath().toAbsolutePath())).toString())) {
                this.libraryPaths.add(relative);
            }
            this.refreshComponentsTabs.run();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner((Window)this.stage);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setTitle("Error opening library");
            alert.setHeaderText("Error opening library");
            alert.setContentText("Error when opening library: " + exc.getMessage());
            alert.showAndWait();
        }
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    private void saveCircuitsInternal() {
        try {
            this.saveCircuits();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner((Window)this.stage);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setTitle("Error");
            alert.setHeaderText("Error saving circuit.");
            alert.setContentText("Error when saving the circuit: " + exc.getMessage());
            alert.showAndWait();
        }
    }

    public void saveCircuits() throws Exception {
        this.saveCircuits(this.saveFile);
    }

    public void saveCircuits(File file) throws Exception {
        this.runFxSync(() -> {
            File f = file;
            if (f == null) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Choose sim file");
                fileChooser.setInitialDirectory(this.lastSaveFile == null ? new File(System.getProperty("user.dir")) : this.lastSaveFile.getParentFile());
                fileChooser.setInitialFileName("My circuit.sim");
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Circuit Sim file", new String[]{"*.sim"}));
                f = fileChooser.showSaveDialog((Window)this.stage);
            }
            if (f != null) {
                this.lastSaveFile = f;
                ArrayList<FileFormat.CircuitInfo> circuits = new ArrayList<FileFormat.CircuitInfo>();
                this.canvasTabPane.getTabs().forEach(tab -> {
                    String name = tab.getText();
                    CircuitManager manager = (CircuitManager)this.circuitManagers.get(name).getValue();
                    List<FileFormat.ComponentInfo> components = manager.getCircuitBoard().getComponents().stream().map(component -> new FileFormat.ComponentInfo(component.getClass().getName(), component.getX(), component.getY(), component.getProperties())).sorted(Comparator.comparingInt(Object::hashCode)).collect(Collectors.toList());
                    List<FileFormat.WireInfo> wires = manager.getCircuitBoard().getLinks().stream().flatMap(linkWires -> linkWires.getWires().stream()).map(wire -> new FileFormat.WireInfo(wire.getX(), wire.getY(), wire.getLength(), wire.isHorizontal())).sorted(Comparator.comparingInt(Object::hashCode)).collect(Collectors.toList());
                    circuits.add(new FileFormat.CircuitInfo(name, components, wires));
                });
                try {
                    FileFormat.save(f, new FileFormat.CircuitFile((Integer)this.bitSizeSelect.getSelectionModel().getSelectedItem(), this.getCurrentClockSpeed(), this.libraryPaths, circuits));
                    this.savedEditStackSize = this.editHistory.editStackSize();
                    this.saveFile = f;
                    this.updateTitle();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.excThrown = exc;
                }
            }
        });
        this.saveConfFile();
        if (this.excThrown != null) {
            Exception toThrow = this.excThrown;
            this.excThrown = null;
            throw toThrow;
        }
    }

    public void createCircuit(String name) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("Name cannot be null or empty");
        }
        this.runFxSync(() -> {
            String n = name;
            Canvas canvas = new Canvas(800.0, 600.0);
            canvas.setFocusTraversable(true);
            ScrollPane canvasScrollPane = new ScrollPane((Node)canvas);
            canvasScrollPane.setFocusTraversable(true);
            CircuitManager circuitManager = new CircuitManager(n, this, canvasScrollPane, this.simulator);
            circuitManager.getCircuit().addListener(this::circuitModified);
            canvas.addEventHandler(MouseEvent.ANY, e -> canvas.requestFocus());
            canvas.addEventHandler(MouseEvent.MOUSE_MOVED, circuitManager::mouseMoved);
            canvas.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> {
                circuitManager.mouseDragged((MouseEvent)e);
                this.updateCanvasSize(circuitManager);
            });
            canvas.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
                circuitManager.mousePressed((MouseEvent)e);
                e.consume();
            });
            canvas.addEventHandler(MouseEvent.MOUSE_RELEASED, circuitManager::mouseReleased);
            canvas.addEventHandler(ScrollEvent.SCROLL, circuitManager::mouseWheelScrolled);
            canvas.addEventHandler(MouseEvent.MOUSE_ENTERED, circuitManager::mouseEntered);
            canvas.addEventHandler(MouseEvent.MOUSE_EXITED, circuitManager::mouseExited);
            canvas.addEventHandler(KeyEvent.KEY_PRESSED, circuitManager::keyPressed);
            canvas.addEventHandler(KeyEvent.KEY_TYPED, circuitManager::keyTyped);
            canvas.addEventHandler(KeyEvent.KEY_RELEASED, circuitManager::keyReleased);
            canvas.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    circuitManager.focusGained();
                } else {
                    circuitManager.focusLost();
                }
            });
            canvasScrollPane.widthProperty().addListener((observable, oldValue, newValue) -> this.updateCanvasSize(circuitManager));
            canvasScrollPane.heightProperty().addListener((observable, oldValue, newValue) -> this.updateCanvasSize(circuitManager));
            String originalName = n;
            int count = 0;
            while (this.getCircuitManager(originalName) != null) {
                originalName = n;
                if (count > 0) {
                    originalName = originalName + count;
                }
                ++count;
            }
            n = originalName;
            circuitManager.setName(n);
            Tab canvasTab = new Tab(n, (Node)canvasScrollPane);
            MenuItem rename = new MenuItem("Rename");
            rename.setOnAction(event -> {
                String lastTyped = canvasTab.getText();
                while (true) {
                    try {
                        TextInputDialog dialog = new TextInputDialog(lastTyped);
                        dialog.setTitle("Rename circuit");
                        dialog.setHeaderText("Rename circuit");
                        dialog.setContentText("Enter new name:");
                        Optional value = dialog.showAndWait();
                        if (!value.isPresent() || (lastTyped = ((String)value.get()).trim()).isEmpty() || lastTyped.equals(canvasTab.getText())) break;
                        this.renameCircuit(canvasTab, lastTyped);
                        this.clearSelection();
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.initOwner((Window)this.stage);
                        alert.initModality(Modality.WINDOW_MODAL);
                        alert.setTitle("Duplicate name");
                        alert.setHeaderText("Duplicate name");
                        alert.setContentText("Name already exists, please choose a new name.");
                        alert.showAndWait();
                        continue;
                    }
                    break;
                }
            });
            MenuItem viewTopLevelState = new MenuItem("View top-level state");
            viewTopLevelState.setOnAction(event -> circuitManager.getCircuitBoard().setCurrentState(circuitManager.getCircuit().getTopLevelState()));
            MenuItem moveLeft = new MenuItem("Move left");
            moveLeft.setOnAction(event -> {
                ObservableList tabs = this.canvasTabPane.getTabs();
                int idx = tabs.indexOf((Object)canvasTab);
                if (idx > 0) {
                    tabs.remove(idx);
                    tabs.add(idx - 1, (Object)canvasTab);
                    this.canvasTabPane.getSelectionModel().select((Object)canvasTab);
                    this.editHistory.addAction(EditHistory.EditAction.MOVE_CIRCUIT, circuitManager, tabs, canvasTab, idx, idx - 1);
                    this.refreshCircuitsTab();
                }
            });
            MenuItem moveRight = new MenuItem("Move right");
            moveRight.setOnAction(event -> {
                ObservableList tabs = this.canvasTabPane.getTabs();
                int idx = tabs.indexOf((Object)canvasTab);
                if (idx >= 0 && idx < tabs.size() - 1) {
                    tabs.remove(idx);
                    tabs.add(idx + 1, (Object)canvasTab);
                    this.canvasTabPane.getSelectionModel().select((Object)canvasTab);
                    this.editHistory.addAction(EditHistory.EditAction.MOVE_CIRCUIT, circuitManager, tabs, canvasTab, idx, idx + 1);
                    this.refreshCircuitsTab();
                }
            });
            canvasTab.setContextMenu(new ContextMenu(new MenuItem[]{rename, viewTopLevelState, moveLeft, moveRight}));
            canvasTab.setOnCloseRequest(event -> {
                if (!this.confirmAndDeleteCircuit(circuitManager, false)) {
                    event.consume();
                }
            });
            this.circuitManagers.put(canvasTab.getText(), (Pair<ComponentManager.ComponentLauncherInfo, CircuitManager>)new Pair((Object)this.createSubcircuitLauncherInfo(n), (Object)circuitManager));
            this.canvasTabPane.getTabs().add((Object)canvasTab);
            this.refreshCircuitsTab();
            this.editHistory.addAction(EditHistory.EditAction.CREATE_CIRCUIT, circuitManager, canvasTab, this.canvasTabPane.getTabs().size() - 1);
            canvas.requestFocus();
        });
    }

    public void start(Stage stage) {
        int i;
        if (this.stage != null) {
            throw new IllegalStateException("Already started");
        }
        this.stage = stage;
        stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/resources/Icon.png")));
        this.bitSizeSelect = new ComboBox();
        for (i = 1; i <= 32; ++i) {
            this.bitSizeSelect.getItems().add((Object)i);
        }
        this.bitSizeSelect.setValue((Object)1);
        this.bitSizeSelect.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.modifiedSelection(this.selectedComponent));
        this.scaleFactorSelect = new ComboBox();
        for (i = 3; i <= 10; ++i) {
            this.scaleFactorSelect.getItems().add((Object)((double)i / 10.0));
        }
        for (i = 1; i <= 16; ++i) {
            this.scaleFactorSelect.getItems().add((Object)(1.0 + (double)i * 0.25));
        }
        this.scaleFactorSelect.setValue((Object)1.0);
        this.scaleFactorSelect.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.needsRepaint = true;
            for (Pair<ComponentManager.ComponentLauncherInfo, CircuitManager> pair : this.circuitManagers.values()) {
                this.updateCanvasSize((CircuitManager)pair.getValue());
            }
        });
        this.buttonTabPane = new TabPane();
        this.buttonTabPane.setSide(Side.TOP);
        this.propertiesTable = new GridPane();
        this.componentLabel = new Label();
        this.componentLabel.setFont(GuiUtils.getFont(16));
        this.canvasTabPane = new TabPane();
        this.canvasTabPane.setPrefWidth(800.0);
        this.canvasTabPane.setPrefHeight(600.0);
        this.canvasTabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.canvasTabPane.widthProperty().addListener((observable, oldValue, newValue) -> {
            this.needsRepaint = true;
        });
        this.canvasTabPane.heightProperty().addListener((observable, oldValue, newValue) -> {
            this.needsRepaint = true;
        });
        this.canvasTabPane.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            CircuitManager newManager;
            CircuitManager oldManager = oldValue == null || !this.circuitManagers.containsKey(oldValue.getText()) ? null : (CircuitManager)this.circuitManagers.get(oldValue.getText()).getValue();
            CircuitManager circuitManager = newManager = newValue == null || !this.circuitManagers.containsKey(newValue.getText()) ? null : (CircuitManager)this.circuitManagers.get(newValue.getText()).getValue();
            if (oldManager != null && newManager != null) {
                newManager.setLastMousePosition(oldManager.getLastMousePosition());
                this.modifiedSelection(this.selectedComponent);
                this.needsRepaint = true;
            }
        });
        this.buttonsToggleGroup = new ToggleGroup();
        HashMap buttonTabs = new HashMap();
        this.refreshComponentsTabs = () -> {
            this.buttonTabPane.getTabs().clear();
            buttonTabs.clear();
            this.componentManager.forEach(componentInfo -> {
                Tab tab;
                if (buttonTabs.containsKey(componentInfo.name.getKey())) {
                    tab = (Tab)buttonTabs.get(componentInfo.name.getKey());
                } else {
                    tab = new Tab((String)componentInfo.name.getKey());
                    tab.setClosable(false);
                    ScrollPane pane = new ScrollPane((Node)new GridPane());
                    pane.setFitToWidth(true);
                    tab.setContent((Node)pane);
                    this.buttonTabPane.getTabs().add((Object)tab);
                    buttonTabs.put(componentInfo.name.getKey(), tab);
                }
                GridPane buttons = (GridPane)((ScrollPane)tab.getContent()).getContent();
                ToggleButton toggleButton = this.setupButton(this.buttonsToggleGroup, (ComponentManager.ComponentLauncherInfo)componentInfo);
                buttons.addRow(buttons.getChildren().size(), new Node[]{toggleButton});
            });
            this.circuitButtonsTab = null;
            this.refreshCircuitsTab();
        };
        this.refreshComponentsTabs.run();
        this.editHistory.disable();
        this.createCircuit("New circuit");
        this.editHistory.enable();
        MenuItem newInstance = new MenuItem("New");
        newInstance.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        newInstance.setOnAction(event -> {
            this.saveConfFile();
            new CircuitSim(true);
        });
        MenuItem clear = new MenuItem("Clear");
        clear.setOnAction(event -> {
            if (!this.checkUnsavedChanges()) {
                this.clearCircuits();
                this.editHistory.disable();
                this.createCircuit("New circuit");
                this.editHistory.enable();
            }
        });
        MenuItem load = new MenuItem("Load");
        load.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        load.setOnAction(event -> {
            if (this.checkUnsavedChanges()) {
                return;
            }
            this.loadCircuitsInternal(null);
        });
        MenuItem save = new MenuItem("Save");
        save.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        save.setOnAction(event -> this.saveCircuitsInternal());
        MenuItem saveAs = new MenuItem("Save as");
        saveAs.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        saveAs.setOnAction(event -> {
            this.lastSaveFile = this.saveFile;
            this.saveFile = null;
            this.saveCircuitsInternal();
            if (this.saveFile == null) {
                this.saveFile = this.lastSaveFile;
            }
            this.updateTitle();
        });
        MenuItem exit = new MenuItem("Exit");
        exit.setOnAction(event -> {
            if (!this.checkUnsavedChanges()) {
                this.closeWindow();
            }
        });
        Menu fileMenu = new Menu("File");
        fileMenu.getItems().addAll((Object[])new MenuItem[]{newInstance, clear, new SeparatorMenuItem(), load, save, saveAs, new SeparatorMenuItem(), exit});
        this.undo = new MenuItem("Undo");
        this.undo.setDisable(true);
        this.undo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.undo.setOnAction(event -> {
            CircuitManager manager = this.getCurrentCircuit();
            if (manager != null) {
                manager.setSelectedElements(Collections.emptySet());
            }
            if ((manager = this.editHistory.undo()) != null) {
                manager.setSelectedElements(Collections.emptySet());
                this.switchToCircuit(manager.getCircuit(), null);
            }
        });
        this.editHistory.addListener((action, manager, params) -> this.undo.setDisable(this.editHistory.editStackSize() == 0));
        this.redo = new MenuItem("Redo");
        this.redo.setDisable(true);
        this.redo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.redo.setOnAction(event -> {
            CircuitManager manager = this.editHistory.redo();
            if (manager != null) {
                manager.getSelectedElements().clear();
                this.switchToCircuit(manager.getCircuit(), null);
            }
        });
        this.editHistory.addListener((action, manager, params) -> this.redo.setDisable(this.editHistory.redoStackSize() == 0));
        MenuItem copy = new MenuItem("Copy");
        copy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copy.setOnAction(event -> this.copySelectedComponents());
        MenuItem cut = new MenuItem("Cut");
        cut.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        cut.setOnAction(event -> this.cutSelectedComponents());
        MenuItem paste = new MenuItem("Paste");
        paste.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        paste.setOnAction(event -> this.pasteFromClipboard());
        MenuItem selectAll = new MenuItem("Select All");
        selectAll.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        selectAll.setOnAction(event -> {
            CircuitManager manager = this.getCurrentCircuit();
            if (manager != null) {
                manager.setSelectedElements(Stream.concat(manager.getCircuitBoard().getComponents().stream(), manager.getCircuitBoard().getLinks().stream().flatMap(link -> link.getWires().stream())).collect(Collectors.toSet()));
                this.needsRepaint = true;
            }
        });
        Menu editMenu = new Menu("Edit");
        editMenu.getItems().addAll((Object[])new MenuItem[]{this.undo, this.redo, new SeparatorMenuItem(), copy, cut, paste, new SeparatorMenuItem(), selectAll});
        MenuItem loadLibrary = new MenuItem("Load library");
        loadLibrary.setOnAction(event -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Choose library file");
            fileChooser.setInitialDirectory(new File(System.getProperty("user.dir")));
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Java Archive", new String[]{"*.jar"}));
            File file = fileChooser.showOpenDialog((Window)stage);
            if (file != null) {
                this.loadLibrary(file);
            }
        });
        Menu componentsMenu = new Menu("Components");
        componentsMenu.getItems().addAll((Object[])new MenuItem[]{loadLibrary});
        MenuItem newCircuit = new MenuItem("New circuit");
        newCircuit.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        newCircuit.setOnAction(event -> this.createCircuit("New circuit"));
        MenuItem deleteCircuit = new MenuItem("Delete circuit");
        deleteCircuit.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        deleteCircuit.setOnAction(event -> {
            CircuitManager currentCircuit = this.getCurrentCircuit();
            if (currentCircuit != null) {
                this.confirmAndDeleteCircuit(currentCircuit, true);
            }
        });
        Menu circuitsMenu = new Menu("Circuits");
        circuitsMenu.getItems().addAll((Object[])new MenuItem[]{newCircuit, deleteCircuit});
        MenuItem stepSimulation = new MenuItem("Step Simulation");
        stepSimulation.setDisable(true);
        stepSimulation.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        stepSimulation.setOnAction(event -> {
            try {
                this.simulator.step();
            }
            catch (Exception exc) {
                this.setLastException(exc);
            }
            finally {
                this.needsRepaint = true;
            }
        });
        this.simulationEnabled = new CheckMenuItem("Simulation Enabled");
        this.simulationEnabled.setSelected(true);
        this.simulationEnabled.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.E, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.simulationEnabled.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.runSim();
            stepSimulation.setDisable(newValue.booleanValue());
            this.clockEnabled.setDisable(newValue == false);
            this.clockEnabled.setSelected(false);
        });
        MenuItem reset = new MenuItem("Reset simulation");
        reset.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        reset.setOnAction(event -> {
            Clock.reset(this.simulator);
            this.clockEnabled.setSelected(false);
            this.simulator.reset();
            for (Pair<ComponentManager.ComponentLauncherInfo, CircuitManager> pair : this.circuitManagers.values()) {
                ((CircuitManager)pair.getValue()).getCircuitBoard().setCurrentState(((CircuitManager)pair.getValue()).getCircuit().getTopLevelState());
            }
            this.runSim();
        });
        MenuItem tickClock = new MenuItem("Tick clock");
        tickClock.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.J, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        tickClock.setOnAction(event -> Clock.tick(this.simulator));
        this.clockEnabled = new CheckMenuItem("Clock Enabled");
        this.clockEnabled.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.K, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        this.clockEnabled.selectedProperty().addListener((observable, oldValue, newValue) -> {
            tickClock.setDisable(newValue.booleanValue());
            if (newValue.booleanValue()) {
                Clock.startClock(this.simulator, this.getCurrentClockSpeed());
            } else {
                Clock.stopClock(this.simulator);
            }
        });
        this.frequenciesMenu = new Menu("Frequency");
        ToggleGroup freqToggleGroup = new ToggleGroup();
        int i2 = 0;
        while (i2 <= 14) {
            RadioMenuItem freq = new RadioMenuItem((1 << i2) + " Hz");
            freq.setToggleGroup(freqToggleGroup);
            freq.setSelected(i2 == 0);
            int j = i2++;
            freq.setOnAction(event -> {
                if (Clock.isRunning(this.simulator)) {
                    Clock.startClock(this.simulator, 1 << j);
                }
            });
            this.frequenciesMenu.getItems().add((Object)freq);
        }
        Menu simulationMenu = new Menu("Simulation");
        simulationMenu.getItems().addAll((Object[])new MenuItem[]{this.simulationEnabled, stepSimulation, reset, new SeparatorMenuItem(), this.clockEnabled, tickClock, this.frequenciesMenu});
        Menu helpMenu = new Menu("Help");
        this.help = new MenuItem("Help");
        this.help.setOnAction(event -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.initOwner((Window)stage);
            alert.initModality(Modality.NONE);
            alert.setTitle("Help");
            alert.setHeaderText("CircuitSim v1.8.1, created by Roi Atalla \u00a9 2018");
            String msg = "";
            msg = msg + "\u2022 Right clicking works! Try it on components, subcircuits, and circuit tabs.\n\n";
            msg = msg + "\u2022 Double clicking on a subcircuit will automatically go to its circuit tab as a child state.\n\n";
            msg = msg + "\u2022 Holding Shift will enable Click Mode which will click through to components.\n\n";
            msg = msg + "\u2022 Holding Shift after dragging a new wire will delete existing wires.\n\n";
            msg = msg + "\u2022 Holding Ctrl while dragging a new wire allows release of the mouse, and continuing the wire on click.\n\n";
            msg = msg + "\u2022 Holding Ctrl while selecting components and wires will include them in the selection group.\n\n";
            msg = msg + "\u2022 Holding Ctrl while dragging components will disable preserving connections.\n\n";
            msg = msg + "\u2022 [NEW] Holding Ctrl while placing a new component will keep the component selected.\n\n";
            alert.setContentText(msg);
            alert.show();
            alert.setResizable(true);
            alert.setWidth(600.0);
            alert.setHeight(440.0);
        });
        MenuItem checkUpdate = new MenuItem("Check for update");
        checkUpdate.setOnAction(event -> this.checkForUpdate(true));
        MenuItem about = new MenuItem("About");
        about.setOnAction(event -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.initOwner((Window)stage);
            alert.initModality(Modality.WINDOW_MODAL);
            alert.setTitle("About");
            alert.setHeaderText("CircuitSim v1.8.1, created by Roi Atalla \u00a9 2018");
            alert.setContentText("Third party tools:\n\u2022 GSON by Google");
            alert.show();
        });
        helpMenu.getItems().addAll((Object[])new MenuItem[]{this.help, checkUpdate, about});
        MenuBar menuBar = new MenuBar(new Menu[]{fileMenu, editMenu, componentsMenu, circuitsMenu, simulationMenu, helpMenu});
        menuBar.setUseSystemMenuBar(true);
        ScrollPane propertiesScrollPane = new ScrollPane((Node)this.propertiesTable);
        propertiesScrollPane.setFitToWidth(true);
        VBox propertiesBox = new VBox(new Node[]{this.componentLabel, propertiesScrollPane});
        propertiesBox.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)propertiesScrollPane, (Priority)Priority.ALWAYS);
        SplitPane leftPaneSplit = new SplitPane(new Node[]{this.buttonTabPane, propertiesBox});
        leftPaneSplit.setOrientation(Orientation.VERTICAL);
        leftPaneSplit.setPrefWidth(500.0);
        leftPaneSplit.setMinWidth(150.0);
        SplitPane.setResizableWithParent((Node)this.buttonTabPane, (Boolean)Boolean.FALSE);
        this.fpsLabel = new Label();
        this.fpsLabel.setMinWidth(100.0);
        this.fpsLabel.setFont(GuiUtils.getFont(13));
        this.fpsLabel.setAlignment(Pos.CENTER_LEFT);
        this.clockLabel = new Label();
        this.clockLabel.setMinWidth(100.0);
        this.clockLabel.setAlignment(Pos.CENTER_LEFT);
        this.clockLabel.setFont(GuiUtils.getFont(13));
        this.messageLabel = new Label();
        this.messageLabel.setTextFill((Paint)Color.RED);
        this.messageLabel.setFont(GuiUtils.getFont(20, true));
        Pane blank1 = new Pane();
        HBox.setHgrow((Node)blank1, (Priority)Priority.ALWAYS);
        Pane blank2 = new Pane();
        HBox.setHgrow((Node)blank2, (Priority)Priority.ALWAYS);
        HBox statusBar = new HBox(new Node[]{this.fpsLabel, this.clockLabel, blank1, this.messageLabel, blank2});
        VBox canvasTabBox = new VBox(new Node[]{this.canvasTabPane, statusBar});
        VBox.setVgrow((Node)this.canvasTabPane, (Priority)Priority.ALWAYS);
        SplitPane canvasPropsSplit = new SplitPane(new Node[]{leftPaneSplit, canvasTabBox});
        canvasPropsSplit.setOrientation(Orientation.HORIZONTAL);
        canvasPropsSplit.setDividerPositions(new double[]{0.35});
        SplitPane.setResizableWithParent((Node)leftPaneSplit, (Boolean)Boolean.FALSE);
        ToolBar toolBar = new ToolBar();
        Function<Pair, ToggleButton> createToolbarButton = pair -> {
            ComponentManager.ComponentLauncherInfo info = this.componentManager.get((Pair<String, String>)pair);
            ToggleButton button = new ToggleButton("", (Node)this.setupImageView(info.image));
            button.setTooltip(new Tooltip((String)pair.getValue()));
            button.setMinWidth(50.0);
            button.setMinHeight(50.0);
            button.setToggleGroup(this.buttonsToggleGroup);
            button.setOnAction(event -> {
                if (button.isSelected()) {
                    this.modifiedSelection(info);
                } else {
                    this.modifiedSelection(null);
                }
            });
            return button;
        };
        ToggleButton inputPinButton = createToolbarButton.apply(new Pair((Object)"Wiring", (Object)"Input Pin"));
        ToggleButton outputPinButton = createToolbarButton.apply(new Pair((Object)"Wiring", (Object)"Output Pin"));
        ToggleButton andButton = createToolbarButton.apply(new Pair((Object)"Gates", (Object)"AND"));
        ToggleButton orButton = createToolbarButton.apply(new Pair((Object)"Gates", (Object)"OR"));
        ToggleButton notButton = createToolbarButton.apply(new Pair((Object)"Gates", (Object)"NOT"));
        ToggleButton xorButton = createToolbarButton.apply(new Pair((Object)"Gates", (Object)"XOR"));
        ToggleButton tunnelButton = createToolbarButton.apply(new Pair((Object)"Wiring", (Object)"Tunnel"));
        ToggleButton textButton = createToolbarButton.apply(new Pair((Object)"Misc", (Object)"Text"));
        this.clickMode = new ToggleButton("Click Mode (Shift)");
        this.clickMode.setTooltip(new Tooltip("Clicking will sticky this mode"));
        this.clickMode.setOnAction(event -> {
            this.clickedDirectly = this.clickMode.isSelected();
        });
        this.clickMode.selectedProperty().addListener((observable, oldValue, newValue) -> this.scene.setCursor(newValue != false ? Cursor.HAND : Cursor.DEFAULT));
        Pane blank = new Pane();
        HBox.setHgrow((Node)blank, (Priority)Priority.ALWAYS);
        toolBar.getItems().addAll((Object[])new Node[]{this.clickMode, new Separator(Orientation.VERTICAL), inputPinButton, outputPinButton, andButton, orButton, notButton, xorButton, tunnelButton, textButton, new Separator(Orientation.VERTICAL), new Label("Global bit size:"), this.bitSizeSelect, blank, new Label("Scale:"), this.scaleFactorSelect});
        VBox.setVgrow((Node)canvasPropsSplit, (Priority)Priority.ALWAYS);
        this.scene = new Scene((Parent)new VBox(new Node[]{menuBar, toolBar, canvasPropsSplit}));
        this.scene.setCursor(Cursor.DEFAULT);
        this.updateTitle();
        stage.setScene(this.scene);
        stage.sizeToScene();
        stage.centerOnScreen();
        if (this.openWindow) {
            this.showWindow();
            this.loadConfFile();
            this.saveConfFile();
            Application.Parameters parameters = this.getParameters();
            if (parameters != null && !parameters.getRaw().isEmpty()) {
                List args = parameters.getRaw();
                this.loadCircuitsInternal(new File((String)args.get(0)));
                if (args.size() > 1) {
                    for (int i3 = 1; i3 < args.size(); ++i3) {
                        new CircuitSim(true).loadCircuitsInternal(new File((String)args.get(i3)));
                    }
                }
            }
            if (mainCalled && versionChecked.compareAndSet(false, true)) {
                this.checkForUpdate(false);
            }
        }
    }

    public void showWindow() {
        this.runFxSync(() -> {
            if (this.stage.isShowing()) {
                return;
            }
            this.stage.show();
            this.stage.setOnCloseRequest(event -> {
                if (this.checkUnsavedChanges()) {
                    event.consume();
                } else {
                    this.saveConfFile();
                }
            });
            this.currentTimer = new AnimationTimer(){
                private long lastRepaint;
                private int lastFrameCount;
                private int frameCount;

                public void handle(long now) {
                    if ((double)(now - this.lastRepaint) >= 1.0E9) {
                        this.lastFrameCount = this.frameCount;
                        this.frameCount = 0;
                        this.lastRepaint = now;
                        CircuitSim.this.fpsLabel.setText("FPS: " + this.lastFrameCount);
                        CircuitSim.this.clockLabel.setText(Clock.isRunning(CircuitSim.this.simulator) ? "Clock: " + (Clock.getLastTickCount(CircuitSim.this.simulator) >> 1) + " Hz" : "");
                    }
                    ++this.frameCount;
                    CircuitSim.this.runSim();
                    CircuitManager manager = CircuitSim.this.getCurrentCircuit();
                    if (manager != null) {
                        if (CircuitSim.this.needsRepaint || manager.needsRepaint()) {
                            CircuitSim.this.needsRepaint = false;
                            manager.paint();
                        }
                        if (!CircuitSim.this.loadingFile) {
                            String message = CircuitSim.this.getCurrentError();
                            if (!message.isEmpty() && Clock.isRunning(CircuitSim.this.simulator)) {
                                CircuitSim.this.clockEnabled.setSelected(false);
                            }
                            if (!CircuitSim.this.messageLabel.getText().equals(message)) {
                                CircuitSim.this.messageLabel.setText(message);
                            }
                        } else if (!CircuitSim.this.messageLabel.getText().isEmpty()) {
                            CircuitSim.this.messageLabel.setText("");
                        }
                    }
                }
            };
            this.currentTimer.start();
        });
    }

    public void closeWindow() {
        this.runFxSync(() -> {
            this.stage.close();
            if (this.currentTimer != null) {
                this.currentTimer.stop();
                this.currentTimer = null;
            }
        });
    }

    private class CircuitNode {
        private Subcircuit subcircuit;
        private CircuitState subcircuitState;
        private List<CircuitNode> children;

        CircuitNode(Subcircuit subcircuit, CircuitState subcircuitState) {
            this.subcircuit = subcircuit;
            this.subcircuitState = subcircuitState;
            this.children = new ArrayList<CircuitNode>();
        }
    }
}

