/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.CircuitBoard;
import com.ra4king.circuitsim.gui.CircuitSim;
import com.ra4king.circuitsim.gui.ComponentManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.GuiElement;
import com.ra4king.circuitsim.gui.GuiUtils;
import com.ra4king.circuitsim.gui.LinkWires;
import com.ra4king.circuitsim.gui.Properties;
import com.ra4king.circuitsim.gui.peers.SubcircuitPeer;
import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Port;
import com.ra4king.circuitsim.simulator.SimulationException;
import com.ra4king.circuitsim.simulator.Simulator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import javafx.util.Pair;

public class CircuitManager {
    private SelectingState currentState = SelectingState.IDLE;
    private final CircuitSim simulatorWindow;
    private final ScrollPane canvasScrollPane;
    private final CircuitBoard circuitBoard;
    private ContextMenu menu;
    private Point2D lastMousePosition = new Point2D(0.0, 0.0);
    private Point2D lastMousePressed = new Point2D(0.0, 0.0);
    private GuiElement lastPressed;
    private boolean lastPressedConsumed;
    private KeyCode lastPressedKeyCode;
    private LinkWires inspectLinkWires;
    private boolean isMouseInsideCanvas;
    private boolean isDraggedHorizontally;
    private boolean isCtrlDown;
    private boolean isShiftDown;
    private Circuit dummyCircuit = new Circuit("Dummy", new Simulator());
    private ComponentPeer<?> potentialComponent;
    private ComponentManager.ComponentCreator componentCreator;
    private Properties potentialComponentProperties;
    private Connection startConnection;
    private Connection endConnection;
    private Set<GuiElement> selectedElements = new HashSet<GuiElement>();
    private Exception lastException;
    private long lastExceptionTime;
    private static final long SHOW_ERROR_DURATION = 3000L;
    private boolean needsRepaint;
    private GuiElement lastEntered;

    CircuitManager(String name, CircuitSim simulatorWindow, ScrollPane canvasScrollPane, Simulator simulator) {
        this.simulatorWindow = simulatorWindow;
        this.canvasScrollPane = canvasScrollPane;
        this.circuitBoard = new CircuitBoard(name, this, simulator, simulatorWindow.getEditHistory());
        this.getCanvas().setOnContextMenuRequested(event -> {
            this.menu = new ContextMenu();
            MenuItem copy = new MenuItem("Copy");
            copy.setOnAction(event1 -> simulatorWindow.copySelectedComponents());
            MenuItem cut = new MenuItem("Cut");
            cut.setOnAction(event1 -> simulatorWindow.cutSelectedComponents());
            MenuItem paste = new MenuItem("Paste");
            paste.setOnAction(event1 -> simulatorWindow.pasteFromClipboard());
            MenuItem delete = new MenuItem("Delete");
            delete.setOnAction(event1 -> {
                this.mayThrow(() -> this.circuitBoard.removeElements(this.selectedElements));
                this.setSelectedElements(Collections.emptySet());
                this.reset();
            });
            Optional<ComponentPeer> any = this.circuitBoard.getComponents().stream().filter(component -> component.containsScreenCoord((int)Math.round(event.getX() * simulatorWindow.getScaleFactorInverted()), (int)Math.round(event.getY() * simulatorWindow.getScaleFactorInverted()))).findAny();
            if (any.isPresent()) {
                if (this.isCtrlDown) {
                    HashSet<GuiElement> selected = new HashSet<GuiElement>(this.getSelectedElements());
                    selected.add(any.get());
                    this.setSelectedElements(selected);
                } else if (!this.getSelectedElements().contains(any.get())) {
                    this.setSelectedElements(Collections.singleton(any.get()));
                }
            }
            if (this.getSelectedElements().size() > 0) {
                this.menu.getItems().addAll((Object[])new MenuItem[]{copy, cut, paste, delete});
            } else {
                this.menu.getItems().add((Object)paste);
            }
            if (this.getSelectedElements().size() == 1) {
                this.menu.getItems().addAll(this.getSelectedElements().iterator().next().getContextMenuItems(this));
            }
            if (this.menu.getItems().size() > 0) {
                this.menu.show((Node)this.getCanvas(), event.getScreenX(), event.getScreenY());
            }
        });
    }

    public void setName(String name) {
        this.circuitBoard.setName(name);
    }

    public String getName() {
        return this.circuitBoard.getName();
    }

    public String toString() {
        return "CircuitManager of " + this.getName();
    }

    private void resetLastPressed() {
        if (this.lastPressed != null && this.lastPressedKeyCode == null) {
            this.lastPressed.mouseReleased(this, this.circuitBoard.getCurrentState(), this.lastMousePosition.getX() - (double)this.lastPressed.getScreenX(), this.lastMousePosition.getY() - (double)this.lastPressed.getScreenY());
        } else if (this.lastPressed != null) {
            this.lastPressed.keyReleased(this, this.circuitBoard.getCurrentState(), this.lastPressedKeyCode, this.lastPressedKeyCode.getName());
        }
        this.lastPressed = null;
        this.lastPressedKeyCode = null;
    }

    private void reset() {
        this.resetLastPressed();
        this.currentState = SelectingState.IDLE;
        this.setSelectedElements(Collections.emptySet());
        this.simulatorWindow.clearSelection();
        this.mayThrow(this.dummyCircuit::clearComponents);
        this.potentialComponent = null;
        this.isDraggedHorizontally = false;
        this.startConnection = null;
        this.endConnection = null;
        this.inspectLinkWires = null;
        this.simulatorWindow.updateCanvasSize(this);
        this.setNeedsRepaint();
    }

    public void destroy() {
        this.circuitBoard.destroy();
    }

    public CircuitSim getSimulatorWindow() {
        return this.simulatorWindow;
    }

    public ScrollPane getCanvasScrollPane() {
        return this.canvasScrollPane;
    }

    public Canvas getCanvas() {
        return (Canvas)this.canvasScrollPane.getContent();
    }

    public Circuit getCircuit() {
        return this.circuitBoard.getCircuit();
    }

    public CircuitBoard getCircuitBoard() {
        return this.circuitBoard;
    }

    Exception getCurrentError() {
        if (this.lastException != null && 3000L < System.currentTimeMillis() - this.lastExceptionTime) {
            this.lastException = null;
        }
        return this.lastException == null ? this.circuitBoard.getLastException() : this.lastException;
    }

    public Point2D getLastMousePosition() {
        return this.lastMousePosition;
    }

    public void setLastMousePosition(Point2D lastMousePosition) {
        this.lastMousePosition = lastMousePosition;
    }

    public Set<GuiElement> getSelectedElements() {
        return this.selectedElements;
    }

    public void setSelectedElements(Set<GuiElement> elements) {
        this.mayThrow(this.circuitBoard::finalizeMove);
        this.selectedElements.clear();
        this.selectedElements.addAll(elements);
        this.updateSelectedProperties();
    }

    boolean needsRepaint() {
        return this.needsRepaint;
    }

    void setNeedsRepaint() {
        this.needsRepaint = true;
    }

    private Properties getCommonSelectedProperties() {
        return this.selectedElements.stream().filter(element -> element instanceof ComponentPeer).map(element -> ((ComponentPeer)element).getProperties()).reduce(Properties::intersect).orElse(new Properties());
    }

    private void updateSelectedProperties() {
        long componentCount = this.selectedElements.stream().filter(element -> element instanceof ComponentPeer).count();
        if (componentCount == 1L) {
            Optional<ComponentPeer> peer = this.selectedElements.stream().filter(element -> element instanceof ComponentPeer).map(element -> (ComponentPeer)element).findAny();
            peer.ifPresent(this.simulatorWindow::setProperties);
        } else if (componentCount > 1L) {
            this.simulatorWindow.setProperties("Multiple selections", this.getCommonSelectedProperties());
        } else {
            this.simulatorWindow.clearProperties();
        }
    }

    public void modifiedSelection(ComponentManager.ComponentCreator componentCreator, Properties properties) {
        this.componentCreator = componentCreator;
        this.potentialComponentProperties = properties;
        this.mayThrow(this.circuitBoard::finalizeMove);
        this.mayThrow(this.dummyCircuit::clearComponents);
        if (this.currentState != SelectingState.IDLE && this.currentState != SelectingState.PLACING_COMPONENT && this.currentState != SelectingState.ELEMENT_SELECTED && this.currentState != SelectingState.ELEMENT_DRAGGED) {
            this.reset();
        }
        if (componentCreator != null) {
            this.setSelectedElements(Collections.emptySet());
            this.currentState = SelectingState.PLACING_COMPONENT;
            this.potentialComponent = componentCreator.createComponent(properties, GuiUtils.getCircuitCoord(this.lastMousePosition.getX()), GuiUtils.getCircuitCoord(this.lastMousePosition.getY()));
            this.mayThrow(() -> this.dummyCircuit.addComponent(this.potentialComponent.getComponent()));
            this.potentialComponent.setX(this.potentialComponent.getX() - this.potentialComponent.getWidth() / 2);
            this.potentialComponent.setY(this.potentialComponent.getY() - this.potentialComponent.getHeight() / 2);
            this.simulatorWindow.setProperties(this.potentialComponent);
            return;
        }
        if (properties != null && !properties.isEmpty() && !this.selectedElements.isEmpty()) {
            Map<ComponentPeer, ComponentPeer> newComponents = this.selectedElements.stream().filter(element -> element instanceof ComponentPeer).map(element -> (ComponentPeer)element).collect(Collectors.toMap(component -> component, component -> ComponentManager.forClass(component.getClass()).createComponent(new Properties(component.getProperties()).mergeIfExists(properties), component.getX(), component.getY())));
            this.simulatorWindow.getEditHistory().beginGroup();
            this.simulatorWindow.getSimulator().runSync(() -> newComponents.forEach((oldComponent, newComponent) -> this.mayThrow(() -> this.circuitBoard.updateComponent((ComponentPeer<?>)oldComponent, (ComponentPeer<?>)newComponent))));
            this.simulatorWindow.getEditHistory().endGroup();
            this.setSelectedElements(Stream.concat(this.selectedElements.stream().filter(element -> !(element instanceof ComponentPeer)), newComponents.values().stream()).collect(Collectors.toSet()));
            return;
        }
        this.currentState = SelectingState.IDLE;
        this.setSelectedElements(Collections.emptySet());
        this.potentialComponent = null;
        this.isDraggedHorizontally = false;
        this.startConnection = null;
        this.endConnection = null;
        this.setNeedsRepaint();
    }

    public void paint() {
        this.needsRepaint = false;
        GraphicsContext graphics = this.getCanvas().getGraphicsContext2D();
        graphics.save();
        graphics.setFont(GuiUtils.getFont(13));
        graphics.setFontSmoothingType(FontSmoothingType.LCD);
        graphics.setFill((Paint)Color.LIGHTGRAY);
        graphics.fillRect(0.0, 0.0, this.getCanvas().getWidth(), this.getCanvas().getHeight());
        graphics.scale(this.simulatorWindow.getScaleFactor(), this.simulatorWindow.getScaleFactor());
        graphics.setFill((Paint)Color.BLACK);
        double scaleInverted = this.simulatorWindow.getScaleFactorInverted();
        int i = 0;
        while ((double)i < this.getCanvas().getWidth() * scaleInverted) {
            int n = 0;
            while ((double)n < this.getCanvas().getHeight() * scaleInverted) {
                graphics.fillRect((double)i, (double)n, 1.0, 1.0);
                n += 10;
            }
            i += 10;
        }
        try {
            this.circuitBoard.paint(graphics, this.inspectLinkWires);
        }
        catch (Exception exc) {
            this.getSimulatorWindow().getDebugUtil().logException(exc);
        }
        for (GuiElement guiElement : this.selectedElements) {
            graphics.setStroke((Paint)Color.ORANGERED);
            if (guiElement instanceof LinkWires.Wire) {
                double xOff = ((LinkWires.Wire)guiElement).isHorizontal() ? 0.0 : 1.0;
                double yOff = ((LinkWires.Wire)guiElement).isHorizontal() ? 1.0 : 0.0;
                graphics.strokeRect((double)guiElement.getScreenX() - xOff, (double)guiElement.getScreenY() - yOff, (double)guiElement.getScreenWidth() + xOff * 2.0, (double)guiElement.getScreenHeight() + yOff * 2.0);
                continue;
            }
            GuiUtils.drawShape((arg_0, arg_1, arg_2, arg_3) -> ((GraphicsContext)graphics).strokeRect(arg_0, arg_1, arg_2, arg_3), guiElement);
        }
        if (!this.simulatorWindow.isSimulationEnabled()) {
            graphics.save();
            graphics.setStroke((Paint)Color.RED);
            this.simulatorWindow.getSimulator().runSync(() -> {
                for (Pair<CircuitState, Port.Link> linkToUpdate : this.simulatorWindow.getSimulator().getLinksToUpdate()) {
                    for (Port port : ((Port.Link)linkToUpdate.getValue()).getParticipants()) {
                        Optional<Connection.PortConnection> connection = this.circuitBoard.getComponents().stream().flatMap(c -> c.getConnections().stream()).filter(p -> p.getPort() == port).findFirst();
                        if (!connection.isPresent()) continue;
                        Connection.PortConnection portConn = connection.get();
                        graphics.strokeOval((double)(portConn.getScreenX() - 2), (double)(portConn.getScreenY() - 2), 10.0, 10.0);
                    }
                }
            });
            graphics.restore();
        }
        if (this.inspectLinkWires != null && this.inspectLinkWires.getLink() != null && this.inspectLinkWires.isLinkValid()) {
            String value;
            try {
                value = this.circuitBoard.getCurrentState().getMergedValue(this.inspectLinkWires.getLink()).toString();
            }
            catch (Exception exception) {
                value = "Error";
            }
            Text text = new Text(value);
            text.setFont(graphics.getFont());
            Bounds bounds = text.getLayoutBounds();
            double x = this.lastMousePressed.getX() - bounds.getWidth() / 2.0 - 3.0;
            double y = this.lastMousePressed.getY() + 30.0;
            double width = bounds.getWidth() + 6.0;
            double height = bounds.getHeight() + 3.0;
            graphics.setLineWidth(1.0);
            graphics.setStroke((Paint)Color.BLACK);
            graphics.setFill((Paint)Color.ORANGE.brighter());
            graphics.fillRect(x, y, width, height);
            graphics.strokeRect(x, y, width, height);
            graphics.setFill((Paint)Color.BLACK);
            graphics.fillText(value, x + 3.0, y + height - 5.0);
        }
        switch (this.currentState) {
            case IDLE: 
            case CONNECTION_SELECTED: {
                Connection.PortConnection portConnection;
                String string;
                if (this.startConnection == null) break;
                graphics.save();
                graphics.setLineWidth(2.0);
                graphics.setStroke((Paint)Color.GREEN);
                graphics.strokeOval((double)(this.startConnection.getScreenX() - 2), (double)(this.startConnection.getScreenY() - 2), 10.0, 10.0);
                if (this.endConnection != null) {
                    graphics.strokeOval((double)(this.endConnection.getScreenX() - 2), (double)(this.endConnection.getScreenY() - 2), 10.0, 10.0);
                }
                if (this.startConnection instanceof Connection.PortConnection && !(string = (portConnection = (Connection.PortConnection)this.startConnection).getName()).isEmpty()) {
                    Text text = new Text(string);
                    text.setFont(graphics.getFont());
                    Bounds bounds = text.getLayoutBounds();
                    double x = (double)this.startConnection.getScreenX() - bounds.getWidth() / 2.0 - 3.0;
                    double y = this.startConnection.getScreenY() + 30;
                    double width = bounds.getWidth() + 6.0;
                    double height = bounds.getHeight() + 3.0;
                    graphics.setLineWidth(1.0);
                    graphics.setStroke((Paint)Color.BLACK);
                    graphics.setFill((Paint)Color.ORANGE.brighter());
                    graphics.fillRect(x, y, width, height);
                    graphics.strokeRect(x, y, width, height);
                    graphics.setFill((Paint)Color.BLACK);
                    graphics.fillText(string, x + 3.0, y + height - 5.0);
                }
                graphics.restore();
                break;
            }
            case CONNECTION_DRAGGED: {
                graphics.save();
                graphics.setLineWidth(2.0);
                graphics.setStroke((Paint)Color.GREEN);
                graphics.strokeOval((double)(this.startConnection.getScreenX() - 2), (double)(this.startConnection.getScreenY() - 2), 10.0, 10.0);
                if (this.endConnection != null) {
                    graphics.strokeOval((double)(this.endConnection.getScreenX() - 2), (double)(this.endConnection.getScreenY() - 2), 10.0, 10.0);
                }
                int startX = this.startConnection.getScreenX() + this.startConnection.getScreenWidth() / 2;
                int n = this.startConnection.getScreenY() + this.startConnection.getScreenHeight() / 2;
                int pointX = GuiUtils.getScreenCircuitCoord(this.lastMousePosition.getX());
                int pointY = GuiUtils.getScreenCircuitCoord(this.lastMousePosition.getY());
                graphics.setStroke((Paint)(this.isShiftDown ? Color.RED : Color.BLACK));
                if (this.isDraggedHorizontally) {
                    graphics.strokeLine((double)startX, (double)n, (double)pointX, (double)n);
                    graphics.strokeLine((double)pointX, (double)n, (double)pointX, (double)pointY);
                } else {
                    graphics.strokeLine((double)startX, (double)n, (double)startX, (double)pointY);
                    graphics.strokeLine((double)startX, (double)pointY, (double)pointX, (double)pointY);
                }
                graphics.restore();
                break;
            }
            case PLACING_COMPONENT: {
                if (this.potentialComponent == null || !this.isMouseInsideCanvas) break;
                graphics.save();
                this.potentialComponent.paint(graphics, this.dummyCircuit.getTopLevelState());
                graphics.restore();
                for (Connection connection : this.potentialComponent.getConnections()) {
                    graphics.save();
                    connection.paint(graphics, this.dummyCircuit.getTopLevelState());
                    graphics.restore();
                }
                break;
            }
            case HIGHLIGHT_DRAGGED: {
                double startX = this.lastMousePressed.getX() < this.lastMousePosition.getX() ? this.lastMousePressed.getX() : this.lastMousePosition.getX();
                double startY = this.lastMousePressed.getY() < this.lastMousePosition.getY() ? this.lastMousePressed.getY() : this.lastMousePosition.getY();
                double width = Math.abs(this.lastMousePosition.getX() - this.lastMousePressed.getX());
                double height = Math.abs(this.lastMousePosition.getY() - this.lastMousePressed.getY());
                graphics.setStroke((Paint)Color.GREEN.darker());
                graphics.strokeRect(startX, startY, width, height);
                break;
            }
        }
        graphics.restore();
    }

    boolean mayThrow(ThrowableRunnable runnable) {
        try {
            runnable.run();
            if (this.lastException != null && 3000L < System.currentTimeMillis() - this.lastExceptionTime) {
                this.lastException = null;
            }
            return false;
        }
        catch (SimulationException exc) {
            this.lastException = exc;
            this.lastExceptionTime = System.currentTimeMillis();
            return true;
        }
        catch (Exception exc) {
            this.getSimulatorWindow().getDebugUtil().logException(exc);
            this.lastException = exc;
            this.lastExceptionTime = System.currentTimeMillis();
            return true;
        }
    }

    private void handleArrowPressed(Properties.Direction direction) {
        if (this.currentState == SelectingState.PLACING_COMPONENT || !this.getSelectedElements().isEmpty()) {
            Properties props = new Properties(this.currentState == SelectingState.PLACING_COMPONENT ? this.potentialComponentProperties : this.getCommonSelectedProperties());
            props.setValue(Properties.DIRECTION, direction);
            this.modifiedSelection(this.componentCreator, props);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getCode() != KeyCode.SHIFT && this.lastPressed == null && this.selectedElements.size() == 1) {
            this.lastPressed = this.selectedElements.iterator().next();
            this.lastPressedConsumed = this.lastPressed.keyPressed(this, this.circuitBoard.getCurrentState(), e.getCode(), e.getText());
            this.lastPressedKeyCode = e.getCode();
            this.setNeedsRepaint();
        }
        if (this.lastPressed != null && this.lastPressedConsumed) {
            return;
        }
        this.setNeedsRepaint();
        switch (e.getCode()) {
            case RIGHT: {
                e.consume();
                this.handleArrowPressed(Properties.Direction.EAST);
                break;
            }
            case LEFT: {
                e.consume();
                this.handleArrowPressed(Properties.Direction.WEST);
                break;
            }
            case UP: {
                e.consume();
                this.handleArrowPressed(Properties.Direction.NORTH);
                break;
            }
            case DOWN: {
                e.consume();
                this.handleArrowPressed(Properties.Direction.SOUTH);
                break;
            }
            case CONTROL: {
                this.isCtrlDown = true;
                break;
            }
            case SHIFT: {
                if (this.currentState != SelectingState.CONNECTION_SELECTED && this.currentState != SelectingState.CONNECTION_DRAGGED) {
                    this.simulatorWindow.setClickMode(true);
                }
                this.isShiftDown = true;
                break;
            }
            case DELETE: 
            case BACK_SPACE: {
                if (this.getSelectedElements().isEmpty()) break;
                this.mayThrow(this.circuitBoard::finalizeMove);
                this.mayThrow(() -> this.circuitBoard.removeElements(this.selectedElements));
                this.reset();
                break;
            }
            case ESCAPE: {
                if (this.currentState == SelectingState.ELEMENT_DRAGGED) {
                    this.mayThrow(() -> this.circuitBoard.moveElements(0, 0, false));
                }
                this.reset();
            }
        }
    }

    public void keyTyped(KeyEvent e) {
        if (this.selectedElements.size() == 1) {
            GuiElement element = this.selectedElements.iterator().next();
            element.keyTyped(this, this.circuitBoard.getCurrentState(), e.getCharacter());
            this.setNeedsRepaint();
        }
    }

    public void keyReleased(KeyEvent e) {
        switch (e.getCode()) {
            case CONTROL: {
                this.isCtrlDown = false;
                this.setNeedsRepaint();
                break;
            }
            case SHIFT: {
                this.simulatorWindow.setClickMode(false);
                this.isShiftDown = false;
                this.setNeedsRepaint();
            }
        }
        if (this.lastPressed != null && this.lastPressedKeyCode == e.getCode()) {
            this.lastPressed.keyReleased(this, this.circuitBoard.getCurrentState(), e.getCode(), e.getText());
            this.lastPressed = null;
            this.lastPressedKeyCode = null;
            this.setNeedsRepaint();
        }
    }

    private void addCurrentWire() {
        int endMidX = this.endConnection == null ? GuiUtils.getCircuitCoord(this.lastMousePosition.getX()) : this.endConnection.getX();
        int endMidY = this.endConnection == null ? GuiUtils.getCircuitCoord(this.lastMousePosition.getY()) : this.endConnection.getY();
        HashSet<LinkWires.Wire> wires = new HashSet<LinkWires.Wire>();
        if (endMidX - this.startConnection.getX() != 0 && endMidY - this.startConnection.getY() != 0) {
            this.simulatorWindow.getEditHistory().beginGroup();
            if (this.isDraggedHorizontally) {
                wires.add(new LinkWires.Wire(null, this.startConnection.getX(), this.startConnection.getY(), endMidX - this.startConnection.getX(), true));
                wires.add(new LinkWires.Wire(null, endMidX, this.startConnection.getY(), endMidY - this.startConnection.getY(), false));
            } else {
                wires.add(new LinkWires.Wire(null, this.startConnection.getX(), this.startConnection.getY(), endMidY - this.startConnection.getY(), false));
                wires.add(new LinkWires.Wire(null, this.startConnection.getX(), endMidY, endMidX - this.startConnection.getX(), true));
            }
            this.simulatorWindow.getEditHistory().endGroup();
        } else if (endMidX - this.startConnection.getX() != 0) {
            wires.add(new LinkWires.Wire(null, this.startConnection.getX(), this.startConnection.getY(), endMidX - this.startConnection.getX(), true));
        } else if (endMidY - this.startConnection.getY() != 0) {
            wires.add(new LinkWires.Wire(null, endMidX, this.startConnection.getY(), endMidY - this.startConnection.getY(), false));
        } else {
            Set<Connection> connections = this.circuitBoard.getConnections(this.startConnection.getX(), this.startConnection.getY());
            this.setSelectedElements(Stream.concat(this.isCtrlDown ? this.getSelectedElements().stream() : Stream.empty(), connections.stream().map(Connection::getParent)).collect(Collectors.toSet()));
        }
        if (this.isShiftDown) {
            this.mayThrow(() -> this.circuitBoard.removeElements(wires));
        } else {
            this.simulatorWindow.getEditHistory().beginGroup();
            for (LinkWires.Wire w : wires) {
                this.mayThrow(() -> this.circuitBoard.addWire(w.getX(), w.getY(), w.getLength(), w.isHorizontal()));
            }
            this.simulatorWindow.getEditHistory().endGroup();
        }
    }

    private void checkStartConnection() {
        if (this.currentState != SelectingState.CONNECTION_DRAGGED) {
            Set<Connection> selectedConns = this.circuitBoard.getConnections(GuiUtils.getCircuitCoord(this.lastMousePosition.getX()), GuiUtils.getCircuitCoord(this.lastMousePosition.getY()));
            Connection selected = null;
            for (Connection connection : selectedConns) {
                if (!(connection instanceof Connection.PortConnection)) continue;
                selected = connection;
                break;
            }
            if (selected == null && !selectedConns.isEmpty()) {
                selected = selectedConns.iterator().next();
            }
            if (this.startConnection != selected) {
                this.setNeedsRepaint();
            }
            this.startConnection = selected;
        }
    }

    private void checkEndConnection(Point2D prevMousePosition) {
        if (this.currentState == SelectingState.CONNECTION_DRAGGED) {
            Connection connection;
            int currDiffX = GuiUtils.getCircuitCoord(this.lastMousePosition.getX()) - this.startConnection.getX();
            int prevDiffX = GuiUtils.getCircuitCoord(prevMousePosition.getX()) - this.startConnection.getX();
            int currDiffY = GuiUtils.getCircuitCoord(this.lastMousePosition.getY()) - this.startConnection.getY();
            int prevDiffY = GuiUtils.getCircuitCoord(prevMousePosition.getY()) - this.startConnection.getY();
            if (currDiffX == 0 || prevDiffX == 0 || currDiffX / Math.abs(currDiffX) != prevDiffX / Math.abs(prevDiffX)) {
                if (this.isDraggedHorizontally) {
                    this.setNeedsRepaint();
                }
                this.isDraggedHorizontally = false;
            }
            if (currDiffY == 0 || prevDiffY == 0 || currDiffY / Math.abs(currDiffY) != prevDiffY / Math.abs(prevDiffY)) {
                if (!this.isDraggedHorizontally) {
                    this.setNeedsRepaint();
                }
                this.isDraggedHorizontally = true;
            }
            if (this.endConnection != (connection = this.circuitBoard.findConnection(GuiUtils.getCircuitCoord(this.lastMousePosition.getX()), GuiUtils.getCircuitCoord(this.lastMousePosition.getY())))) {
                this.setNeedsRepaint();
            }
            this.endConnection = connection;
        }
    }

    private void updatePotentialComponent() {
        if (this.potentialComponent != null) {
            this.potentialComponent.setX(GuiUtils.getCircuitCoord(this.lastMousePosition.getX()) - this.potentialComponent.getWidth() / 2);
            this.potentialComponent.setY(GuiUtils.getCircuitCoord(this.lastMousePosition.getY()) - this.potentialComponent.getHeight() / 2);
            this.setNeedsRepaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.menu != null) {
            this.menu.hide();
        }
        if (e.getButton() != MouseButton.PRIMARY) {
            switch (this.currentState) {
                case CONNECTION_SELECTED: 
                case CONNECTION_DRAGGED: 
                case PLACING_COMPONENT: {
                    this.reset();
                }
            }
            return;
        }
        this.lastMousePosition = new Point2D(e.getX() * this.simulatorWindow.getScaleFactorInverted(), e.getY() * this.simulatorWindow.getScaleFactorInverted());
        this.lastMousePressed = new Point2D(e.getX() * this.simulatorWindow.getScaleFactorInverted(), e.getY() * this.simulatorWindow.getScaleFactorInverted());
        switch (this.currentState) {
            case CONNECTION_SELECTED: 
            case HIGHLIGHT_DRAGGED: 
            case ELEMENT_DRAGGED: {
                break;
            }
            case IDLE: 
            case ELEMENT_SELECTED: {
                this.inspectLinkWires = null;
                if (this.startConnection != null) {
                    if (this.simulatorWindow.isClickMode()) {
                        this.inspectLinkWires = this.startConnection.getLinkWires();
                        this.currentState = SelectingState.IDLE;
                        break;
                    }
                    if (this.isCtrlDown && this.getSelectedElements().isEmpty()) {
                        this.currentState = SelectingState.CONNECTION_DRAGGED;
                        break;
                    }
                    this.currentState = SelectingState.CONNECTION_SELECTED;
                    break;
                }
                Optional<GuiElement> clickedComponent = Stream.concat(this.getSelectedElements().stream(), this.circuitBoard.getComponents().stream()).filter(peer -> peer.containsScreenCoord((int)this.lastMousePressed.getX(), (int)this.lastMousePressed.getY())).findFirst();
                if (clickedComponent.isPresent()) {
                    GuiElement selectedElement = clickedComponent.get();
                    if (e.getClickCount() == 2 && selectedElement instanceof SubcircuitPeer) {
                        this.reset();
                        ((SubcircuitPeer)selectedElement).switchToSubcircuit(this);
                    } else if (this.simulatorWindow.isClickMode() && this.lastPressed == null) {
                        this.lastPressed = selectedElement;
                        selectedElement.mousePressed(this, this.circuitBoard.getCurrentState(), this.lastMousePosition.getX() - (double)selectedElement.getScreenX(), this.lastMousePosition.getY() - (double)selectedElement.getScreenY());
                    } else if (this.isCtrlDown) {
                        HashSet<GuiElement> elements = new HashSet<GuiElement>(this.getSelectedElements());
                        elements.add(selectedElement);
                        this.setSelectedElements(elements);
                    } else if (!this.getSelectedElements().contains(selectedElement)) {
                        this.setSelectedElements(Collections.singleton(selectedElement));
                    }
                    if (this.currentState != SelectingState.IDLE) break;
                    this.currentState = SelectingState.ELEMENT_SELECTED;
                    break;
                }
                if (this.isCtrlDown) break;
                this.reset();
                break;
            }
            case CONNECTION_DRAGGED: {
                this.addCurrentWire();
                if (this.isCtrlDown) {
                    Set<Connection> selectedConns = this.circuitBoard.getConnections(GuiUtils.getCircuitCoord(this.lastMousePressed.getX()), GuiUtils.getCircuitCoord(this.lastMousePressed.getY()));
                    if (selectedConns.isEmpty()) break;
                    this.startConnection = selectedConns.iterator().next();
                    break;
                }
                this.currentState = SelectingState.IDLE;
                this.startConnection = null;
                this.endConnection = null;
                break;
            }
            case PLACING_COMPONENT: {
                Object newComponent = this.componentCreator.createComponent(this.potentialComponentProperties, this.potentialComponent.getX(), this.potentialComponent.getY());
                this.mayThrow(() -> this.circuitBoard.addComponent((ComponentPeer<?>)newComponent));
                if (this.isCtrlDown) break;
                this.reset();
                if (this.circuitBoard.getComponents().contains(newComponent)) {
                    this.setSelectedElements(Collections.singleton(newComponent));
                }
                this.currentState = SelectingState.ELEMENT_SELECTED;
            }
        }
        this.setNeedsRepaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != MouseButton.PRIMARY) {
            return;
        }
        this.lastMousePosition = new Point2D(e.getX() * this.simulatorWindow.getScaleFactorInverted(), e.getY() * this.simulatorWindow.getScaleFactorInverted());
        switch (this.currentState) {
            case IDLE: 
            case ELEMENT_DRAGGED: 
            case ELEMENT_SELECTED: {
                this.resetLastPressed();
                this.mayThrow(() -> {
                    Set<GuiElement> newElements = this.circuitBoard.finalizeMove();
                    if (newElements != null) {
                        this.setSelectedElements(newElements);
                    }
                });
                this.currentState = SelectingState.IDLE;
                break;
            }
            case CONNECTION_SELECTED: {
                Set<Connection> connections = this.circuitBoard.getConnections(this.startConnection.getX(), this.startConnection.getY());
                this.setSelectedElements(Stream.concat(this.isCtrlDown ? this.getSelectedElements().stream() : Stream.empty(), connections.stream().map(Connection::getParent)).collect(Collectors.toSet()));
                this.currentState = SelectingState.IDLE;
                break;
            }
            case CONNECTION_DRAGGED: {
                if (this.getSelectedElements().isEmpty() && this.isCtrlDown) break;
                this.addCurrentWire();
                this.currentState = SelectingState.IDLE;
                this.startConnection = null;
                this.endConnection = null;
                break;
            }
            case PLACING_COMPONENT: {
                if (this.isCtrlDown) break;
            }
            case HIGHLIGHT_DRAGGED: {
                this.currentState = SelectingState.IDLE;
            }
        }
        this.checkStartConnection();
        this.setNeedsRepaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getButton() != MouseButton.PRIMARY) {
            return;
        }
        Point2D prevMousePosition = this.lastMousePosition;
        this.lastMousePosition = new Point2D(e.getX() * this.simulatorWindow.getScaleFactorInverted(), e.getY() * this.simulatorWindow.getScaleFactorInverted());
        switch (this.currentState) {
            case IDLE: 
            case HIGHLIGHT_DRAGGED: {
                this.currentState = SelectingState.HIGHLIGHT_DRAGGED;
                int startX = (int)(this.lastMousePressed.getX() < this.lastMousePosition.getX() ? this.lastMousePressed.getX() : this.lastMousePosition.getX());
                int startY = (int)(this.lastMousePressed.getY() < this.lastMousePosition.getY() ? this.lastMousePressed.getY() : this.lastMousePosition.getY());
                int width = (int)Math.abs(this.lastMousePosition.getX() - this.lastMousePressed.getX());
                int height = (int)Math.abs(this.lastMousePosition.getY() - this.lastMousePressed.getY());
                if (!this.isCtrlDown) {
                    this.selectedElements.clear();
                }
                this.setSelectedElements(Stream.concat(this.getSelectedElements().stream(), Stream.concat(this.circuitBoard.getComponents().stream(), this.circuitBoard.getLinks().stream().flatMap(link -> link.getWires().stream())).filter(peer -> peer.isWithinScreenCoord(startX, startY, width, height))).collect(Collectors.toSet()));
                break;
            }
            case ELEMENT_SELECTED: {
                if (this.simulatorWindow.isClickMode()) break;
            }
            case PLACING_COMPONENT: {
                if (this.isCtrlDown) {
                    this.updatePotentialComponent();
                    break;
                }
            }
            case ELEMENT_DRAGGED: {
                int dx = GuiUtils.getCircuitCoord(this.lastMousePosition.getX() - this.lastMousePressed.getX());
                int dy = GuiUtils.getCircuitCoord(this.lastMousePosition.getY() - this.lastMousePressed.getY());
                if (dx == 0 && dy == 0 && this.currentState != SelectingState.ELEMENT_DRAGGED) break;
                this.currentState = SelectingState.ELEMENT_DRAGGED;
                if (!this.circuitBoard.isMoving()) {
                    this.mayThrow(() -> this.circuitBoard.initMove(this.getSelectedElements()));
                }
                this.mayThrow(() -> this.circuitBoard.moveElements(dx, dy, !this.isCtrlDown));
                break;
            }
            case CONNECTION_SELECTED: 
            case CONNECTION_DRAGGED: {
                this.currentState = SelectingState.CONNECTION_DRAGGED;
                this.checkEndConnection(prevMousePosition);
            }
        }
        this.checkStartConnection();
        this.setNeedsRepaint();
    }

    public void mouseMoved(MouseEvent e) {
        Point2D prevMousePosition = this.lastMousePosition;
        this.lastMousePosition = new Point2D(e.getX() * this.simulatorWindow.getScaleFactorInverted(), e.getY() * this.simulatorWindow.getScaleFactorInverted());
        if (this.currentState != SelectingState.IDLE) {
            this.setNeedsRepaint();
        }
        this.updatePotentialComponent();
        this.checkStartConnection();
        this.checkEndConnection(prevMousePosition);
        if (this.startConnection == null && (this.currentState == SelectingState.IDLE || this.currentState == SelectingState.ELEMENT_SELECTED)) {
            Optional<ComponentPeer> component = this.circuitBoard.getComponents().stream().filter(c -> c.containsScreenCoord((int)this.lastMousePosition.getX(), (int)this.lastMousePosition.getY())).findFirst();
            if (component.isPresent()) {
                ComponentPeer peer = component.get();
                if (peer != this.lastEntered) {
                    if (this.lastEntered != null) {
                        this.lastEntered.mouseExited(this, this.circuitBoard.getCurrentState());
                    }
                    this.lastEntered = peer;
                    this.lastEntered.mouseEntered(this, this.circuitBoard.getCurrentState());
                    this.setNeedsRepaint();
                }
            } else if (this.lastEntered != null) {
                this.lastEntered.mouseExited(this, this.circuitBoard.getCurrentState());
                this.lastEntered = null;
                this.setNeedsRepaint();
            }
        } else if (this.lastEntered != null) {
            this.lastEntered.mouseExited(this, this.circuitBoard.getCurrentState());
            this.lastEntered = null;
            this.setNeedsRepaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.isMouseInsideCanvas = true;
        this.setNeedsRepaint();
    }

    public void mouseExited(MouseEvent e) {
        this.isMouseInsideCanvas = false;
        this.setNeedsRepaint();
    }

    public void mouseWheelScrolled(ScrollEvent e) {
        if (this.isCtrlDown) {
            if (e.getDeltaY() < 0.0) {
                this.simulatorWindow.zoomOut(e.getX(), e.getY());
            } else {
                this.simulatorWindow.zoomIn(e.getX(), e.getY());
            }
        }
    }

    public void focusGained() {
    }

    public void focusLost() {
        this.isCtrlDown = false;
        this.isShiftDown = false;
        this.mouseExited(null);
        this.simulatorWindow.setClickMode(false);
        this.resetLastPressed();
        this.setNeedsRepaint();
    }

    static interface ThrowableRunnable {
        public void run() throws Exception;
    }

    private static enum SelectingState {
        IDLE,
        HIGHLIGHT_DRAGGED,
        ELEMENT_SELECTED,
        CONNECTION_SELECTED,
        ELEMENT_DRAGGED,
        CONNECTION_DRAGGED,
        PLACING_COMPONENT;

    }
}

