/*
 * Decompiled with CFR 0.152.
 */
package com.ra4king.circuitsim.gui;

import com.ra4king.circuitsim.gui.CircuitManager;
import com.ra4king.circuitsim.gui.ComponentPeer;
import com.ra4king.circuitsim.gui.Connection;
import com.ra4king.circuitsim.gui.EditHistory;
import com.ra4king.circuitsim.gui.GuiElement;
import com.ra4king.circuitsim.gui.LinkWires;
import com.ra4king.circuitsim.gui.PathFinding;
import com.ra4king.circuitsim.simulator.Circuit;
import com.ra4king.circuitsim.simulator.CircuitState;
import com.ra4king.circuitsim.simulator.Component;
import com.ra4king.circuitsim.simulator.SimulationException;
import com.ra4king.circuitsim.simulator.Simulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;

public class CircuitBoard {
    private CircuitManager circuitManager;
    private Circuit circuit;
    private CircuitState currentState;
    private Set<ComponentPeer<?>> components;
    private Set<LinkWires> links;
    private Set<LinkWires> badLinks;
    private Set<GuiElement> moveElements;
    private Set<Connection> connectedPorts = new HashSet<Connection>();
    private Thread computeThread;
    private MoveComputeResult moveResult;
    private boolean addMoveAction;
    private int moveDeltaX;
    private int moveDeltaY;
    private Map<Pair<Integer, Integer>, Set<Connection>> connectionsMap;
    private EditHistory editHistory;
    private Exception lastException;
    private boolean rejoinWiresEnabled = true;

    public CircuitBoard(String name, CircuitManager circuitManager, Simulator simulator, EditHistory editHistory) {
        this.circuitManager = circuitManager;
        this.circuit = new Circuit(name, simulator);
        this.currentState = this.circuit.getTopLevelState();
        this.editHistory = editHistory;
        this.components = new HashSet();
        this.links = new HashSet<LinkWires>();
        this.connectionsMap = new HashMap<Pair<Integer, Integer>, Set<Connection>>();
    }

    public String getName() {
        return this.circuit.getName();
    }

    public void setName(String name) {
        this.circuit.setName(name);
    }

    public String toString() {
        return "CircuitBoard of " + this.circuitManager;
    }

    public void destroy() {
        try {
            this.removeElements(this.components);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        try {
            this.removeElements(this.links.stream().flatMap(l -> l.getWires().stream()).collect(Collectors.toSet()));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.badLinks.clear();
        this.moveElements = null;
        this.circuit.getSimulator().removeCircuit(this.circuit);
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public CircuitState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(CircuitState state) {
        if (this.currentState == null) {
            throw new NullPointerException("CircuitState cannot be null");
        }
        if (state.getCircuit() != this.circuit) {
            throw new IllegalArgumentException("The state does not belong to this circuit.");
        }
        this.currentState = state;
    }

    public Set<ComponentPeer<?>> getComponents() {
        return this.components;
    }

    public Set<LinkWires> getLinks() {
        return this.links;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    private void updateBadLinks() {
        this.badLinks = this.links.stream().filter(link -> !link.isLinkValid()).collect(Collectors.toSet());
        this.lastException = this.badLinks.size() > 0 ? this.badLinks.iterator().next().getLastException() : null;
    }

    public boolean isValidLocation(ComponentPeer<?> component) {
        return component.getX() >= 0 && component.getY() >= 0 && Stream.concat(this.components.stream(), this.moveElements != null ? this.moveElements.stream().filter(e -> e instanceof ComponentPeer) : Stream.empty()).noneMatch(c -> c != component && c.getX() == component.getX() && c.getY() == component.getY());
    }

    public void addComponent(ComponentPeer<?> component) {
        this.addComponent(component, true);
    }

    synchronized void addComponent(ComponentPeer<?> component, boolean splitWires) {
        if (!this.isValidLocation(component)) {
            throw new SimulationException("Cannot place component here.");
        }
        this.circuit.getSimulator().runSync(() -> {
            this.components.add(component);
            try {
                this.circuit.addComponent(component.getComponent());
            }
            catch (Exception exc) {
                this.components.remove(component);
                throw exc;
            }
            try {
                this.editHistory.disable();
                if (splitWires) {
                    HashSet<LinkWires.Wire> toReAdd = new HashSet<LinkWires.Wire>();
                    for (Connection connection : component.getConnections()) {
                        Set<Connection> connections = this.getConnections(connection.getX(), connection.getY());
                        if (connections != null) {
                            for (Connection attached : connections) {
                                LinkWires.Wire wire;
                                LinkWires linkWires = attached.getLinkWires();
                                linkWires.addPort((Connection.PortConnection)connection);
                                this.links.add(linkWires);
                                if (!(attached instanceof Connection.WireConnection) || attached == (wire = (LinkWires.Wire)attached.getParent()).getStartConnection() || attached == wire.getEndConnection()) continue;
                                toReAdd.add(wire);
                            }
                        }
                        this.addConnection(connection);
                    }
                    for (LinkWires.Wire wire : toReAdd) {
                        this.removeWire(wire);
                        this.addWire(wire.getX(), wire.getY(), wire.getLength(), wire.isHorizontal());
                    }
                    this.rejoinWires();
                }
                this.updateBadLinks();
            }
            finally {
                this.editHistory.enable();
            }
        });
        this.editHistory.addAction(EditHistory.EditAction.ADD_COMPONENT, this.circuitManager, component);
    }

    public void updateComponent(ComponentPeer<?> oldComponent, ComponentPeer<?> newComponent) {
        this.circuit.getSimulator().runSync(() -> {
            try {
                this.editHistory.disable();
                this.removeComponent(oldComponent, true);
                try {
                    this.circuit.updateComponent(oldComponent.getComponent(), newComponent.getComponent(), () -> this.components.add(newComponent));
                }
                catch (Exception exc) {
                    this.components.remove(newComponent);
                    throw exc;
                }
                this.addComponent(newComponent);
                this.editHistory.enable();
            }
            catch (Throwable throwable) {
                this.editHistory.enable();
                this.editHistory.addAction(EditHistory.EditAction.UPDATE_COMPONENT, this.circuitManager, oldComponent, newComponent);
                throw throwable;
            }
            this.editHistory.addAction(EditHistory.EditAction.UPDATE_COMPONENT, this.circuitManager, oldComponent, newComponent);
        });
    }

    public boolean isMoving() {
        return this.moveElements != null;
    }

    public void initMove(Set<GuiElement> elements) {
        this.initMove(elements, true);
    }

    void initMove(Set<GuiElement> elements, boolean remove) {
        if (this.moveElements != null) {
            try {
                this.finalizeMove();
            }
            catch (Exception exc) {
                this.circuitManager.getSimulatorWindow().getDebugUtil().logException(exc);
            }
        }
        this.connectedPorts.clear();
        this.moveElements = new LinkedHashSet<GuiElement>(elements);
        this.addMoveAction = remove;
        if (remove) {
            for (GuiElement element : elements) {
                for (Connection connection : element.getConnections()) {
                    if (!(connection instanceof Connection.PortConnection) && connection != ((LinkWires.Wire)connection.getParent()).getEndConnection() && connection != ((LinkWires.Wire)connection.getParent()).getStartConnection() || this.getConnections(connection.getX(), connection.getY()).size() <= 1) continue;
                    this.connectedPorts.add(connection);
                }
            }
            this.editHistory.beginGroup();
            this.removeElements(elements, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveElements(int dx, int dy, boolean extendWires) {
        if (this.moveDeltaX == dx && this.moveDeltaY == dy) {
            return;
        }
        for (GuiElement element : this.moveElements) {
            element.setX(element.getX() + (-this.moveDeltaX + dx));
            element.setY(element.getY() + (-this.moveDeltaY + dy));
        }
        this.moveDeltaX = dx;
        this.moveDeltaY = dy;
        CountDownLatch latch = new CountDownLatch(1);
        CircuitBoard circuitBoard = this;
        synchronized (circuitBoard) {
            this.moveResult = null;
            if (this.computeThread != null) {
                this.computeThread.interrupt();
            }
            if (!extendWires) {
                this.lastException = null;
                return;
            }
            ArrayList<Connection> connectedPorts = new ArrayList<Connection>(this.connectedPorts);
            connectedPorts.sort((p1, p2) -> {
                if (p1.getX() == p2.getX()) {
                    return dy > 0 ? p1.getY() - p2.getY() : p2.getY() - p1.getY();
                }
                return dx > 0 ? p1.getX() - p2.getX() : p2.getX() - p1.getX();
            });
            this.computeThread = new Thread(() -> {
                HashSet paths = new HashSet();
                HashSet<Pair> portsSeen = new HashSet<Pair>();
                for (Connection connectedPort : connectedPorts) {
                    LinkWires linkWires;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    int x = connectedPort.getX();
                    int y = connectedPort.getY();
                    int sx = x - dx;
                    int sy = y - dy;
                    if (!portsSeen.add(new Pair((Object)x, (Object)y))) continue;
                    CircuitBoard circuitBoard = this;
                    synchronized (circuitBoard) {
                        Set<Connection> otherConnections = this.getConnections(sx, sy);
                        if (otherConnections.isEmpty()) {
                            continue;
                        }
                        LinkWires lw = null;
                        for (Connection connection : otherConnections) {
                            LinkWires.Wire wire;
                            if (connection instanceof Connection.PortConnection) {
                                if (lw != null && lw != connection.getLinkWires()) {
                                    throw new IllegalStateException("How is this remotely possible?!");
                                }
                                lw = connection.getLinkWires();
                                continue;
                            }
                            if (!(connection instanceof Connection.WireConnection) || connection != (wire = (LinkWires.Wire)connection.getParent()).getStartConnection() && connection != wire.getEndConnection()) continue;
                            if (lw != null && lw != connection.getLinkWires()) {
                                throw new IllegalStateException("How is this remotely possible?!");
                            }
                            lw = connection.getLinkWires();
                        }
                        linkWires = lw;
                    }
                    HashSet components = new HashSet(this.getComponents());
                    components.addAll(this.moveElements.stream().filter(e -> e instanceof ComponentPeer).map(e -> (ComponentPeer)e).collect(Collectors.toSet()));
                    Pair<Set<LinkWires.Wire>, Set<PathFinding.Point>> pair = PathFinding.bestPath(sx, sy, x, y, (px, py, horizontal) -> {
                        if (px == x && py == y) {
                            return PathFinding.LocationPreference.VALID;
                        }
                        if (px == sx && py == sy) {
                            return PathFinding.LocationPreference.VALID;
                        }
                        Set connections = Stream.concat(connectedPorts.stream(), paths.stream().flatMap(w -> w.getConnections().stream())).filter(c -> c.getX() == px && c.getY() == py).collect(Collectors.toSet());
                        Iterator iterator = this;
                        synchronized (iterator) {
                            connections.addAll(this.getConnections(px, py));
                        }
                        for (Connection connection : connections) {
                            LinkWires.Wire wire;
                            if (connection instanceof Connection.PortConnection) {
                                return PathFinding.LocationPreference.INVALID;
                            }
                            if (connection.getLinkWires() == null || linkWires == null || connection.getLinkWires() == linkWires) {
                                return PathFinding.LocationPreference.PREFER;
                            }
                            if (!(connection instanceof Connection.WireConnection) || (wire = (LinkWires.Wire)connection.getParent()).isHorizontal() != horizontal && connection != wire.getStartConnection() && connection != wire.getEndConnection()) continue;
                            return PathFinding.LocationPreference.INVALID;
                        }
                        for (ComponentPeer component : components) {
                            if (!component.contains(px, py)) continue;
                            return PathFinding.LocationPreference.INVALID;
                        }
                        return PathFinding.LocationPreference.VALID;
                    });
                    if (pair == null) continue;
                    paths.addAll((Collection)pair.getKey());
                }
                CircuitBoard circuitBoard = this;
                synchronized (circuitBoard) {
                    HashSet<LinkWires.Wire> toRemove = new HashSet<LinkWires.Wire>();
                    HashSet<LinkWires.Wire> toAdd = new HashSet<LinkWires.Wire>();
                    for (LinkWires.Wire newWire : paths) {
                        if (this.wireAlreadyExists(newWire) != null) {
                            toRemove.add(newWire);
                            continue;
                        }
                        boolean wasRemoved = false;
                        block9: for (LinkWires wires : this.links) {
                            for (LinkWires.Wire existing : wires.getWires()) {
                                if (existing.getLinkWires() != newWire.getLinkWires() || existing.isHorizontal() != newWire.isHorizontal()) continue;
                                if (existing.equals(newWire)) {
                                    wasRemoved = true;
                                    toRemove.add(existing);
                                    continue block9;
                                }
                                if (existing.isWithin(newWire)) {
                                    wasRemoved = true;
                                    toAdd.addAll(this.spliceWire(newWire, existing));
                                    toRemove.add(existing);
                                    continue block9;
                                }
                                if (newWire.isWithin(existing)) {
                                    wasRemoved = true;
                                    toAdd.addAll(this.spliceWire(existing, newWire));
                                    toRemove.add(newWire);
                                    continue block9;
                                }
                                if (!existing.overlaps(newWire)) continue;
                                Pair<LinkWires.Wire, Pair<LinkWires.Wire, LinkWires.Wire>> pairs = this.spliceOverlappingWire(newWire, existing);
                                toAdd.add((LinkWires.Wire)pairs.getKey());
                                toRemove.add((LinkWires.Wire)((Pair)pairs.getValue()).getKey());
                                wasRemoved = true;
                                continue block9;
                            }
                        }
                        if (wasRemoved) continue;
                        toAdd.add(newWire);
                    }
                    this.moveResult = new MoveComputeResult(toAdd, toRemove);
                    if (this.computeThread == Thread.currentThread()) {
                        this.computeThread = null;
                    }
                    this.lastException = null;
                    this.circuitManager.setNeedsRepaint();
                }
                latch.countDown();
            });
            this.computeThread.start();
            this.lastException = new Exception("Computing...");
        }
        try {
            latch.await(20L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<GuiElement> finalizeMove() {
        HashSet<GuiElement> newSelectedElements;
        MoveComputeResult result;
        if (this.moveElements == null) {
            return null;
        }
        if (!this.addMoveAction) {
            this.editHistory.beginGroup();
        }
        CircuitBoard circuitBoard = this;
        synchronized (circuitBoard) {
            if (this.computeThread != null) {
                this.computeThread.interrupt();
                this.computeThread = null;
            }
            result = this.moveResult;
            this.moveResult = null;
        }
        Set<Object> wiresToAdd = result == null ? new HashSet() : result.wiresToAdd;
        Set<Object> wiresRemoved = result == null ? new HashSet() : result.wiresToRemove;
        boolean cannotMoveHere = false;
        for (GuiElement element2 : this.moveElements) {
            if ((!(element2 instanceof ComponentPeer) || this.isValidLocation((ComponentPeer)element2)) && (!(element2 instanceof LinkWires.Wire) || element2.getX() >= 0 && element2.getY() >= 0)) continue;
            for (GuiElement element1 : this.moveElements) {
                element1.setX(element1.getX() - this.moveDeltaX);
                element1.setY(element1.getY() - this.moveDeltaY);
            }
            wiresToAdd.clear();
            wiresRemoved.clear();
            cannotMoveHere = true;
            break;
        }
        this.removeElements(wiresRemoved);
        ArrayList<Object> elements = new ArrayList<Object>(this.moveElements.size() + wiresToAdd.size());
        elements.addAll(this.moveElements);
        elements.addAll(wiresToAdd);
        HashSet selectedWires = new HashSet();
        ArrayList toThrow = new ArrayList();
        boolean reset = cannotMoveHere;
        this.circuit.getSimulator().runSync(() -> {
            for (GuiElement element : elements) {
                if (element instanceof ComponentPeer) {
                    ComponentPeer component = (ComponentPeer)element;
                    try {
                        this.editHistory.beginGroup();
                        this.editHistory.addAction(EditHistory.EditAction.MOVE_ELEMENT, this.circuitManager, component, this.moveDeltaX, this.moveDeltaY);
                        this.addComponent(component, true);
                        continue;
                    }
                    catch (RuntimeException exc) {
                        this.editHistory.clearGroup();
                        toThrow.clear();
                        toThrow.add(exc);
                        continue;
                    }
                    finally {
                        this.editHistory.endGroup();
                        continue;
                    }
                }
                if (!(element instanceof LinkWires.Wire)) continue;
                LinkWires.Wire wire = (LinkWires.Wire)element;
                try {
                    this.editHistory.beginGroup();
                    this.addWire(wire.getX(), wire.getY(), wire.getLength(), wire.isHorizontal());
                    if (reset || wiresToAdd.contains(wire)) continue;
                    selectedWires.add(new LinkWires.Wire(null, wire));
                    wire.setX(wire.getX() - this.moveDeltaX);
                    wire.setY(wire.getY() - this.moveDeltaY);
                }
                catch (RuntimeException exc) {
                    this.editHistory.clearGroup();
                    toThrow.clear();
                    toThrow.add(exc);
                }
                finally {
                    this.editHistory.endGroup();
                }
            }
        });
        if (!cannotMoveHere) {
            for (GuiElement guiElement : elements) {
                if (!(guiElement instanceof ComponentPeer)) continue;
                ComponentPeer component = (ComponentPeer)guiElement;
                this.circuitManager.getSimulatorWindow().circuitModified(this.circuit, (Component)component.getComponent(), true);
            }
            if (this.addMoveAction && this.moveDeltaX == 0 && this.moveDeltaY == 0) {
                this.editHistory.clearGroup();
            }
            newSelectedElements = new HashSet<GuiElement>();
            this.moveElements.forEach(element -> {
                if (element instanceof ComponentPeer) {
                    newSelectedElements.add((GuiElement)element);
                }
            });
            if (!selectedWires.isEmpty()) {
                this.links.forEach(linkWires -> linkWires.getWires().forEach(wire -> {
                    if (selectedWires.contains(wire)) {
                        newSelectedElements.add((GuiElement)wire);
                    } else {
                        selectedWires.forEach(selectedWire -> {
                            if (selectedWire.overlaps((LinkWires.Wire)wire)) {
                                newSelectedElements.add((GuiElement)wire);
                            }
                        });
                    }
                }));
            }
        } else {
            newSelectedElements = null;
            if (this.addMoveAction) {
                this.editHistory.clearGroup();
            }
        }
        this.editHistory.endGroup();
        this.moveElements = null;
        wiresToAdd.clear();
        this.connectedPorts.clear();
        this.moveDeltaX = 0;
        this.moveDeltaY = 0;
        this.updateBadLinks();
        if (cannotMoveHere) {
            throw new SimulationException("Cannot move components/wires here.");
        }
        if (!toThrow.isEmpty()) {
            throw (RuntimeException)toThrow.get(0);
        }
        return newSelectedElements;
    }

    public void removeElements(Set<? extends GuiElement> elements) {
        this.removeElements(elements, true);
    }

    synchronized void removeElements(Set<? extends GuiElement> elements, boolean removeFromCircuit) {
        this.circuit.getSimulator().runSync(() -> {
            try {
                this.editHistory.beginGroup();
                HashMap<LinkWires, Set> wiresToRemove = new HashMap<LinkWires, Set>();
                HashSet<Object> elementsToRemove = new HashSet<Object>(elements);
                while (!elementsToRemove.isEmpty()) {
                    Iterator iterator = elementsToRemove.iterator();
                    GuiElement element = (GuiElement)iterator.next();
                    iterator.remove();
                    if (element instanceof ComponentPeer) {
                        this.removeComponent((ComponentPeer)element, removeFromCircuit);
                        if (!removeFromCircuit) continue;
                        this.circuit.removeComponent((Component)((ComponentPeer)element).getComponent());
                        continue;
                    }
                    if (!(element instanceof LinkWires.Wire)) continue;
                    LinkWires.Wire wire = (LinkWires.Wire)element;
                    HashSet<Object> toRemove = new HashSet<Object>();
                    block4: for (int i = 0; i < wire.getLength(); ++i) {
                        int x = wire.isHorizontal() ? wire.getX() + i : wire.getX();
                        int y = wire.isHorizontal() ? wire.getY() : wire.getY() + i;
                        for (Connection conn : new HashSet<Connection>(this.getConnections(x, y))) {
                            LinkWires linkWires2;
                            LinkWires.Wire w2;
                            if (!(conn instanceof Connection.WireConnection) || (w2 = (LinkWires.Wire)conn.getParent()).isHorizontal() != wire.isHorizontal()) continue;
                            if (w2.equals(wire)) {
                                toRemove.add(w2);
                                continue block4;
                            }
                            if (w2.isWithin(wire)) {
                                elementsToRemove.addAll(this.spliceWire(wire, w2));
                                toRemove.add(w2);
                                continue block4;
                            }
                            if (wire.isWithin(w2)) {
                                linkWires2 = w2.getLinkWires();
                                this.removeWire(w2);
                                this.spliceWire(w2, wire).forEach(w1 -> this.addWire(linkWires2, (LinkWires.Wire)w1));
                                LinkWires.Wire clone = new LinkWires.Wire(wire);
                                this.addWire(linkWires2, clone);
                                toRemove.add(clone);
                                continue block4;
                            }
                            if (!w2.overlaps(wire)) continue;
                            linkWires2 = w2.getLinkWires();
                            this.removeWire(w2);
                            Pair<LinkWires.Wire, Pair<LinkWires.Wire, LinkWires.Wire>> pairs = this.spliceOverlappingWire(wire, w2);
                            elementsToRemove.add(pairs.getKey());
                            this.addWire(linkWires2, (LinkWires.Wire)((Pair)pairs.getValue()).getKey());
                            this.addWire(linkWires2, (LinkWires.Wire)((Pair)pairs.getValue()).getValue());
                            toRemove.add(((Pair)pairs.getValue()).getKey());
                            continue block4;
                        }
                    }
                    toRemove.forEach(w -> {
                        w.getConnections().forEach(this::removeConnection);
                        LinkWires linkWires = w.getLinkWires();
                        Set<LinkWires.Wire> set = wiresToRemove.containsKey(linkWires) ? (Set)wiresToRemove.get(linkWires) : new HashSet();
                        set.add((LinkWires.Wire)w);
                        wiresToRemove.put(linkWires, set);
                    });
                }
                wiresToRemove.forEach((linkWires, wires) -> {
                    this.links.remove(linkWires);
                    this.links.addAll(linkWires.splitWires((Set<LinkWires.Wire>)wires));
                    wires.forEach(wire -> this.editHistory.addAction(EditHistory.EditAction.REMOVE_WIRE, this.circuitManager, new LinkWires.Wire(null, (LinkWires.Wire)wire)));
                });
                this.rejoinWires();
                this.updateBadLinks();
            }
            finally {
                this.editHistory.endGroup();
            }
        });
    }

    private Set<LinkWires.Wire> spliceWire(LinkWires.Wire toSplice, LinkWires.Wire within) {
        if (!within.isWithin(toSplice)) {
            throw new IllegalArgumentException("toSplice must contain within");
        }
        HashSet<LinkWires.Wire> wires = new HashSet<LinkWires.Wire>();
        if (toSplice.isHorizontal()) {
            int toSpliceEnd;
            int withinEnd;
            if (toSplice.getX() < within.getX()) {
                wires.add(new LinkWires.Wire(toSplice.getLinkWires(), toSplice.getX(), toSplice.getY(), within.getX() - toSplice.getX(), true));
            }
            if ((withinEnd = within.getX() + within.getLength()) < (toSpliceEnd = toSplice.getX() + toSplice.getLength())) {
                wires.add(new LinkWires.Wire(toSplice.getLinkWires(), withinEnd, toSplice.getY(), toSpliceEnd - withinEnd, true));
            }
        } else {
            int toSpliceEnd;
            int withinEnd;
            if (toSplice.getY() < within.getY()) {
                wires.add(new LinkWires.Wire(toSplice.getLinkWires(), toSplice.getX(), toSplice.getY(), within.getY() - toSplice.getY(), false));
            }
            if ((withinEnd = within.getY() + within.getLength()) < (toSpliceEnd = toSplice.getY() + toSplice.getLength())) {
                wires.add(new LinkWires.Wire(toSplice.getLinkWires(), toSplice.getX(), withinEnd, toSpliceEnd - withinEnd, false));
            }
        }
        return wires;
    }

    private Pair<LinkWires.Wire, Pair<LinkWires.Wire, LinkWires.Wire>> spliceOverlappingWire(LinkWires.Wire toSplice, LinkWires.Wire overlap) {
        if (!toSplice.overlaps(overlap)) {
            throw new IllegalArgumentException("wires must overlap");
        }
        if (toSplice.isHorizontal()) {
            LinkWires.Wire left = toSplice.getX() < overlap.getX() ? toSplice : overlap;
            LinkWires.Wire right = toSplice.getX() < overlap.getX() ? overlap : toSplice;
            LinkWires.Wire leftPiece = new LinkWires.Wire(left.getLinkWires(), left.getX(), left.getY(), right.getX() - left.getX(), true);
            LinkWires.Wire midPiece = new LinkWires.Wire(right.getLinkWires(), right.getX(), right.getY(), left.getX() + left.getLength() - right.getX(), true);
            LinkWires.Wire rightPiece = new LinkWires.Wire(right.getLinkWires(), left.getX() + left.getLength(), left.getY(), right.getX() + right.getLength() - left.getX() - left.getLength(), true);
            if (left == toSplice) {
                return new Pair((Object)leftPiece, (Object)new Pair((Object)midPiece, (Object)rightPiece));
            }
            return new Pair((Object)rightPiece, (Object)new Pair((Object)midPiece, (Object)leftPiece));
        }
        LinkWires.Wire top = toSplice.getY() < overlap.getY() ? toSplice : overlap;
        LinkWires.Wire bottom = toSplice.getY() < overlap.getY() ? overlap : toSplice;
        LinkWires.Wire topPiece = new LinkWires.Wire(top.getLinkWires(), top.getX(), top.getY(), bottom.getY() - top.getY(), false);
        LinkWires.Wire midPiece = new LinkWires.Wire(bottom.getLinkWires(), bottom.getX(), bottom.getY(), top.getY() + top.getLength() - bottom.getY(), false);
        LinkWires.Wire bottomPiece = new LinkWires.Wire(bottom.getLinkWires(), top.getX(), top.getY() + top.getLength(), bottom.getY() + bottom.getLength() - top.getY() - top.getLength(), false);
        if (top == toSplice) {
            return new Pair((Object)topPiece, (Object)new Pair((Object)midPiece, (Object)bottomPiece));
        }
        return new Pair((Object)bottomPiece, (Object)new Pair((Object)midPiece, (Object)topPiece));
    }

    public synchronized void addWire(int x, int y, int length, boolean horizontal) {
        if (x < 0 || y < 0 || horizontal && x + length < 0 || !horizontal && y + length < 0) {
            throw new SimulationException("Wire cannot go into negative space.");
        }
        if (length == 0) {
            throw new SimulationException("Length cannot be 0");
        }
        this.circuit.getSimulator().runSync(() -> {
            try {
                int sign;
                this.editHistory.beginGroup();
                LinkWires linkWires = new LinkWires();
                LinkedHashSet<LinkWires.Wire> wiresAdded = new LinkedHashSet<LinkWires.Wire>();
                HashMap<LinkWires.Wire, Connection> toSplit = new HashMap<LinkWires.Wire, Connection>();
                Set<Connection> connections = this.getConnections(x, y);
                if (connections != null) {
                    for (Connection connection : connections) {
                        LinkWires.Wire wire;
                        this.handleConnection(connection, linkWires);
                        GuiElement parent = connection.getParent();
                        if (!(connection instanceof Connection.WireConnection) || connection == (wire = (LinkWires.Wire)parent).getStartConnection() || connection == wire.getEndConnection()) continue;
                        toSplit.put(wire, connection);
                    }
                }
                int lastX = x;
                int lastY = y;
                int i = sign = length / Math.abs(length);
                while (Math.abs(i) <= Math.abs(length)) {
                    LinkWires.Wire surrounding;
                    LinkWires.Wire wire;
                    int len;
                    int yOff;
                    int xOff = horizontal ? i : 0;
                    Connection currConnection = this.findConnection(x + xOff, y + (yOff = horizontal ? 0 : i));
                    if (currConnection != null && (i == length || currConnection instanceof Connection.PortConnection || currConnection == ((LinkWires.Wire)currConnection.getParent()).getStartConnection() || currConnection == ((LinkWires.Wire)currConnection.getParent()).getEndConnection())) {
                        len = horizontal ? currConnection.getX() - lastX : currConnection.getY() - lastY;
                        wire = new LinkWires.Wire(linkWires, lastX, lastY, len, horizontal);
                        surrounding = this.wireAlreadyExists(wire);
                        if (surrounding == null) {
                            wiresAdded.add(wire);
                        }
                        Set<Connection> connections2 = i == length ? this.getConnections(x + xOff, y + yOff) : Collections.singleton(currConnection);
                        for (Connection connection : connections2) {
                            LinkWires.Wire connWire;
                            GuiElement parent = connection.getParent();
                            if (connection instanceof Connection.WireConnection && connection != (connWire = (LinkWires.Wire)parent).getStartConnection() && connection != connWire.getEndConnection()) {
                                toSplit.put((LinkWires.Wire)parent, connection);
                            }
                            this.handleConnection(connection, linkWires);
                        }
                        lastX = currConnection.getX();
                        lastY = currConnection.getY();
                    } else if (i == length) {
                        len = horizontal ? x + xOff - lastX : y + yOff - lastY;
                        wire = new LinkWires.Wire(linkWires, lastX, lastY, len, horizontal);
                        surrounding = this.wireAlreadyExists(wire);
                        if (surrounding == null) {
                            wiresAdded.add(wire);
                        }
                        lastX = x + xOff;
                        lastY = y + yOff;
                    }
                    i += sign;
                }
                for (LinkWires.Wire wire : wiresAdded) {
                    this.addWire(linkWires, wire);
                }
                toSplit.forEach(this::splitWire);
                this.rejoinWires();
                this.updateBadLinks();
            }
            finally {
                this.editHistory.endGroup();
            }
        });
    }

    private LinkWires.Wire wireAlreadyExists(LinkWires.Wire wire) {
        Set<Connection> connections = this.connectionsMap.get(new Pair((Object)wire.getX(), (Object)wire.getY()));
        if (connections == null || connections.isEmpty()) {
            return null;
        }
        for (Connection connection : connections) {
            LinkWires.Wire existing;
            if (!(connection instanceof Connection.WireConnection) || !wire.isWithin(existing = (LinkWires.Wire)connection.getParent())) continue;
            return existing;
        }
        return null;
    }

    private void splitWire(LinkWires.Wire wire, Connection connection) {
        LinkWires links = wire.getLinkWires();
        this.removeWire(wire);
        int len = connection.getX() == wire.getX() ? connection.getY() - wire.getY() : connection.getX() - wire.getX();
        LinkWires.Wire wire1 = new LinkWires.Wire(links, wire.getX(), wire.getY(), len, wire.isHorizontal());
        this.addWire(links, wire1);
        LinkWires.Wire wire2 = new LinkWires.Wire(links, connection.getX(), connection.getY(), wire.getLength() - len, wire.isHorizontal());
        this.addWire(links, wire2);
    }

    private void addWire(LinkWires linkWires, LinkWires.Wire wire) {
        linkWires.addWire(wire);
        this.links.add(linkWires);
        wire.getConnections().forEach(this::addConnection);
        this.editHistory.addAction(EditHistory.EditAction.ADD_WIRE, this.circuitManager, wire);
    }

    private void removeWire(LinkWires.Wire wire) {
        wire.getConnections().forEach(this::removeConnection);
        LinkWires linkWires = wire.getLinkWires();
        if (linkWires == null) {
            return;
        }
        linkWires.removeWire(wire);
        this.editHistory.addAction(EditHistory.EditAction.REMOVE_WIRE, this.circuitManager, new LinkWires.Wire(null, wire));
    }

    void disableRejoinWires() {
        this.rejoinWiresEnabled = false;
    }

    void enableRejoinWires() {
        this.rejoinWiresEnabled = true;
        this.rejoinWires();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rejoinWires() {
        if (!this.rejoinWiresEnabled) {
            return;
        }
        this.editHistory.disable();
        try {
            for (LinkWires linkWires : this.links) {
                HashSet<LinkWires.Wire> removed = new HashSet<LinkWires.Wire>();
                ArrayList<LinkWires.Wire> wires = new ArrayList<LinkWires.Wire>(linkWires.getWires());
                for (int i = 0; i < wires.size(); ++i) {
                    List endWires;
                    Set<Connection> endConns;
                    List startWires;
                    LinkWires.Wire wire = wires.get(i);
                    if (removed.contains(wire)) continue;
                    Connection start = wire.getStartConnection();
                    Connection end = wire.getEndConnection();
                    int x = wire.getX();
                    int y = wire.getY();
                    int length = wire.getLength();
                    Set<Connection> startConns = this.getConnections(start.getX(), start.getY());
                    if (startConns != null && startConns.size() == 2 && (startWires = startConns.stream().filter(conn -> conn != start && conn instanceof Connection.WireConnection).map(conn -> (LinkWires.Wire)conn.getParent()).filter(w -> w.isHorizontal() == wire.isHorizontal()).collect(Collectors.toList())).size() == 1) {
                        LinkWires.Wire startWire = (LinkWires.Wire)startWires.get(0);
                        length += startWire.getLength();
                        if (startWire.getX() < x) {
                            x = startWire.getX();
                        }
                        if (startWire.getY() < y) {
                            y = startWire.getY();
                        }
                        this.removeWire(startWire);
                        removed.add(startWire);
                    }
                    if ((endConns = this.getConnections(end.getX(), end.getY())) != null && endConns.size() == 2 && (endWires = endConns.stream().filter(conn -> conn != end && conn instanceof Connection.WireConnection).map(conn -> (LinkWires.Wire)conn.getParent()).filter(w -> w.isHorizontal() == wire.isHorizontal()).collect(Collectors.toList())).size() == 1) {
                        LinkWires.Wire endWire = (LinkWires.Wire)endWires.get(0);
                        length += endWire.getLength();
                        this.removeWire(endWire);
                        removed.add(endWire);
                    }
                    if (length == wire.getLength()) continue;
                    this.removeWire(wire);
                    removed.add(wire);
                    LinkWires.Wire newWire = new LinkWires.Wire(linkWires, x, y, length, wire.isHorizontal());
                    this.addWire(linkWires, newWire);
                    wires.add(newWire);
                }
            }
        }
        finally {
            this.editHistory.enable();
        }
    }

    private void removeComponent(ComponentPeer<?> component, boolean removeFromComponentsList) {
        if (!this.components.contains(component)) {
            return;
        }
        for (Connection connection : component.getConnections()) {
            this.removeConnection(connection);
            Connection.PortConnection portConnection = (Connection.PortConnection)connection;
            LinkWires linkWires = portConnection.getLinkWires();
            if (linkWires == null) continue;
            linkWires.removePort(portConnection);
            if (!linkWires.isEmpty()) continue;
            linkWires.clear();
            this.links.remove(linkWires);
        }
        if (removeFromComponentsList) {
            this.components.remove(component);
        }
        this.editHistory.addAction(EditHistory.EditAction.REMOVE_COMPONENT, this.circuitManager, component);
    }

    private void handleConnection(Connection connection, LinkWires linkWires) {
        LinkWires linksToMerge = connection.getLinkWires();
        if (linksToMerge == null) {
            if (connection instanceof Connection.PortConnection) {
                linkWires.addPort((Connection.PortConnection)connection);
            } else if (connection instanceof Connection.WireConnection) {
                linkWires.addWire((LinkWires.Wire)connection.getParent());
            }
        } else if (linkWires != linksToMerge) {
            this.links.remove(linksToMerge);
            linkWires.merge(linksToMerge);
        }
        this.links.add(linkWires);
    }

    public Connection findConnection(int x, int y) {
        Pair pair = new Pair((Object)x, (Object)y);
        return this.connectionsMap.containsKey(pair) ? this.connectionsMap.get(pair).iterator().next() : null;
    }

    public Set<Connection> getConnections(int x, int y) {
        Pair pair = new Pair((Object)x, (Object)y);
        return this.connectionsMap.getOrDefault(pair, Collections.emptySet());
    }

    public void paint(GraphicsContext graphics, LinkWires highlightLinkWires) {
        CircuitState currentState = new CircuitState(this.currentState);
        this.components.forEach(component -> {
            if (this.moveElements == null || !this.moveElements.contains(component)) {
                this.paintComponent(graphics, currentState, (ComponentPeer<?>)component);
            }
        });
        for (LinkWires linkWires : this.links) {
            for (LinkWires.Wire wire2 : linkWires.getWires()) {
                this.paintWire(graphics, currentState, wire2, linkWires == highlightLinkWires);
            }
        }
        if (this.badLinks != null) {
            for (LinkWires badLink : this.badLinks) {
                Stream.concat(badLink.getPorts().stream(), badLink.getInvalidPorts().stream()).forEach(port -> {
                    graphics.setFill((Paint)Color.BLACK);
                    graphics.fillText(String.valueOf(port.getPort().getLink().getBitSize()), (double)(port.getScreenX() + 11), (double)(port.getScreenY() + 21));
                    graphics.setStroke((Paint)Color.ORANGE);
                    graphics.setFill((Paint)Color.ORANGE);
                    graphics.strokeOval((double)(port.getScreenX() - 2), (double)(port.getScreenY() - 2), 10.0, 10.0);
                    graphics.fillText(String.valueOf(port.getPort().getLink().getBitSize()), (double)(port.getScreenX() + 10), (double)(port.getScreenY() + 20));
                });
            }
        }
        if (this.moveElements != null) {
            graphics.save();
            graphics.setGlobalAlpha(0.5);
            for (GuiElement element : this.moveElements) {
                if (element instanceof ComponentPeer) {
                    this.paintComponent(graphics, currentState, (ComponentPeer)element);
                    continue;
                }
                if (!(element instanceof LinkWires.Wire)) continue;
                this.paintWire(graphics, currentState, (LinkWires.Wire)element, false);
            }
            MoveComputeResult result = this.moveResult;
            if (result != null) {
                graphics.setFill((Paint)Color.RED);
                result.wiresToRemove.forEach(wire -> wire.paint(graphics));
                graphics.setFill((Paint)Color.BLACK);
                result.wiresToAdd.forEach(wire -> wire.paint(graphics));
            }
            graphics.restore();
        }
    }

    private void paintComponent(GraphicsContext graphics, CircuitState state, ComponentPeer<?> component) {
        graphics.save();
        component.paint(graphics, state);
        graphics.restore();
        for (Connection.PortConnection connection : component.getConnections()) {
            connection.paint(graphics, state);
        }
    }

    private void paintWire(GraphicsContext graphics, CircuitState state, LinkWires.Wire wire, boolean highlight) {
        Connection endConn;
        graphics.save();
        wire.paint(graphics, state, highlight ? 4.0 : 2.0);
        graphics.restore();
        Connection startConn = wire.getStartConnection();
        if (this.getConnections(startConn.getX(), startConn.getY()).size() > 2) {
            startConn.paint(graphics, state);
        }
        if (this.getConnections((endConn = wire.getStartConnection()).getX(), endConn.getY()).size() > 2) {
            endConn.paint(graphics, state);
        }
    }

    private synchronized void addConnection(Connection connection) {
        Pair pair = new Pair((Object)connection.getX(), (Object)connection.getY());
        HashSet<Connection> set = this.connectionsMap.containsKey(pair) ? this.connectionsMap.get(pair) : new HashSet<Connection>();
        set.add(connection);
        this.connectionsMap.put((Pair<Integer, Integer>)pair, set);
    }

    private synchronized void removeConnection(Connection connection) {
        Pair pair = new Pair((Object)connection.getX(), (Object)connection.getY());
        if (!this.connectionsMap.containsKey(pair)) {
            return;
        }
        Set<Connection> set = this.connectionsMap.get(pair);
        set.remove(connection);
        if (set.isEmpty()) {
            this.connectionsMap.remove(pair);
        }
    }

    private static class MoveComputeResult {
        final Set<LinkWires.Wire> wiresToAdd;
        final Set<LinkWires.Wire> wiresToRemove;

        MoveComputeResult(Set<LinkWires.Wire> wiresToAdd, Set<LinkWires.Wire> wiresToRemove) {
            this.wiresToAdd = wiresToAdd;
            this.wiresToRemove = wiresToRemove;
        }
    }
}

